/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.components.common.message.notify.NotificationServer;
import com.trs.components.common.message.notify.Notifier;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.uftp.FtpConfig;
import com.trs.infra.util.uftp.FtpConnection;
import com.trs.infra.util.uftp.FtpConnectionCache;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.ContainerUtil;
import org.aton.container.IClearable;

public class UftpConnectionCacheManager
implements IClearable {
    private static final Logger s_logger = Logger.getLogger(UftpConnectionCacheManager.class);
    private Map m_oCacheMap = new HashMap();

    public FtpConnectionCache getConnectionCache(PublishDistribution dist) throws WCMException {
        FtpConnectionCache cache = (FtpConnectionCache)this.m_oCacheMap.get(dist.getKey());
        if (cache != null) {
            return cache;
        }
        this.insertFtpCache(dist, this.m_oCacheMap);
        return (FtpConnectionCache)this.m_oCacheMap.get(dist.getKey());
    }

    private FtpConnectionCache createFtpCache(PublishDistribution _distribution) throws WCMException {
        FtpConfig config = new FtpConfig();
        config.setProtocol(_distribution.getTargetType());
        config.setHost(_distribution.getTargetServer());
        config.setPort(_distribution.getTargetPort());
        config.setAnonymous(_distribution.isAnonymous());
        config.setUserName(_distribution.getLoginUser());
        config.setPassWord(_distribution.getLoginPassword());
        config.setRootPath(_distribution.getDataPath());
        config.setPassive(_distribution.getPassiveMode());
        config.setMaxClient(60);
        try {
            FtpConnectionCache cache = new FtpConnectionCache(config);
            FtpConnection wrapper = cache.getConnectionWrapper();
            if (wrapper.isReadOnly()) {
                cache.clear();
                throw new WCMException("[" + config + I18NMessage.get(UftpConnectionCacheManager.class, "UftpConnectionCacheManager.label1", "]\u662f\u53ea\u8bfb\u7684\uff01"));
            }
            cache.initialize();
            return cache;
        }
        catch (Exception ex) {
            String EVENT = "Publish.WhenMakeFTPConnectionError";
            if (NotificationServer.getInstance().needNotifyForEvent("Publish.WhenMakeFTPConnectionError")) {
                Notifier notifier = new Notifier();
                notifier.setParameter("FTPDistributionInfo", _distribution.toString());
                notifier.setParameter("Message", I18NMessage.get(UftpConnectionCacheManager.class, "UftpConnectionCacheManager.label2", "\u5efa\u7acbFTP\u8fde\u63a5\u5931\u8d25!\n\u5206\u53d1\u4fe1\u606f\u4e3a\uff1a") + _distribution);
                try {
                    notifier.executeOnEvent("Publish.WhenMakeFTPConnectionError");
                }
                catch (WCMException e) {
                    e.printStackTrace();
                }
            }
            WCMException wcme = null;
            wcme = ex instanceof WCMException ? (WCMException)ex : new WCMException(I18NMessage.get(UftpConnectionCacheManager.class, "UftpConnectionCacheManager.label3", "\u521d\u59cb\u5316\u5206\u53d1\u76ee\u5f55\u7684FTP\u5931\u8d25\uff01") + _distribution, ex);
            throw wcme;
        }
    }

    private synchronized void insertFtpCache(PublishDistribution _distribution, Map _cache) throws WCMException {
        Integer key = _distribution.getKey();
        if (_cache.get(key) != null) {
            return;
        }
        FtpConnectionCache cache = this.createFtpCache(_distribution);
        if (cache == null) {
            return;
        }
        _cache.put(key, cache);
    }

    private synchronized void deleteFtpCache(PublishDistribution dist) {
        FtpConnectionCache cache = (FtpConnectionCache)this.m_oCacheMap.remove(dist.getKey());
        if (cache != null) {
            cache.clear();
        }
    }

    private boolean isSupported(String sType) {
        if (sType == null) {
            return false;
        }
        return (sType = sType.toUpperCase()).equals("FTP") || sType.equals("SFTP") || sType.equals("FTPS") || sType.equals("GFTP");
    }

    public void clear() {
        if (this.m_oCacheMap == null) {
            return;
        }
        ContainerUtil.clearContainer((Map)this.m_oCacheMap);
        this.m_oCacheMap = null;
    }

    public void deleteDistribution(PublishDistribution _distribution) throws WCMException {
        if (_distribution != null && this.isSupported(_distribution.getTargetType())) {
            this.deleteFtpCache(_distribution);
        }
    }
}

