/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.definition.FlowActions;
import com.trs.cms.process.definition.FlowCondition;
import com.trs.cms.process.definition.FlowConditions;
import com.trs.cms.process.definition.FlowRule;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.IConditionHandler;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class RuleExecuteHelper {
    private static Logger logger = Logger.getLogger(RuleExecuteHelper.class);

    public static void executeRules(ExecuteContext _oExecContext, FlowRule[] _pRules) throws WCMException {
        if (_pRules == null || _pRules.length == 0) {
            return;
        }
        for (int i = 0; i < _pRules.length; ++i) {
            FlowRule rule = _pRules[i];
            boolean bAccordWith = true;
            FlowConditions contConditions = rule.getConditions(null);
            int nSize = contConditions.size();
            for (int j = 0; j < nSize; ++j) {
                FlowCondition condition = (FlowCondition)contConditions.getAt(j);
                if (condition == null) continue;
                boolean bTemp = false;
                IConditionHandler conditionHandler = null;
                try {
                    conditionHandler = (IConditionHandler)Class.forName(condition.getHandler()).newInstance();
                    bTemp = conditionHandler.isAccordWith(_oExecContext, condition);
                }
                catch (Throwable e) {
                    logger.warn((Object)I18NMessage.get(RuleExecuteHelper.class, "RuleExecuteHelper.label1", "\u6307\u5b9a\u7684Handler\u5b9e\u4f8b\u5316\u6216\u8005\u5224\u65ad\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01"), e);
                }
                if (bTemp) {
                    if (condition.isAndOperator()) continue;
                    bAccordWith = true;
                    break;
                }
                if (!condition.isAndOperator()) continue;
                bAccordWith = false;
                break;
            }
            if (!bAccordWith) continue;
            FlowActions contActions = rule.getActions(null);
            int nSize2 = contActions.size();
            for (int j = 0; j < nSize2; ++j) {
                FlowAction action = (FlowAction)contActions.getAt(j);
                if (action == null) continue;
                IActionHandler actionHandler = null;
                try {
                    actionHandler = (IActionHandler)Class.forName(action.getHandler()).newInstance();
                }
                catch (Throwable e) {
                    logger.warn((Object)(I18NMessage.get(RuleExecuteHelper.class, "RuleExecuteHelper.label2", "\u6307\u5b9a\u7684Handler[") + action.getHandler() + I18NMessage.get(RuleExecuteHelper.class, "RuleExecuteHelper.label3", "]\u5b9e\u4f8b\u5316\u6709\u8bef\uff01")), e);
                    continue;
                }
                try {
                    actionHandler.execute(_oExecContext, action);
                    continue;
                }
                catch (Throwable e) {
                    logger.warn((Object)("Handler[" + action.getHandler() + I18NMessage.get(RuleExecuteHelper.class, "RuleExecuteHelper.label4", "]\u6267\u884c\u5931\u8d25\uff01")), e);
                }
            }
        }
    }
}

