/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.auth.domain.IRightObj;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ICMSObjSubstanceContent;
import com.trs.infra.common.WCMException;

public class GroupRightObjImpl
implements IRightObj {
    public static boolean IS_WITH_PARENT = true;
    private Group m_oCurrGroup = null;

    public GroupRightObjImpl() {
    }

    public GroupRightObjImpl(int _nId) throws WCMException {
        this.loadById(_nId);
    }

    public GroupRightObjImpl(CMSObj _cmsObj) {
        this.makeFrom(_cmsObj);
    }

    @Override
    public boolean hasRight(User _currUser, int _nRightIndex) throws WCMException {
        boolean bHasRight;
        Group grpParent = this.m_oCurrGroup.getParent();
        if (this.m_oCurrGroup.isAddMode()) {
            if (grpParent == null) {
                return _currUser.isAdministrator();
            }
            GroupRightObjImpl rightObj = new GroupRightObjImpl(grpParent);
            return rightObj.hasRight(_currUser, _nRightIndex);
        }
        if (_nRightIndex == 12) {
            return _currUser.isAdministrator() || _currUser.equals(this.m_oCurrGroup.getCrUser());
        }
        boolean bl = bHasRight = _currUser.isAdministrator() || _currUser.equals(this.m_oCurrGroup.getCrUser()) || this.m_oCurrGroup.isAdministrator(_currUser);
        if (bHasRight) {
            return true;
        }
        if (grpParent == null || !IS_WITH_PARENT) {
            return false;
        }
        GroupRightObjImpl rightObj = new GroupRightObjImpl(grpParent);
        return rightObj.hasRight(_currUser, _nRightIndex);
    }

    public boolean equals(Object _another) {
        if (_another == this) {
            return true;
        }
        if (!(_another instanceof ICMSObjSubstanceContent)) {
            return false;
        }
        ICMSObjSubstanceContent anotherCMS = (ICMSObjSubstanceContent)_another;
        return this.getType() == anotherCMS.getType() && this.getId() == anotherCMS.getId();
    }

    @Override
    public int getType() {
        return 201;
    }

    @Override
    public int getId() {
        if (this.m_oCurrGroup == null) {
            return 0;
        }
        return this.m_oCurrGroup.getId();
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_oCurrGroup;
    }

    @Override
    public void setSubstance(CMSObj _cmsObj) {
        this.m_oCurrGroup = (Group)_cmsObj;
    }

    @Override
    public String getInfo() {
        if (this.m_oCurrGroup == null) {
            return null;
        }
        return this.m_oCurrGroup.toString();
    }

    @Override
    public boolean loadById(int _nId) throws WCMException {
        this.m_oCurrGroup = Group.findById(_nId);
        return this.m_oCurrGroup != null;
    }

    @Override
    public void makeFrom(CMSObj _cmsObj) {
        this.m_oCurrGroup = (Group)_cmsObj;
    }
}

