/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelContentLink;
import com.trs.components.wcm.content.persistent.ChannelContentLinks;
import com.trs.components.wcm.content.persistent.ContentLink;
import com.trs.components.wcm.content.persistent.ContentLinkType;
import com.trs.components.wcm.content.persistent.ContentLinkTypes;
import com.trs.components.wcm.content.persistent.ContentLinks;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.contentlink.TxtFileParserForContentLink;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;

public class ContentLinkServiceProvider
implements IGlueServiceProvider {
    private static DBManager m_oDbManager = null;

    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
        String linkIds = _methodContext.getObjectIds();
        if (CMyString.isEmpty(linkIds)) {
            return;
        }
        User currUser = ContextHelper.getLoginUser();
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        int nSiteId = _methodContext.getValue("SiteId", 0);
        if (nChannelId != 0) {
            Channel channel = this.findChannelById(nChannelId);
            this.validateRight(currUser, channel, WCMRightTypes.CONTENT_LINK_DELETE, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label1", "\u5220\u9664\u70ed\u8bcd"));
        } else if (nSiteId != 0) {
            WebSite website = WebSite.findById(nSiteId);
            if (website == null) {
                throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label17", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + nSiteId + "]\uff01");
            }
            this.validateRight(currUser, website, WCMRightTypes.CONTENT_LINK_DELETE, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label1", "\u5220\u9664\u70ed\u8bcd"));
        } else {
            throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label18", "\u6ca1\u6709\u4f20\u5165\u6709\u6548\u7684ChannelId\u6216SiteId!"));
        }
        ChannelContentLinks links = ChannelContentLinks.findByIds(currUser, linkIds);
        links.removeAll(true);
    }

    public Object querySysLinks(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
        this.validateRight(loginUser, channel, WCMRightTypes.CONTENT_LINK_LIST, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label2", "\u83b7\u53d6\u5185\u5bb9\u8d85\u94fe\u63a5\u7684\u4fe1\u606f"));
        int nLinkType = 0;
        try {
            String sLinkType = channel.getAttributeValue("ContentLinkType");
            nLinkType = Integer.parseInt(sLinkType);
        }
        catch (NumberFormatException sLinkType) {
            // empty catch block
        }
        ContentLinks links = new ContentLinks(loginUser);
        if (nLinkType <= 0) {
            return links;
        }
        WCMFilter filter = new WCMFilter("", "ContentLinkType=?", "");
        filter.addSearchValues(0, nLinkType);
        filter.mergeWith(_methodContext.getExtraWCMFilter());
        links.open(filter);
        return links;
    }

    @Override
    public Object query(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nChnlId = _methodContext.getValue("ChannelId", 0);
        int nSiteId = _methodContext.getValue("SiteId", 0);
        boolean bContainsSite = _methodContext.getValue("containsSite", false);
        int nTempSiteId = 0;
        if (nChnlId > 0) {
            Channel channel = this.findChannelById(nChnlId);
            nTempSiteId = channel.getSiteId();
            if (!(AuthServer.hasRight(loginUser, (CMSObj)channel, WCMRightTypes.CONTENT_LINK_LIST) || AuthServer.hasRight(loginUser, (CMSObj)channel, 32) || AuthServer.hasRight(loginUser, (CMSObj)channel, 31))) {
                throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label7", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650\u5728(") + channel + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label9", ")\u4e0a\u6267\u884c[") + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label2", "\u83b7\u53d6\u5185\u5bb9\u8d85\u94fe\u63a5\u7684\u4fe1\u606f") + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label10", "]\u64cd\u4f5c\uff01"));
            }
        }
        ChannelContentLinks links = new ChannelContentLinks(loginUser);
        String orderBy = _methodContext.getValue("OrderBy");
        if (CMyString.isEmpty(orderBy)) {
            orderBy = "LinkOrder desc";
        }
        WCMFilter filter = new WCMFilter("", "", orderBy);
        if (nChnlId > 0) {
            StringBuffer sWhere = new StringBuffer();
            if (bContainsSite) {
                sWhere.append("ChannelId=? or SiteId=?");
                filter.addSearchValues(0, nChnlId);
                filter.addSearchValues(1, nTempSiteId);
            } else {
                sWhere.append("ChannelId=?");
                filter.addSearchValues(0, nChnlId);
            }
            String sParentWhere = this.getParentChannelWhere(nChnlId, filter);
            if (!CMyString.isEmpty(sParentWhere)) {
                sWhere.append(sParentWhere);
            }
            filter.setWhere(sWhere.toString());
        } else {
            filter.setWhere("SiteId=?");
            filter.addSearchValues(0, nSiteId);
        }
        filter.mergeWith(_methodContext.getExtraWCMFilter());
        links.open(filter);
        if (!bContainsSite) {
            return links;
        }
        return this.excludeSimilar(links, nChnlId, nTempSiteId);
    }

    private ChannelContentLinks excludeSimilar(ChannelContentLinks _sLinks, int _sChnlId, int _sSiteId) throws WCMException {
        Channel currChannel;
        User loginUser = this.getLoginUser();
        ChannelContentLink currLink = null;
        ChannelContentLink tempLink = null;
        ChannelContentLinks currLinks = new ChannelContentLinks(loginUser);
        ChannelContentLinks tempLinks = new ChannelContentLinks(loginUser);
        ChannelContentLinks parentAndSiteLinks = new ChannelContentLinks(loginUser);
        WCMFilter filter = new WCMFilter("", "ChannelId=?", "LinkOrder desc");
        filter.addSearchValues(0, _sChnlId);
        currLinks.open(filter);
        filter = new WCMFilter("", "SiteId=?", "LinkOrder desc");
        filter.addSearchValues(0, _sSiteId);
        tempLinks.open(filter);
        filter = new WCMFilter("", "", "LinkOrder desc");
        StringBuffer sWhere = new StringBuffer();
        sWhere.append("SiteId=?");
        filter.addSearchValues(0, _sSiteId);
        String sParentWhere = this.getParentChannelWhere(_sChnlId, filter);
        if (!CMyString.isEmpty(sParentWhere)) {
            sWhere.append(sParentWhere);
        }
        filter.setWhere(sWhere.toString());
        parentAndSiteLinks.open(filter);
        if (currLinks.size() > 0 && parentAndSiteLinks.size() > 0) {
            for (int i = 0; i < currLinks.size(); ++i) {
                currLink = (ChannelContentLink)currLinks.getAt(i);
                if (currLink == null) continue;
                for (int j = 0; j < parentAndSiteLinks.size(); ++j) {
                    tempLink = (ChannelContentLink)parentAndSiteLinks.getAt(j);
                    if (tempLink == null || !currLink.getName().equalsIgnoreCase(tempLink.getName())) continue;
                    _sLinks.remove(tempLink, false);
                }
            }
        }
        if ((currChannel = Channel.findById(_sChnlId)) == null) {
            return null;
        }
        for (Channel parent = currChannel.getParent(); parent != null; parent = parent.getParent()) {
            filter = new WCMFilter("", "ChannelId=? and ISUSEDINCHILDREN=1", "LinkOrder desc");
            filter.addSearchValues(0, parent.getId());
            currLinks.open(filter);
            _sLinks = this.filterParentLinks(currLinks, parentAndSiteLinks, _sLinks);
        }
        return _sLinks;
    }

    private ChannelContentLinks filterParentLinks(ChannelContentLinks _siteLinks, ChannelContentLinks _siteAndParentLinks, ChannelContentLinks _resultLinks) throws WCMException {
        ChannelContentLink currLink = null;
        ChannelContentLink tempLink = null;
        if (_siteLinks.size() > 0 && _siteAndParentLinks.size() > 0) {
            for (int i = 0; i < _siteLinks.size(); ++i) {
                currLink = (ChannelContentLink)_siteLinks.getAt(i);
                if (currLink == null) continue;
                for (int j = 0; j < _siteAndParentLinks.size(); ++j) {
                    tempLink = (ChannelContentLink)_siteAndParentLinks.getAt(j);
                    if (tempLink == null || !currLink.getName().equalsIgnoreCase(tempLink.getName()) || currLink.getId() <= tempLink.getId()) continue;
                    _resultLinks.remove(tempLink, false);
                }
            }
        }
        return _resultLinks;
    }

    public String getParentChannelWhere(int _nChannelId, WCMFilter filter) throws WCMException {
        StringBuffer sWhere = new StringBuffer();
        Channel currChannel = Channel.findById(_nChannelId);
        if (currChannel == null) {
            return null;
        }
        Channel parent = currChannel.getParent();
        if (parent == null) {
            return null;
        }
        sWhere.append(" or (ISUSEDINCHILDREN=1 And ChannelId IN(?");
        filter.addSearchValues(parent.getId());
        for (parent = parent.getParent(); parent != null; parent = parent.getParent()) {
            sWhere.append(",?");
            filter.addSearchValues(parent.getId());
        }
        sWhere.append(")) ");
        return sWhere.toString();
    }

    public Object queryLinkType(MethodContext _context) throws WCMException {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannelById(_context.getValue("ChannelId", 0));
        this.validateRight(loginUser, channel, WCMRightTypes.CONTENT_LINK_DETAIL, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label2", "\u83b7\u53d6\u5185\u5bb9\u8d85\u94fe\u63a5\u7684\u4fe1\u606f"));
        int nLinkType = 0;
        try {
            String sLinkType = channel.getAttributeValue("ContentLinkType");
            nLinkType = Integer.parseInt(sLinkType);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ContentLinkType.findById(nLinkType);
    }

    public Object queryTypes(MethodContext _context) throws WCMException {
        User loginUser = this.getLoginUser();
        ContentLinkTypes types = new ContentLinkTypes(loginUser);
        types.open(_context.getExtraWCMFilter());
        return types;
    }

    public void setLinkType(MethodContext _context) throws WCMException {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannelById(_context.getValue("ChannelId", 0));
        this.validateRight(loginUser, channel, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label3", "\u8bbe\u7f6e\u680f\u76ee\u70ed\u8bcd\u5206\u7c7b"));
        int nLinkTypeId = _context.getValue("ContentLinkTypeId", 0);
        String attr = channel.getAttribute();
        AttributesString attrs = new AttributesString(attr);
        attrs.putAttributeValue("ContentLinkType", String.valueOf(nLinkTypeId));
        channel.setAttribute(attrs);
        channel.save();
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        int nLinkId = _methodContext.getObjectId();
        ChannelContentLink link = ChannelContentLink.findById(nLinkId);
        User loginUser = this.getLoginUser();
        if (link != null && link.canEdit(loginUser)) {
            link.setName(_methodContext.getValue("LinkName"));
            link.save(loginUser);
        }
        return nLinkId;
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        int nId = _methodContext.getObjectId();
        ChannelContentLink link = ChannelContentLink.findById(nId);
        if (link == null && link == null) {
            throw new WCMException(200006, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label4", "\u6ca1\u6709\u627e\u5230[Id=") + nId + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label5", "]\u7684\u70ed\u8bcd\uff01"));
        }
        return link;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        return null;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private Channel findChannelById(int _nObjectId) throws WCMException {
        Channel channel = Channel.findById(_nObjectId);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label6", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + _nObjectId + "]\uff01");
        }
        return channel;
    }

    private void validateRight(User _loginUser, BaseChannel _channelOrSite, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (!AuthServer.hasRight(_loginUser, (CMSObj)_channelOrSite, _nRightIndex)) {
            throw new WCMException(I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label7", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label8", "]\u6ca1\u6709\u6743\u9650\u5728(") + _channelOrSite + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label9", ")\u4e0a\u6267\u884c[") + _sOperDesc + I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label10", "]\u64cd\u4f5c\uff01"));
        }
    }

    public Object addLinkInChannel(MethodContext _context) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        int nChnlId = _context.getValue("ChannelId", 0);
        int nSiteId = _context.getValue("SiteId", 0);
        if (nChnlId > 0) {
            Channel channel = this.findChannelById(nChnlId);
            this.validateRight(currUser, channel, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label21", "\u65b0\u5efa\u680f\u76ee\u70ed\u8bcd"));
        } else {
            WebSite website = WebSite.findById(nSiteId);
            this.validateRight(currUser, website, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label22", "\u65b0\u5efa\u7ad9\u70b9\u70ed\u8bcd"));
        }
        ChannelContentLink link = new ChannelContentLink();
        link.setName(_context.getValue("LinkName"));
        link.setLinkTitle(_context.getValue("LinkTitle"));
        link.setLinkUrl(_context.getValue("LinkUrl"));
        link.setOrder(_context.getValue("LinkOrder", -1));
        boolean bUsedChildren = _context.getValue("ISUSEDINCHILDREN", 0) == 1;
        link.setUsedInChildren(bUsedChildren);
        if (nChnlId > 0) {
            link.setChnlId(nChnlId);
        } else {
            link.setSiteId(nSiteId);
            link.setChnlId(0);
        }
        link.save(currUser);
        return String.valueOf(link.getId());
    }

    public Object editLinkInChannel(MethodContext _context) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        int nChannelId = _context.getValue("ChannelId", 0);
        int nSiteId = _context.getValue("SiteId", 0);
        if (nChannelId > 0) {
            Channel channel = Channel.findById(nChannelId);
            this.validateRight(currUser, channel, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label12", "\u7f16\u8f91\u680f\u76ee\u70ed\u8bcd"));
        } else {
            WebSite website = WebSite.findById(nSiteId);
            this.validateRight(currUser, website, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label18", "\u7f16\u8f91\u7ad9\u70b9\u70ed\u8bcd"));
        }
        int nLinkId = _context.getValue("LinkId", 0);
        ChannelContentLink link = ChannelContentLink.findById(nLinkId);
        if (link == null) {
            throw new WCMException(200006, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u70ed\u8bcd[Id=") + nLinkId + "]!");
        }
        if (!link.canEdit(currUser)) {
            throw new WCMException(1012, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label14", "\u65e0\u6cd5\u9501\u5b9a\u5bf9\u8c61\u8fdb\u884c\u7f16\u8f91!"));
        }
        link.setName(_context.getValue("LinkName"));
        link.setLinkTitle(_context.getValue("LinkTitle"));
        link.setLinkUrl(_context.getValue("LinkUrl"));
        link.setOrder(_context.getValue("LinkOrder", -1));
        boolean bUsedChildren = _context.getValue("ISUSEDINCHILDREN", 0) == 1;
        link.setUsedInChildren(bUsedChildren);
        link.save(currUser);
        return String.valueOf(nLinkId);
    }

    public void createFromFile(MethodContext _context) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        int nChannelId = _context.getValue("ChannelId", 0);
        int nSiteId = _context.getValue("SiteId", 0);
        if (nChannelId > 0) {
            Channel channel = Channel.findById(nChannelId);
            this.validateRight(currUser, channel, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label20", "\u6279\u91cf\u521b\u5efa\u70ed\u8bcd"));
        } else {
            WebSite website = WebSite.findById(nSiteId);
            this.validateRight(currUser, website, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label20", "\u6279\u91cf\u521b\u5efa\u70ed\u8bcd"));
        }
        String sImportFile = _context.getValue("ImportFile");
        sImportFile = FilesMan.getFilesMan().mapFilePath(sImportFile, 0) + sImportFile;
        TxtFileParserForContentLink parser = new TxtFileParserForContentLink();
        Map map = parser.parse(sImportFile);
        for (Object key : map.keySet()) {
            ArrayList infoList = (ArrayList)map.get(key);
            ChannelContentLink contentLink = new ChannelContentLink();
            contentLink.setName((String)infoList.get(0));
            contentLink.setLinkUrl((String)infoList.get(1));
            if (nChannelId > 0) {
                contentLink.setChnlId(nChannelId);
                boolean bUsedInChildren = Integer.parseInt((String)infoList.get(2)) == 1;
                contentLink.setUsedInChildren(bUsedInChildren);
            } else {
                contentLink.setSiteId(nSiteId);
                contentLink.setChnlId(0);
            }
            contentLink.setLinkTitle((String)infoList.get(3));
            contentLink.save(currUser);
        }
    }

    public void importSysLinks(MethodContext _context) throws WCMException {
        User loginUser = this.getLoginUser();
        int nChnlId = _context.getValue("ChannelId", 0);
        int nSiteId = _context.getValue("SiteId", 0);
        int nSameNameOpera = _context.getValue("sameNameOpera", 0);
        if (nChnlId > 0) {
            Channel channel = this.findChannelById(nChnlId);
            this.validateRight(loginUser, channel, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label15", "\u8bbe\u7f6e\u680f\u76ee\u70ed\u8bcd"));
        } else {
            WebSite website = WebSite.findById(nSiteId);
            this.validateRight(loginUser, website, WCMRightTypes.CONTENT_LINK_ADD, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label19", "\u8bbe\u7f6e\u7ad9\u70b9\u70ed\u8bcd"));
        }
        String linktypeIds = _context.getValue("ContentLinkTypeIds");
        if (!CMyString.isEmpty(linktypeIds)) {
            String sWhere = "ContentLinkType in(" + linktypeIds + ")";
            WCMFilter filter = new WCMFilter("", sWhere, "ContentLinkType,ContentLinkId desc");
            ContentLinks links = new ContentLinks(loginUser);
            links.open(filter);
            ContentLink link = null;
            ChannelContentLink chnlLink = null;
            int linkId = 0;
            int size = links.size();
            for (int i = 0; i < size; ++i) {
                link = (ContentLink)links.getAt(i);
                if (link == null || (linkId = nChnlId > 0 ? this.existsLink(link, nChnlId, true) : this.existsLink(link, nSiteId, false)) != 0 && nSameNameOpera == 0) continue;
                chnlLink = linkId != 0 ? ChannelContentLink.findById(linkId) : new ChannelContentLink();
                if (nChnlId > 0) {
                    chnlLink.setChnlId(nChnlId);
                } else {
                    chnlLink.setSiteId(nSiteId);
                    chnlLink.setChnlId(0);
                }
                chnlLink.setName(link.getName());
                chnlLink.setLinkTitle(link.getLinkTitle());
                chnlLink.setLinkUrl(link.getLinkUrl());
                chnlLink.setOrder(-1);
                chnlLink.setSysContentLinkId(link.getId());
                chnlLink.save(loginUser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int existsLink(ContentLink link, int nObjectId, boolean flag) {
        String sWhere = flag ? "ChannelId=?" : "SiteId=?";
        String sql = "SELECT LinkId FROM WcmChannelContentLink WHERE LinkName=? AND " + sWhere;
        if (m_oDbManager == null) {
            m_oDbManager = DBManager.getDBManager();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = m_oDbManager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, link.getName());
            pstmt.setInt(2, nObjectId);
            ResultSet rs = pstmt.executeQuery();
            int id = 0;
            if (rs.next()) {
                id = rs.getInt(1);
            }
            int n = id;
            return n;
        }
        catch (Exception exception) {
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            m_oDbManager.freeConnection(conn);
        }
        return 0;
    }

    public Object changeOrder(MethodContext _context) throws WCMException {
        int nLinkId = _context.getValue("LinkId", 0);
        int nChnlId = _context.getValue("ChannelId", 0);
        int nSiteId = _context.getValue("SiteId", 0);
        User loginUser = ContextHelper.getLoginUser();
        ChannelContentLink link = ChannelContentLink.findById(nLinkId);
        if (link == null) {
            throw new WCMException(200006, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u70ed\u8bcd[Id=") + nLinkId + "]!");
        }
        if (nChnlId > 0) {
            Channel channel = this.findChannelById(nChnlId);
            this.validateRight(loginUser, channel, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label12", "\u7f16\u8f91\u680f\u76ee\u70ed\u8bcd"));
        } else {
            WebSite website = WebSite.findById(nSiteId);
            this.validateRight(loginUser, website, WCMRightTypes.CONTENT_LINK_EDIT, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label18", "\u7f16\u8f91\u7ad9\u70b9\u70ed\u8bcd"));
        }
        if (!link.canEdit(loginUser)) {
            throw new WCMException(1012, I18NMessage.get(ContentLinkServiceProvider.class, "ContentLinkServiceProvider.label16", "\u4e0d\u80fd\u9501\u5b9a\u5bf9\u8c61\u5b8c\u6210\u8fdb\u884c\u4fee\u6539\uff01"));
        }
        int nOldOrder = link.getOrder();
        int nNewOrder = _context.getValue("NewOrder", nOldOrder);
        if (nNewOrder != nOldOrder) {
            link.setOrder(nNewOrder);
            link.save(loginUser);
        }
        return String.valueOf(nNewOrder);
    }
}

