/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import com.ibm.network.mail.base.InternetAddress;
import com.ibm.network.mail.base.MimeBodyPart;
import com.ibm.network.mail.base.MimeMessage;
import com.ibm.network.mail.pop3.event.MessageEvent;
import com.ibm.network.mail.pop3.event.MessageListener;
import com.ibm.network.mail.pop3.event.StatusListener;
import com.ibm.network.mail.smtp.event.StatusEvent;
import com.ibm.network.mail.smtp.protocol.CoreProtocolBean;
import java.net.URL;
import java.util.Hashtable;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.transport.smtp.POP3StatusListener;
import org.apache.soap.transport.smtp.SMTPConstants;
import org.apache.soap.transport.smtp.SMTPUtils;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.net.HTTPUtils;

public class SMTP2HTTPBridge
implements Runnable {
    Object waitObject = new Object();
    long pollDelayMillis;
    com.ibm.network.mail.pop3.protocol.CoreProtocolBean pop3 = new com.ibm.network.mail.pop3.protocol.CoreProtocolBean();
    CoreProtocolBean smtp = new CoreProtocolBean();
    URL httpURL;
    static /* synthetic */ Class class$org$apache$soap$server$SMTP2HTTPBridge;

    public SMTP2HTTPBridge(long pollDelayMillis, String popServer, String popLoginName, String password, URL httpURL, String smtpServer) {
        this.pollDelayMillis = pollDelayMillis;
        this.pop3.setPOP3ServerHost(popServer);
        this.pop3.setUserOptions(popLoginName, password, false, false);
        this.pop3.addMessageListener(new MessageListener(){

            public void messageReceived(MessageEvent me) {
                SMTP2HTTPBridge.this.receiveMessage(me.getMessage());
            }
        });
        this.pop3.addStatusListener((StatusListener)new POP3StatusListener());
        this.httpURL = httpURL;
        this.smtp.setSmtpServerHost(smtpServer);
        this.smtp.addStatusListener(new com.ibm.network.mail.smtp.event.StatusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(StatusEvent e) {
                System.err.println("DONE: " + e.getStatusString());
                Object object = SMTP2HTTPBridge.this.waitObject;
                synchronized (object) {
                    SMTP2HTTPBridge.this.waitObject.notify();
                }
            }

            public void processStatus(StatusEvent e) {
                System.err.println("Status update: " + e.getStatusString());
            }
        });
    }

    public void run() {
        while (true) {
            if (this.pop3.isReady()) {
                System.err.println("SMTP2HTTPBridge: Polling for messages ..");
                this.pop3.receiveMessage();
            }
            try {
                Thread.sleep(this.pollDelayMillis);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    void receiveMessage(MimeMessage msg) {
        TransportMessage response;
        String subject = msg.getHeader(SMTPConstants.SMTP_HEADER_SUBJECT);
        String actionURI = msg.getHeader("SOAPAction");
        String toAddr = msg.getHeader(SMTPConstants.SMTP_HEADER_TO);
        String fromAddr = msg.getHeader(SMTPConstants.SMTP_HEADER_FROM);
        MimeBodyPart mbp = (MimeBodyPart)msg.getContent();
        byte[] ba = (byte[])mbp.getContent();
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("SOAPAction", actionURI);
        try {
            TransportMessage tmsg = new TransportMessage(new String(ba), new SOAPContext(), headers);
            tmsg.save();
            response = HTTPUtils.post(this.httpURL, tmsg, 30000, null, 0);
            SOAPContext ctx = response.getSOAPContext();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        System.err.println("HTTP RESPONSE IS: ");
        String payload = null;
        try {
            payload = IOUtils.getStringFromReader(response.getEnvelopeReader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("'" + payload + "'");
        MimeBodyPart mbpResponse = new MimeBodyPart();
        mbpResponse.setContent((Object)new String(payload), response.getContentType());
        mbpResponse.setEncoding(4);
        mbpResponse.setDisposition(2);
        MimeMessage msgResponse = new MimeMessage();
        msgResponse.setContent((Object)mbpResponse, "");
        msgResponse.addHeader(SMTPConstants.SMTP_HEADER_SUBJECT, "Re: " + subject);
        msgResponse.addHeader("SOAPAction", actionURI);
        msgResponse.addHeader(SMTPConstants.SMTP_HEADER_FROM, SMTPUtils.getAddressFromAddressHeader(toAddr));
        String sendTo = SMTPUtils.getAddressFromAddressHeader(fromAddr);
        msgResponse.addRecipients(0, new InternetAddress[]{new InternetAddress(sendTo)});
        this.smtp.sendMessage(msgResponse);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 6) {
            System.err.println("Usage: java " + (class$org$apache$soap$server$SMTP2HTTPBridge == null ? (class$org$apache$soap$server$SMTP2HTTPBridge = SMTP2HTTPBridge.class$("org.apache.soap.server.SMTP2HTTPBridge")) : class$org$apache$soap$server$SMTP2HTTPBridge).getName() + " polldelay \\");
            System.err.println("\t\t pop3host pop3login pop3passwd httpurl smtphostname");
            System.err.println("  where:");
            System.err.println("    polldelay    number of millisec to sleep between polls");
            System.err.println("    pop3host     hostname of the POP3 server");
            System.err.println("    pop3login    login ID of POP3 account");
            System.err.println("    pop3passwd   POP3 account password");
            System.err.println("    routerURL    http URL of SOAP router to bridge to");
            System.err.println("    smtphostname SMTP server host name");
            System.exit(1);
        }
        SMTP2HTTPBridge sb = new SMTP2HTTPBridge(Integer.parseInt(args[0]), args[1], args[2], args[3], new URL(args[4]), args[5]);
        new Thread(sb).start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

