/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.soap.Constants;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.apache.soap.util.mime.MimeUtils;
import org.apache.soap.util.xml.Serializer;

public class SOAPContext {
    protected MimeMultipart parts = null;
    protected Hashtable bag = new Hashtable();
    protected ClassLoader loader = null;
    protected List multiRef = null;
    protected Map deserializedMultiRef = null;
    protected String currentId = null;
    protected boolean docLitSerialization = false;
    protected Boolean gzip = null;
    protected Boolean acceptGzip = null;
    protected boolean qualifyElements = false;
    protected boolean isRootPartEnvelope = false;
    protected String rootPartString = null;
    protected String rootPartContentType = "";
    protected boolean oneWay = false;
    private static MimeType MIME_STREAM;
    private static MimeType MIME_IMAGE;
    private static MimeType MIME_AUDIO;
    private static MimeType MIME_VIDEO;
    protected boolean rootPartSet = false;
    private static final String[] ignoreHeaders;
    private static final String DEFAULT_BASEURI = "thismessage:/";
    static /* synthetic */ Class class$org$apache$soap$rpc$SOAPContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPContext() {
        if (MIME_STREAM == null) {
            Class clazz = class$org$apache$soap$rpc$SOAPContext == null ? (class$org$apache$soap$rpc$SOAPContext = SOAPContext.class$("org.apache.soap.rpc.SOAPContext")) : class$org$apache$soap$rpc$SOAPContext;
            synchronized (clazz) {
                if (MIME_STREAM == null) {
                    try {
                        MIME_STREAM = new MimeType("application", "octet-stream");
                        MIME_IMAGE = new MimeType("image", "*");
                        MIME_AUDIO = new MimeType("audio", "*");
                        MIME_VIDEO = new MimeType("video", "*");
                    }
                    catch (MimeTypeParseException mimeTypeParseException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void readMultipart(DataSource ds) throws MessagingException {
        this.parts = new MimeMultipart(ds);
    }

    public MimeBodyPart getBodyPart(int index) {
        this.fillRootPart();
        if (this.parts == null) {
            return null;
        }
        try {
            return (MimeBodyPart)this.parts.getBodyPart(index);
        }
        catch (MessagingException me) {
            throw new IndexOutOfBoundsException(me.getMessage());
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public MimeBodyPart getBodyPart(String CID) {
        this.fillRootPart();
        if (this.parts == null) {
            return null;
        }
        try {
            return (MimeBodyPart)this.parts.getBodyPart(CID);
        }
        catch (MessagingException me) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    public MimeBodyPart findBodyPart(String uri) {
        block8: {
            this.fillRootPart();
            if (this.parts == null || uri == null) {
                return null;
            }
            try {
                if (uri.length() > 4 && uri.substring(0, 4).equalsIgnoreCase("cid:")) {
                    String cid = MimeUtils.decode(uri.substring(4));
                    if (cid.charAt(0) != '<' || cid.charAt(cid.length() - 1) != '>') {
                        cid = '<' + cid + '>';
                    }
                    try {
                        return (MimeBodyPart)this.parts.getBodyPart(cid);
                    }
                    catch (NullPointerException nullPointerException) {
                        break block8;
                    }
                }
                return this.findPartByLocation(uri);
            }
            catch (MessagingException me) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getBaseURI() {
        String baseUri = null;
        try {
            baseUri = this.getRootPart().getHeader("Content-Location", null);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        if (baseUri == null) {
            baseUri = DEFAULT_BASEURI;
        }
        return baseUri;
    }

    public MimeBodyPart findPartByLocation(String uri) {
        try {
            String baseUri = this.getBaseURI();
            uri = this.normalizeURI(uri, baseUri);
            if (uri == null) {
                return null;
            }
            for (int i = 0; i < this.parts.getCount(); ++i) {
                String partUri;
                MimeBodyPart part = this.getBodyPart(i);
                if (part == null || !uri.equals(this.normalizeURI(partUri = part.getHeader("Content-Location", null), baseUri))) continue;
                return part;
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null;
    }

    private String normalizeURI(String uri, String baseUri) {
        String scheme;
        int p1 = uri.indexOf(58);
        if (p1 >= 0 && (scheme = uri.substring(0, p1)).indexOf(47) == -1 && scheme.indexOf(63) == -1 && scheme.indexOf(35) == -1) {
            return uri;
        }
        return baseUri + uri;
    }

    public void addBodyPart(MimeBodyPart part) throws MessagingException {
        this.addBodyPart(part, -1);
    }

    public void addBodyPart(MimeBodyPart part, int index) throws MessagingException, IllegalArgumentException {
        if (this.parts == null) {
            this.parts = new MimeMultipart("related");
        }
        DataHandler dh = part.getDataHandler();
        try {
            MimeType ctype = new MimeType(dh.getContentType());
            part.setHeader("Content-Type", ctype.toString());
            if (dh.getDataSource() instanceof ByteArrayDataSource) {
                part.setHeader("Content-Length", String.valueOf(((ByteArrayDataSource)dh.getDataSource()).getSize()));
            }
            if (ctype.match(MIME_STREAM) || ctype.match(MIME_IMAGE) || ctype.match(MIME_AUDIO) || ctype.match(MIME_VIDEO)) {
                part.setHeader("Content-Transfer-Encoding", "8bit");
            }
        }
        catch (MessagingException me) {
            throw new IllegalArgumentException("Invalid InputStream/DataSource/DataHandler metadata: " + (Object)((Object)me));
        }
        catch (MimeTypeParseException mtpe) {
            throw new IllegalArgumentException("Invalid Mime type \"" + dh.getContentType() + "\": " + (Object)((Object)mtpe));
        }
        if (index == -1) {
            this.parts.addBodyPart((BodyPart)part);
        } else {
            this.parts.addBodyPart((BodyPart)part, index);
        }
    }

    public void removeBodyPart(MimeBodyPart part) throws MessagingException {
        this.parts.removeBodyPart((BodyPart)part);
    }

    public void setRootPart(MimeBodyPart part) throws MessagingException {
        if (this.rootPartSet && !this.isRootPartEnvelope) {
            this.parts.removeBodyPart((BodyPart)this.getRootPart());
        }
        this.isRootPartEnvelope = false;
        String rootCid = '<' + MimeUtils.getUniqueValue() + '>';
        part.setHeader("Content-ID", rootCid);
        this.addBodyPart(part, 0);
        this.rootPartSet = true;
    }

    public void setRootPart(String s, String contentType) throws MessagingException, IOException {
        this.isRootPartEnvelope = true;
        this.rootPartContentType = contentType;
        this.rootPartString = s;
        this.rootPartSet = true;
    }

    public void setRootPart(byte[] b, String contentType) throws MessagingException {
        ByteArrayDataSource ds = new ByteArrayDataSource(b, contentType);
        DataHandler dh = new DataHandler((DataSource)ds);
        MimeBodyPart bp = new MimeBodyPart();
        bp.setDataHandler(dh);
        bp.setHeader("Content-Length", String.valueOf(ds.getSize()));
        bp.setHeader("Content-Transfer-Encoding", "8bit");
        this.setRootPart(bp);
    }

    private void fillRootPart() {
        if (this.isRootPartEnvelope) {
            try {
                byte[] rootPartBytes = this.rootPartString.getBytes(MimeUtils.getEncoding(this.rootPartContentType, "UTF8"));
                ByteArrayDataSource ds = new ByteArrayDataSource(rootPartBytes, this.rootPartContentType);
                DataHandler dh = new DataHandler((DataSource)ds);
                MimeBodyPart bp = new MimeBodyPart();
                bp.setDataHandler(dh);
                bp.setHeader("Content-Length", String.valueOf(ds.getSize()));
                bp.setHeader("Content-Transfer-Encoding", "8bit");
                bp.setHeader("text/xml", this.rootPartContentType);
                this.setRootPart(bp);
            }
            catch (MessagingException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public String getEnvelope() {
        if (this.isRootPartEnvelope) {
            return this.rootPartString;
        }
        try {
            String ctype;
            ContentType type;
            MimeBodyPart rootPart = this.getRootPart();
            if (rootPart != null && (type = MimeUtils.getContentType(ctype = rootPart.getContentType())) != null && Constants.CTYPE_TEXT_ALL.match(type)) {
                ByteArrayDataSource ds = new ByteArrayDataSource(rootPart.getInputStream(), ctype);
                return ds.getText();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public MimeBodyPart getRootPart() throws MessagingException {
        String startCid;
        this.fillRootPart();
        MimeBodyPart rootPart = null;
        if (this.getCount() > 1 && (startCid = new ContentType(this.parts.getContentType()).getParameter("start")) != null) {
            rootPart = this.getBodyPart(MimeUtils.decode(startCid));
        }
        if (rootPart == null) {
            rootPart = this.getBodyPart(0);
        }
        return rootPart;
    }

    public String getRootPartContentType() throws MessagingException {
        if (this.isRootPartEnvelope) {
            return this.rootPartContentType;
        }
        MimeBodyPart rootPart = this.getRootPart();
        return rootPart == null ? null : rootPart.getContentType();
    }

    public void setSubType(String subtype) throws MessagingException {
        if (this.parts == null) {
            this.parts = new MimeMultipart(subtype);
        } else {
            this.parts.setSubType(subtype);
        }
    }

    public boolean isRootPartSet() {
        return this.rootPartSet;
    }

    public int getCount() throws MessagingException {
        int countRoot;
        int n = countRoot = this.isRootPartEnvelope ? 1 : 0;
        if (this.parts == null) {
            return countRoot;
        }
        return this.parts.getCount() + countRoot;
    }

    public String getContentType() throws MessagingException {
        if (this.parts == null) {
            return this.isRootPartEnvelope ? this.rootPartContentType : null;
        }
        if (this.parts.getCount() == 1) {
            return this.getRootPart().getContentType();
        }
        return this.parts.getContentType();
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        int count = this.getCount();
        if (count == 0) {
            throw new IOException("Message is empty!");
        }
        if (count == 1) {
            this.getRootPart().writeTo(os);
        } else {
            this.fillRootPart();
            Session session = Session.getDefaultInstance((Properties)new Properties(), null);
            MimeMessage msg = new MimeMessage(session);
            msg.setContent((Multipart)this.parts);
            msg.saveChanges();
            msg.writeTo(os, ignoreHeaders);
        }
    }

    public void setProperty(String name, Object value) {
        this.bag.put(name, value);
    }

    public Object getProperty(String name) {
        return this.bag.get(name);
    }

    public Object removeProperty(String name) {
        return this.bag.remove(name);
    }

    public Enumeration getPropertyNames() {
        return this.bag.keys();
    }

    public void setClassLoader(ClassLoader cl) {
        this.loader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this.loader == null) {
            return Class.forName(className);
        }
        return Class.forName(className, true, this.loader);
    }

    public boolean getDocLitSerialization() {
        return this.docLitSerialization;
    }

    public void setDocLitSerialization(boolean docLitSerialization) {
        this.docLitSerialization = docLitSerialization;
    }

    public Boolean getAcceptGzip() {
        return this.acceptGzip;
    }

    public void setAcceptGzip(boolean acceptGzip) {
        this.acceptGzip = acceptGzip ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getGzip() {
        return this.gzip;
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getCurrentId() {
        return this.currentId;
    }

    public void setCurrentId(String id) {
        this.currentId = id;
    }

    public int addMultiRef(Object obj, Serializer ser) {
        if (this.multiRef == null) {
            this.multiRef = new ArrayList();
        }
        for (int i = 0; i < this.multiRef.size(); ++i) {
            if (((MultiRefInfo)this.multiRef.get((int)i)).obj != obj) continue;
            return i;
        }
        this.multiRef.add(new MultiRefInfo(obj, ser));
        return this.multiRef.size() - 1;
    }

    public Object getMultiRefObject(int id) {
        return this.multiRef != null ? ((MultiRefInfo)this.multiRef.get((int)id)).obj : null;
    }

    public Serializer getMultiRefSerializer(int id) {
        return this.multiRef != null ? ((MultiRefInfo)this.multiRef.get((int)id)).ser : null;
    }

    public int getMultiRefCount() {
        return this.multiRef != null ? this.multiRef.size() : 0;
    }

    public void addDeserializedMultiRef(String id, Object o) {
        if (this.deserializedMultiRef == null) {
            this.deserializedMultiRef = new HashMap();
        }
        this.deserializedMultiRef.put(id, o);
    }

    public Object getDeserializedMultiRef(String id) {
        return this.deserializedMultiRef == null ? null : this.deserializedMultiRef.get(id);
    }

    public boolean getOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }

    public boolean getQualifyElements() {
        return this.qualifyElements;
    }

    public void setQualifyElements(boolean qualifyElements) {
        this.qualifyElements = qualifyElements;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("[Parts={");
        if (this.parts != null) {
            try {
                for (int i = 0; i < this.getCount(); ++i) {
                    if (i > 0) {
                        pw.print(", ");
                    }
                    MimeBodyPart mbp = this.getBodyPart(i);
                    pw.print("[cid:" + mbp.getContentID() + " type: " + mbp.getContentType() + " enc: " + mbp.getEncoding() + "]");
                }
            }
            catch (MessagingException me) {
                me.printStackTrace();
            }
        }
        pw.print("}]");
        pw.print(" multiRefs: " + (this.multiRef != null ? this.multiRef.size() : 48) + " deserializedMultiRefs: " + (this.deserializedMultiRef != null ? this.deserializedMultiRef.size() : 48));
        return sw.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ignoreHeaders = new String[]{"Message-ID", "Mime-Version"};
    }

    private class MultiRefInfo {
        public Object obj;
        public Serializer ser;

        public MultiRefInfo(Object obj, Serializer ser) {
            this.obj = obj;
            this.ser = ser;
        }
    }
}

