/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HashtableSerializer
implements Serializer,
Deserializer {
    private static final String STR_KEY = "key";
    private static final String STR_ITEM = "item";
    private static final String STR_VALUE = "value";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Hashtable;

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException, IOException {
        if (src == null) {
            SoapEncUtils.generateNullStructure(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx);
        } else if (src instanceof Hashtable) {
            SoapEncUtils.generateStructureHeader(inScopeEncStyle, javaType, context, sink, nsStack, xjmr, ctx);
            sink.write("\n");
            Hashtable hash = (Hashtable)src;
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = hash.get(key);
                sink.write("<item>");
                sink.write("\n");
                xjmr.marshall("http://schemas.xmlsoap.org/soap/encoding/", key.getClass(), key, STR_KEY, sink, nsStack, ctx);
                sink.write("\n");
                if (value == null) {
                    SoapEncUtils.generateNullStructure("http://schemas.xmlsoap.org/soap/encoding/", class$java$lang$Object == null ? HashtableSerializer.class$("java.lang.Object") : class$java$lang$Object, STR_VALUE, sink, nsStack, xjmr, ctx);
                } else {
                    Class<?> actualComponentType = value.getClass();
                    xjmr.marshall("http://schemas.xmlsoap.org/soap/encoding/", actualComponentType, value, STR_VALUE, sink, nsStack, ctx);
                }
                sink.write("\n");
                sink.write("</item>");
                sink.write("\n");
            }
            sink.write("</" + context + '>');
        } else {
            throw new IllegalArgumentException("Tried to pass a '" + src.getClass().toString() + "' to HashtableSerializer");
        }
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        Element root = (Element)src;
        String name = root.getTagName();
        if (SoapEncUtils.isNull(root)) {
            return new Bean(class$java$util$Hashtable == null ? (class$java$util$Hashtable = HashtableSerializer.class$("java.util.Hashtable")) : class$java$util$Hashtable, null);
        }
        Hashtable<Object, Object> hash = new Hashtable<Object, Object>();
        Element tempEl = DOMUtils.getFirstChildElement(root);
        while (tempEl != null) {
            Element keyEl = DOMUtils.getFirstChildElement(tempEl);
            String tagName = keyEl.getTagName();
            if (!tagName.equalsIgnoreCase(STR_KEY)) {
                throw new IllegalArgumentException("Got <" + tagName + "> tag when expecting <" + STR_KEY + ">");
            }
            Element valEl = DOMUtils.getNextSiblingElement(keyEl);
            tagName = valEl.getTagName();
            if (!tagName.equalsIgnoreCase(STR_VALUE)) {
                throw new IllegalArgumentException("Got <" + tagName + "> tag when expecting <" + STR_VALUE + ">");
            }
            Bean keyBean = this.unmarshallEl(inScopeEncStyle, xjmr, keyEl, ctx);
            Bean valBean = this.unmarshallEl(inScopeEncStyle, xjmr, valEl, ctx);
            hash.put(keyBean.value, valBean.value);
            tempEl = DOMUtils.getNextSiblingElement(tempEl);
        }
        return new Bean(class$java$util$Hashtable == null ? (class$java$util$Hashtable = HashtableSerializer.class$("java.util.Hashtable")) : class$java$util$Hashtable, hash);
    }

    private Bean unmarshallEl(String inScopeEncStyle, XMLJavaMappingRegistry xjmr, Element targetEl, SOAPContext ctx) {
        String declEncStyle = DOMUtils.getAttributeNS(targetEl, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        String actualEncStyle = declEncStyle != null ? declEncStyle : inScopeEncStyle;
        QName declItemType = SoapEncUtils.getTypeQName(targetEl);
        return xjmr.unmarshall(actualEncStyle, declItemType, targetEl, ctx);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

