/*
 * Decompiled with CFR 0.152.
 */
package org.aton.cache;

import java.io.PrintStream;
import java.util.HashMap;
import org.aton.container.DblLinkItem;

public class LRUCacheContainer {
    private int m_nMaxSize = 100;
    private HashMap m_hBuffer = new HashMap();
    private DblLinkItem m_pole = new DblLinkItem();

    public LRUCacheContainer() {
        this.m_pole.setNext(this.m_pole);
        this.m_pole.setPrevious(this.m_pole);
    }

    public synchronized void clear() {
        this.m_hBuffer.clear();
        DblLinkItem dblLinkItem = this.m_pole;
        DblLinkItem dblLinkItem2 = null;
        while (dblLinkItem instanceof CacheItem) {
            dblLinkItem2 = dblLinkItem.getNext();
            dblLinkItem.setPrevious(null);
            dblLinkItem.setNext(null);
            dblLinkItem = dblLinkItem2;
        }
    }

    public int getMaxSize() {
        return this.m_nMaxSize;
    }

    public synchronized void setMaxSize(int n) {
        int n2 = this.m_nMaxSize = n > 1 ? n : 1;
        if (this.size() > this.m_nMaxSize) {
            DblLinkItem dblLinkItem = this.m_pole.getPrevious();
            DblLinkItem dblLinkItem2 = null;
            for (int i = this.size(); i > this.m_nMaxSize; --i) {
                dblLinkItem2 = dblLinkItem.getPrevious();
                if (dblLinkItem instanceof CacheItem) {
                    this.m_hBuffer.remove(((CacheItem)dblLinkItem).getKey());
                    dblLinkItem.detach(true);
                }
                dblLinkItem = dblLinkItem2;
            }
        }
    }

    public int size() {
        return this.m_hBuffer.size();
    }

    public Object get(Object object) {
        CacheItem cacheItem = (CacheItem)this.m_hBuffer.get(object);
        if (cacheItem == null) {
            return null;
        }
        this.resort(cacheItem);
        return cacheItem.getValue();
    }

    public void put(Object object, Object object2) {
        CacheItem cacheItem = (CacheItem)this.m_hBuffer.get(object);
        if (cacheItem == null) {
            cacheItem = new CacheItem(object, object2);
            this.insert(object, cacheItem);
        } else {
            cacheItem.setValue(object2);
            this.resort(cacheItem);
        }
    }

    private synchronized void insert(Object object, CacheItem cacheItem) {
        if (this.m_hBuffer.size() >= this.m_nMaxSize) {
            CacheItem cacheItem2 = (CacheItem)this.m_pole.getPrevious();
            this.m_hBuffer.remove(cacheItem2.getKey());
            cacheItem2.detach(true);
        }
        this.m_hBuffer.put(object, cacheItem);
        cacheItem.insertAfter(this.m_pole);
    }

    private synchronized void resort(CacheItem cacheItem) {
        CacheItem cacheItem2 = (CacheItem)this.m_pole.getNext();
        if (!cacheItem.equals(cacheItem2)) {
            cacheItem.detach();
            cacheItem.insertAfter(this.m_pole);
        }
    }

    public synchronized Object remove(Object object) {
        CacheItem cacheItem = (CacheItem)this.m_hBuffer.remove(object);
        if (cacheItem == null) {
            return null;
        }
        cacheItem.detach(true);
        return cacheItem.getValue();
    }

    public void printLRUList(PrintStream printStream, String string, String string2) throws Exception {
        DblLinkItem dblLinkItem = this.m_pole.getNext();
        Object object = null;
        printStream.print("[" + this.size() + "] ");
        while (dblLinkItem instanceof CacheItem) {
            object = dblLinkItem.getValue();
            if (string != null) {
                printStream.print(string);
            }
            printStream.print(object != null ? object.toString() : "null");
            if (string2 != null) {
                printStream.print(string2);
            }
            dblLinkItem = dblLinkItem.getNext();
        }
    }

    public static void main(String[] stringArray) {
        LRUCacheContainer lRUCacheContainer = new LRUCacheContainer();
        Object object = null;
        try {
            lRUCacheContainer.setMaxSize(3);
            object = lRUCacheContainer.get("2");
            System.out.println("\n find(2)=" + object);
            lRUCacheContainer.printLRUList(System.out, null, ",");
            lRUCacheContainer.put("1", "1");
            lRUCacheContainer.put("2", "2");
            lRUCacheContainer.put("3", "3");
            lRUCacheContainer.printLRUList(System.out, null, ",");
            lRUCacheContainer.setMaxSize(2);
            lRUCacheContainer.printLRUList(System.out, null, ",");
            object = lRUCacheContainer.get("2");
            System.out.println("\n find(2)=" + object);
            lRUCacheContainer.printLRUList(System.out, null, ",");
            object = lRUCacheContainer.get("1");
            System.out.println("\n find(1)=" + object);
            lRUCacheContainer.printLRUList(System.out, null, ",");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private class CacheItem
    extends DblLinkItem {
        protected Object m_key;

        public CacheItem(Object object, Object object2) {
            this.m_key = object;
            this.setValue(object2);
        }

        public Object getKey() {
            return this.m_key;
        }

        public void setKey(Object object) {
            this.m_key = object;
        }

        public boolean equals(CacheItem cacheItem) {
            return cacheItem != null && this.m_key != null && this.m_key.equals(cacheItem.m_key);
        }
    }
}

