/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLJavaMappingRegistry {
    Map encToMaps = new HashMap();
    private String defaultEncodingStyle = "";

    public void setDefaultEncodingStyle(String defEncStyle) {
        if (defEncStyle != null) {
            this.defaultEncodingStyle = defEncStyle;
        }
    }

    private Maps getMapsForEncoding(String encodingStyleURI) {
        Maps maps;
        if (encodingStyleURI == null) {
            encodingStyleURI = this.defaultEncodingStyle;
        }
        if ((maps = (Maps)this.encToMaps.get(encodingStyleURI)) == null) {
            maps = new Maps();
            this.encToMaps.put(encodingStyleURI, maps);
        }
        return maps;
    }

    public void mapTypes(String encodingStyleURI, QName elementType, Class javaType, Serializer s, Deserializer ds) {
        Maps maps = this.getMapsForEncoding(encodingStyleURI);
        Object java2XMLKey = "";
        Object xml2JavaKey = "";
        if (s != null) {
            if (javaType != null) {
                java2XMLKey = javaType;
            }
            maps.sReg.put(java2XMLKey, s);
        }
        if (ds != null) {
            if (elementType != null) {
                xml2JavaKey = elementType;
            }
            maps.dsReg.put(xml2JavaKey, ds);
        }
        if (elementType != null && javaType != null) {
            if (s != null) {
                maps.java2XMLReg.put(java2XMLKey, elementType);
            }
            if (ds != null) {
                maps.xml2JavaReg.put(xml2JavaKey, javaType);
            }
        }
    }

    public void addJavaToXMLMap(String encodingStyleURI, QName elementType, Class javaType) {
        Maps maps = this.getMapsForEncoding(encodingStyleURI);
        Object java2XMLKey = "";
        if (javaType != null) {
            java2XMLKey = javaType;
        }
        maps.java2XMLReg.put(java2XMLKey, elementType);
    }

    public void addXMLToJavaMap(String encodingStyleURI, QName elementType, Class javaType) {
        Maps maps = this.getMapsForEncoding(encodingStyleURI);
        Object xml2JavaKey = "";
        if (elementType != null) {
            xml2JavaKey = elementType;
        }
        maps.xml2JavaReg.put(xml2JavaKey, javaType);
    }

    protected Serializer querySerializer_(Class javaType, String encodingStyleURI) {
        Serializer s;
        Maps maps = this.getMapsForEncoding(encodingStyleURI);
        Object java2XMLKey = "";
        if (javaType != null) {
            java2XMLKey = javaType;
        }
        return (s = (Serializer)maps.sReg.get(java2XMLKey)) != null ? s : (Serializer)maps.sReg.get("");
    }

    protected Serializer querySerializerNoDefault_(Class javaType, String encodingStyleURI) {
        Maps maps = this.getMapsForEncoding(encodingStyleURI);
        Object java2XMLKey = "";
        if (javaType != null) {
            java2XMLKey = javaType;
        }
        return (Serializer)maps.sReg.get(java2XMLKey);
    }

    public Serializer querySerializer(Class javaType, String encodingStyleURI) throws IllegalArgumentException {
        Serializer s = this.querySerializer_(javaType, encodingStyleURI);
        if (s != null) {
            return s;
        }
        throw new IllegalArgumentException("No Serializer found to serialize a '" + XMLJavaMappingRegistry.getClassName(javaType) + "' using encoding style '" + encodingStyleURI + "'.");
    }

    protected Deserializer queryDeserializer_(QName elementType, String encodingStyleURI) {
        Deserializer ds;
        Maps maps = this.getMapsForEncoding(encodingStyleURI);
        Object xml2JavaKey = "";
        if (elementType != null) {
            xml2JavaKey = elementType;
        }
        return (ds = (Deserializer)maps.dsReg.get(xml2JavaKey)) != null ? ds : (Deserializer)maps.dsReg.get("");
    }

    protected Deserializer queryDeserializerNoDefault_(QName elementType, String encodingStyleURI) {
        Maps maps = this.getMapsForEncoding(encodingStyleURI);
        Object xml2JavaKey = "";
        if (elementType != null) {
            xml2JavaKey = elementType;
        }
        return (Deserializer)maps.dsReg.get(xml2JavaKey);
    }

    public Deserializer queryDeserializer(QName elementType, String encodingStyleURI) throws IllegalArgumentException {
        Deserializer ds = this.queryDeserializer_(elementType, encodingStyleURI);
        if (ds != null) {
            return ds;
        }
        throw new IllegalArgumentException("No Deserializer found to deserialize a '" + elementType + "' using encoding style '" + encodingStyleURI + "'.");
    }

    protected QName queryElementType_(Class javaType, String encodingStyleURI) {
        Maps maps = this.getMapsForEncoding(encodingStyleURI);
        Object java2XMLKey = "";
        if (javaType != null) {
            java2XMLKey = javaType;
        }
        return (QName)maps.java2XMLReg.get(java2XMLKey);
    }

    public QName queryElementType(Class javaType, String encodingStyleURI) throws IllegalArgumentException {
        QName elementType = this.queryElementType_(javaType, encodingStyleURI);
        if (elementType != null) {
            return elementType;
        }
        throw new IllegalArgumentException("No mapping found for '" + XMLJavaMappingRegistry.getClassName(javaType) + "' using encoding style '" + encodingStyleURI + "'.");
    }

    protected Class queryJavaType_(QName elementType, String encodingStyleURI) {
        Maps maps = this.getMapsForEncoding(encodingStyleURI);
        Object xml2JavaKey = "";
        if (elementType != null) {
            xml2JavaKey = elementType;
        }
        return (Class)maps.xml2JavaReg.get(xml2JavaKey);
    }

    public Class queryJavaType(QName elementType, String encodingStyleURI) throws IllegalArgumentException {
        Class javaType = this.queryJavaType_(elementType, encodingStyleURI);
        if (javaType != null) {
            return javaType;
        }
        throw new IllegalArgumentException("No mapping found for '" + elementType + "' using encoding style '" + encodingStyleURI + "'.");
    }

    public Class getClassWithSerializer(Class type, String encodingStyle) {
        boolean isArray = type.isArray();
        if (isArray) {
            type = type.getComponentType();
        }
        while (type != null) {
            if (this.querySerializer_(type, encodingStyle) != null) {
                if (isArray) {
                    type = Array.newInstance(type, 0).getClass();
                }
                return type;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public Class getClassWithSerializer(Class[] classes, String encodingStyle) {
        boolean done = false;
        while (!done) {
            done = true;
            for (int i = 0; i < classes.length; ++i) {
                Class type = classes[i];
                if (type == null) continue;
                if (type.isArray()) {
                    throw new IllegalArgumentException("Array classes are not allowed");
                }
                done = false;
                if (this.querySerializer_(type, encodingStyle) != null) {
                    return type;
                }
                classes[i] = type.getSuperclass();
            }
        }
        return null;
    }

    public Class getCompatibleClassWithSerializer(Class type, String encodingStyle) {
        Class<?> serClass;
        boolean isArray = type.isArray();
        if (isArray) {
            type = type.getComponentType();
        }
        if ((serClass = this.getClassWithSerializer(type, encodingStyle)) == null) {
            serClass = this.getClassWithSerializer(type.getInterfaces(), encodingStyle);
        }
        if (serClass != null) {
            if (isArray) {
                serClass = Array.newInstance(serClass, 0).getClass();
            }
            return serClass;
        }
        return null;
    }

    public void marshall(String inScopeEncStyle, Class javaType, Object src, Object context, Writer sink, NSStack nsStack, SOAPContext ctx) throws IllegalArgumentException, IOException {
        Serializer s = this.querySerializer(javaType, inScopeEncStyle);
        s.marshall(inScopeEncStyle, javaType, src, context, sink, nsStack, this, ctx);
    }

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, SOAPContext ctx) throws IllegalArgumentException {
        Deserializer ds = null;
        try {
            ds = this.queryDeserializer(elementType, inScopeEncStyle);
        }
        catch (IllegalArgumentException iae) {
            String href = ((Element)src).getAttribute("href");
            if (href != null && !href.equals("")) {
                ds = SOAPMappingRegistry.partSer;
            }
            throw iae;
        }
        return ds.unmarshall(inScopeEncStyle, elementType, src, this, ctx);
    }

    protected static String getClassName(Class javaType) {
        return javaType != null ? StringUtils.getClassName(javaType) : "null";
    }

    private static final class Maps {
        Map sReg = new HashMap();
        Map dsReg = new HashMap();
        Map xml2JavaReg = new HashMap();
        Map java2XMLReg = new HashMap();

        private Maps() {
        }
    }
}

