/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.MessageRouter;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.Provider;

public class MsgJavaProvider
implements Provider {
    private DeploymentDescriptor dd;
    private Envelope envelope;
    private Call call;
    private String methodName;
    private String targetObjectURI;
    private HttpServlet servlet;
    private HttpSession session;
    private Object targetObject;

    public void locate(DeploymentDescriptor dd, Envelope env, Call call, String methodName, String targetObjectURI, SOAPContext reqContext) throws SOAPException {
        HttpServlet servlet = (HttpServlet)reqContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession session = (HttpSession)reqContext.getProperty(Constants.BAG_HTTPSESSION);
        this.dd = dd;
        this.envelope = env;
        this.call = call;
        this.methodName = methodName;
        this.targetObjectURI = targetObjectURI;
        this.servlet = servlet;
        this.session = session;
        ServletConfig config = servlet.getServletConfig();
        ServletContext context = config.getServletContext();
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext(context);
        if (!MessageRouter.validMessage(dd, methodName)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + methodName + "' is not supported.");
        }
        this.targetObject = ServerHTTPUtils.getTargetObject(serviceManager, dd, targetObjectURI, servlet, session, reqContext, context);
    }

    public void invoke(SOAPContext reqContext, SOAPContext resContext) throws SOAPException {
        try {
            MessageRouter.invoke(this.dd, this.envelope, this.targetObject, this.methodName, reqContext, resContext);
        }
        catch (Exception e) {
            if (e instanceof SOAPException) {
                throw (SOAPException)e;
            }
            e.printStackTrace(System.err);
            throw new SOAPException(Constants.FAULT_CODE_SERVER, e.toString(), e);
        }
    }
}

