/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.filter.logicProcessor.AbstractIDSCmdProcessor;
import com.trs.idm.client.filter.logicProcessor.ProcessorUtil;
import com.trs.idm.client.filter.logicProcessor.UpdateUserProcessor;
import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class EnableUserProcessor
extends AbstractIDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(UpdateUserProcessor.class);
    private IAgent agent;
    private final String idsCmd = "enableUser";

    public EnableUserProcessor(IAgent agent) {
        this.agent = agent;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean opResult;
        String userNameBase64 = req.getHeader("userName");
        String userName = Base64Util.decode((String)userNameBase64);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("EnableUserProcessor userNameBase64:" + userNameBase64 + " ,userName:" + userName));
        }
        if (StringHelper.isEmpty((String)userName)) {
            LOG.error((Object)"process enableUser request error, userName is null");
            resp.sendError(500, "process enableUser request error, userName is null! (app, idsCmd)=" + this.agent.getAgentName() + "," + "enableUser" + ". host =" + InetAddress.getLocalHost());
            resp.sendError(500, "[AgentError]userName in http header is null, return false!");
            return;
        }
        String sourceName = ProcessorUtil.getSourceNameFromRequestHeader(req);
        Properties props = new Properties();
        try {
            props.put("userName", userName);
            props.put("sourceName", sourceName);
        }
        catch (Exception e) {
            LOG.error((Object)("Put userName[" + userName + "] and sourceName[" + sourceName + "] to properties fail! "), (Throwable)e);
        }
        SSOUser ssoUser = new SSOUser(props);
        if (resp.isCommitted()) {
            return;
        }
        try {
            opResult = this.agent.getServletAppActorV2().enableUser(req, resp, ssoUser);
        }
        catch (Throwable t) {
            LOG.error((Object)"[ActorErr]enableUser fail!", t);
            resp.sendError(500, "[ActorErr]enableUser() fail! err=" + t);
            return;
        }
        if (opResult) {
            resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "enableUser");
        } else {
            resp.sendError(500, "[ActorErr]enableUser() return false!");
        }
    }

    public String getIDSCmd() {
        return "enableUser";
    }
}

