/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.filter.logicProcessor.IDSCmdProcessor;
import com.trs.idm.client.filter.logicProcessor.ProcessorUtil;
import com.trs.idm.interact.agent.IAgent;
import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DelGroupProcessor
implements IDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(DelGroupProcessor.class);
    private IAgent agent;
    private final String idsCmd = "delGroup";

    public DelGroupProcessor(IAgent agent) {
        this.agent = agent;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String groupName = ProcessorUtil.getGroupNameFromRequestHeader(req);
        String sourceName = ProcessorUtil.getSourceNameFromRequestHeader(req);
        String groupDN = ProcessorUtil.getGroupDnFromRequestHeader(req);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("groupName:" + groupName));
        }
        SSOGroup ssoGroup = this.agent.getDelSSOGroup(groupName, sourceName, groupDN);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ssoGroup:" + ssoGroup));
        }
        if (ssoGroup == null) {
            LOG.error((Object)"[IDSAgent]group is null!");
            resp.sendError(500, "[IDSAgent]group is null! (app, idsCmd)=" + this.agent.getAgentName() + ", " + "delGroup" + ". host=" + InetAddress.getLocalHost());
        } else {
            boolean opResult;
            try {
                opResult = this.agent.getServletAppActorV2().delGroup(req, resp, ssoGroup);
            }
            catch (Throwable t) {
                LOG.error((Object)"[ActorErr]del group fail!", t);
                resp.sendError(500, "[ActorErr]delGroup() fail! err=" + t);
                return;
            }
            if (opResult) {
                resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "delGroup");
            } else {
                resp.sendError(500, "[ActorErr]delGroup() return false!");
            }
        }
    }

    public String getIDSCmd() {
        return "delGroup";
    }
}

