/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.filter.logicProcessor;

import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.filter.logicProcessor.IDSCmdProcessor;
import com.trs.idm.client.filter.logicProcessor.ProcessorUtil;
import com.trs.idm.interact.agent.IAgent;
import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AddGroupProcessor
implements IDSCmdProcessor {
    private static final Logger LOG = Logger.getLogger(AddGroupProcessor.class);
    private IAgent agent;
    private final String idsCmd = "addGroup";

    public AddGroupProcessor(IAgent agent) {
        this.agent = agent;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String groupDN;
        String sourceName;
        String groupName = ProcessorUtil.getGroupNameFromRequestHeader(req);
        SSOGroup ssoGroup = this.agent.getNewSSOGroup(groupName, sourceName = ProcessorUtil.getSourceNameFromRequestHeader(req), groupDN = ProcessorUtil.getGroupDnFromRequestHeader(req));
        if (ssoGroup == null) {
            LOG.error((Object)"[IDSAgent]group is null!");
            resp.sendError(500, "[IDSAgent]group is null! (app, idsCmd)=" + this.agent.getAgentName() + ", " + "addGroup" + ". host=" + InetAddress.getLocalHost());
        } else {
            boolean opResult;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SSOGroup :" + ssoGroup));
            }
            try {
                opResult = this.agent.getServletAppActorV2().addGroup(req, resp, ssoGroup);
            }
            catch (Throwable t) {
                LOG.error((Object)"[ActorErr]add group fail!", t);
                resp.sendError(500, "[ActorErr]addGroup() fail! err=" + t);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("opResult :" + opResult));
            }
            if (opResult) {
                resp.getOutputStream().print(String.valueOf(this.agent.getAgentName()) + "addGroup");
            } else {
                resp.sendError(500, "[ActorErr]addGroup() return false!");
            }
        }
    }

    public String getIDSCmd() {
        return "addGroup";
    }
}

