/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.exception.IdMException;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import org.apache.log4j.Logger;

public class LdapHelperV2 {
    private static final Logger logger = Logger.getLogger(LdapHelperV2.class);

    public static InitialLdapContext openContext(Hashtable ldapEnv, Control[] connCtls) throws NamingException {
        try {
            return new InitialLdapContext(ldapEnv, connCtls);
        }
        catch (NamingException e) {
            logger.error((Object)("fail on connect ldap server!" + ldapEnv), (Throwable)e);
            throw e;
        }
    }

    public static void close(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                logger.error((Object)"fail on close ldap context!", (Throwable)e);
            }
        }
    }

    public static NamingEnumeration searchData(Hashtable ldapEnv, String baseDN, Attributes attr) throws IdMException {
        InitialLdapContext ctx = null;
        try {
            ctx = LdapHelperV2.openContext(ldapEnv, null);
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search(baseDN, attr);
            return namingEnumeration;
        }
        catch (NamingException e) {
            logger.error((Object)("fail on search!baseDN=" + baseDN), (Throwable)e);
            throw new IdMException("\u641c\u7d22LDAP\u6570\u636e\u65f6\u51fa\u9519!", e);
        }
        finally {
            LdapHelperV2.close(ctx);
        }
    }

    public static Attributes searchAttributes(Hashtable ldapEnv, String guidFormated) throws IdMException {
        InitialLdapContext ctx = null;
        try {
            ctx = LdapHelperV2.openContext(ldapEnv, null);
            Attributes attributes = ctx.getAttributes(guidFormated, null);
            return attributes;
        }
        catch (NamingException e) {
            logger.error((Object)("fail on search attributes! guidFormated=" + guidFormated), (Throwable)e);
            throw new IdMException("\u641c\u7d22LDAP\u6570\u636e\u65f6\u51fa\u9519!", e);
        }
        finally {
            LdapHelperV2.close(ctx);
        }
    }

    public static NamingEnumeration searchData(Hashtable ldapEnv, String baseDN, String filter, SearchControls constraints, int maxResult) throws IdMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dn=" + baseDN + ", filter=" + filter + ", maxResult=" + maxResult));
        }
        InitialLdapContext ctx = null;
        Control[] connCtls = null;
        try {
            connCtls = new Control[]{new PagedResultsControl(maxResult, true)};
        }
        catch (IOException e) {
            logger.error((Object)("error while new PagedResultsControl, maxResult:" + maxResult + ", error:" + e));
        }
        try {
            NamingEnumeration<SearchResult> answers;
            ctx = LdapHelperV2.openContext(ldapEnv, connCtls);
            NamingEnumeration<SearchResult> namingEnumeration = answers = ctx.search(baseDN, filter, constraints);
            return namingEnumeration;
        }
        catch (NamingException e) {
            logger.error((Object)("fail on search!baseDN=" + baseDN + ", filter=" + filter + ", maxResult=" + maxResult), (Throwable)e);
            throw new IdMException("\u641c\u7d22LDAP\u6570\u636e\u65f6\u51fa\u9519!" + e.getMessage(), e);
        }
        finally {
            LdapHelperV2.close(ctx);
        }
    }

    public static NamingEnumeration searchData(Hashtable ldapEnv, String baseDN, String filter, SearchControls constraints, Control[] connCtls) throws IdMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dn=" + baseDN + ", filter=" + filter));
        }
        InitialLdapContext ctx = null;
        try {
            NamingEnumeration<SearchResult> answers;
            ctx = LdapHelperV2.openContext(ldapEnv, null);
            ctx.setRequestControls(connCtls);
            NamingEnumeration<SearchResult> namingEnumeration = answers = ctx.search(baseDN, filter, constraints);
            return namingEnumeration;
        }
        catch (NamingException e) {
            logger.error((Object)("fail on search!baseDN=" + baseDN + ", filter=" + filter), (Throwable)e);
            throw new IdMException("\u641c\u7d22LDAP\u6570\u636e\u65f6\u51fa\u9519!" + e.getMessage(), e);
        }
        finally {
            LdapHelperV2.close(ctx);
        }
    }

    public static NamingEnumeration searchData(Hashtable ldapEnv, String baseDN, String filter, SearchControls constraints) throws IdMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dn=" + baseDN + ", filter=" + filter));
        }
        InitialLdapContext ctx = null;
        try {
            NamingEnumeration<SearchResult> answers;
            ctx = LdapHelperV2.openContext(ldapEnv, null);
            NamingEnumeration<SearchResult> namingEnumeration = answers = ctx.search(baseDN, filter, constraints);
            return namingEnumeration;
        }
        catch (NamingException e) {
            logger.error((Object)("fail on search!baseDN=" + baseDN + ", filter=" + filter), (Throwable)e);
            throw new IdMException("\u641c\u7d22LDAP\u6570\u636e\u65f6\u51fa\u9519!" + e.getMessage(), e);
        }
        finally {
            LdapHelperV2.close(ctx);
        }
    }
}

