/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.interact.agent.IAgent;
import java.util.LinkedList;
import org.apache.log4j.Logger;

class AsyncTimeoutNotifier
implements Runnable {
    private static final int SLEEP_MS = 1000;
    private static final Logger LOG = Logger.getLogger(AsyncTimeoutNotifier.class);
    private LinkedList timeoutedSessionIds;
    private LinkedList notifyFailedSessionIds;
    private int maxAllowSessionIdNumber;
    private boolean needGc;
    private IAgent agent;

    AsyncTimeoutNotifier(IAgent agent) {
        this.agent = agent;
        this.timeoutedSessionIds = new LinkedList();
        this.notifyFailedSessionIds = new LinkedList();
        this.maxAllowSessionIdNumber = agent.getPropertyAsInt("maxAllowAsyncSessionIdNumber", 100000);
        String strNeedGc = agent.getProperty("clearTimeoutedSession.gc", "false");
        this.needGc = Boolean.getBoolean(strNeedGc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int size = 0;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                String sessionId;
                size = this.timeoutedSessionIds.size();
                if (size > this.maxAllowSessionIdNumber) {
                    LinkedList linkedList = this.timeoutedSessionIds;
                    synchronized (linkedList) {
                        this.timeoutedSessionIds.clear();
                    }
                    if (this.needGc) {
                        System.gc();
                    }
                    LOG.warn((Object)("timeoutedSessionIds size is bigger than maxAllowSessionIdNumber! So abandon all timeoutedSessionIds!  timeoutedSessionIds size is: " + size + ", maxAllowSessionIdNumber is : " + this.maxAllowSessionIdNumber));
                } else {
                    size = this.timeoutedSessionIds.size();
                    while (size > 0) {
                        --size;
                        sessionId = null;
                        try {
                            LinkedList linkedList = this.timeoutedSessionIds;
                            synchronized (linkedList) {
                                sessionId = (String)this.timeoutedSessionIds.removeFirst();
                            }
                            this.agent.notifyTimeout(sessionId);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"timeoutedSessionIds is null", (Throwable)e);
                            this.notifyFailedSessionIds.addLast(sessionId);
                        }
                    }
                }
                size = this.notifyFailedSessionIds.size();
                if (size > this.maxAllowSessionIdNumber) {
                    this.notifyFailedSessionIds.clear();
                    LOG.warn((Object)("notifyFailedSessionIds size is bigger than maxAllowSessionIdNumber! So abandon all notifyFailedSessionIds!  notifyFailedSessionIds size is: " + size + ", maxAllowSessionIdNumber is : " + this.maxAllowSessionIdNumber));
                    if (this.needGc) {
                        System.gc();
                        LOG.warn((Object)"do gc while clear notifyFailedSessionIds");
                    }
                } else {
                    size = this.notifyFailedSessionIds.size();
                    while (size > 0) {
                        sessionId = (String)this.notifyFailedSessionIds.removeFirst();
                        --size;
                        try {
                            this.agent.notifyTimeout(sessionId);
                        }
                        catch (Exception e) {
                            this.notifyFailedSessionIds.addLast(sessionId);
                        }
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"notifyTimeoutThread interrupted..");
                    break;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("error happen in AsyncTimeout Thread\uff0ctimeoutedSession size: " + size), (Throwable)e);
            }
        }
        this.timeoutedSessionIds = null;
        this.notifyFailedSessionIds = null;
        LOG.info((Object)"notifyTimeoutThread finished.");
    }

    void addNotify(String sessionId) {
        if (sessionId == null || sessionId.length() == 0) {
            return;
        }
        this.timeoutedSessionIds.addLast(sessionId);
    }

    public LinkedList getTimeoutedSessionIds() {
        return this.timeoutedSessionIds;
    }

    public LinkedList getNotifyFailedSessionIds() {
        return this.notifyFailedSessionIds;
    }

    public int getMaxAllowSessionIdNumber() {
        return this.maxAllowSessionIdNumber;
    }
}

