/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.sp.transporter.impl;

import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.saml.sp.transporter.ITransporter;
import com.trs.idm.saml.sp.transporter.ITransporterManager;
import com.trs.idm.saml.sp.transporter.impl.HttpClientTransporter;
import com.trs.idm.saml.sp.transporter.impl.HttpRedirectTransporter;
import com.trs.idm.saml.sp.transporter.impl.HttpSoapTransporter;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StdTransporterManager
implements ITransporterManager {
    private static final Logger LOG = Logger.getLogger(StdTransporterManager.class);
    private Map transporters;
    private ITransporter httpRedirectTransporter;
    private ITransporter httpClientTransporter;
    private ITransporter httpSoapTransporter;
    private IServiceProvider sp;

    public StdTransporterManager(IServiceProvider sp) {
        this.sp = sp;
    }

    public ITransporter getTransporter(String name) {
        ITransporter transporter = (ITransporter)this.transporters.get(name);
        if (transporter == null) {
            LOG.error((Object)("can not find Transporter by name: " + name));
            return null;
        }
        return transporter;
    }

    public void removeTransporter(String name) {
    }

    public void start() {
        this.transporters = new HashMap();
        this.httpRedirectTransporter = new HttpRedirectTransporter();
        this.httpClientTransporter = new HttpClientTransporter(this.sp.getIDPUrl());
        this.httpSoapTransporter = new HttpSoapTransporter();
        this.transporters.put("httpRedirect", this.httpRedirectTransporter);
        this.transporters.put("httpClient", this.httpClientTransporter);
        this.transporters.put("httpSoap", this.httpSoapTransporter);
    }

    public void stop() {
        this.transporters = null;
    }
}

