/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.interact.impl.simple.request;

import com.trs.idm.exception.ServiceProviderException;
import com.trs.idm.saml.common.IDSUser;
import com.trs.idm.saml.interact.IResponse;
import com.trs.idm.saml.interact.RequestBase;
import com.trs.idm.saml.interact.impl.simple.response.SimpleNotifyLoginResponse;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.saml.sp.core.SimpleServiceProvider;
import com.trs.idm.system.SSOConst;
import com.trs.idm.util.RequestUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SimpleNotifyLoginRequest
extends RequestBase {
    private static final Logger LOG = Logger.getLogger(SimpleNotifyLoginRequest.class);

    public SimpleNotifyLoginRequest(IServiceProvider sp, HttpServletRequest request) {
        this.requestType = "SimpleNotifyLoginRequest";
        this.serviceProvider = sp;
    }

    public boolean validate() {
        return true;
    }

    public IResponse doRequest(HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        String loginUserName = RequestUtil.getParameterAndTrim(request, SSOConst.USERPROPS_USERNAME);
        LOG.debug((Object)("loginUserName from request is: " + loginUserName));
        if (loginUserName != null) {
            IDSUser idsUser = new IDSUser();
            idsUser.setUserName(loginUserName);
            if (this.serviceProvider.useActor()) {
                LOG.info((Object)"use actor to do localLogin");
                if (this.serviceProvider instanceof SimpleServiceProvider) {
                    ((SimpleServiceProvider)this.serviceProvider).doLocalLogin(request, response, idsUser);
                }
            }
            return new SimpleNotifyLoginResponse(idsUser);
        }
        return null;
    }

    public IServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }
}

