/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent.socket;

import com.trs.idm.interact.agent.ClientTransferManager;
import com.trs.idm.interact.agent.ClientTransferProxy;
import com.trs.idm.interact.agent.socket.BaseSocketManager;
import com.trs.idm.interact.agent.socket.SocketHostManager;
import com.trs.idm.interact.protocol.RequestPacket;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IdleSocketManager
extends BaseSocketManager {
    private static final Logger LOG = Logger.getLogger(ClientTransferManager.class);
    private static final int DEFAULT_WAIT_TIME = 15000;
    private int waitMillis;
    private int maxActivedCount;
    private int maxIdleCount;

    public IdleSocketManager(SocketHostManager manager) {
        super(manager);
        super.setName("IdleQueue/1.0");
        this.waitMillis = manager.getAgent().getPropertyAsInt("socket.dispatchWaitMillis", 15000);
        this.monitorThread = new Thread(new IdleSocketBackgroundProcessor(this));
        this.monitorThread.setName("TRSIDSAgent.IdleQueueBackground." + manager.getAgent().getAgentName());
        if (this.waitMillis != 0 && (this.waitMillis < 3000 || this.waitMillis > 90000)) {
            this.waitMillis = 15000;
        }
        LOG.info((Object)("waitMillis when get idle socket: " + this.waitMillis));
    }

    public void enter(ClientTransferProxy client) {
        if (this.isValidClient(client)) {
            client.onIdle();
            super.push(client);
            this.manager.getHost(client).onEnterIdle();
        } else {
            this.closeProxy(client);
        }
    }

    private void closeProxy(ClientTransferProxy client) {
        this.manager.getHost(client).onLeaveIdle();
        this.manager.closeProxy(client);
    }

    void refresh(ClientTransferProxy client) {
        if (this.isValidClient(client)) {
            client.onRefresh();
        } else {
            this.closeProxy(client);
        }
    }

    private boolean isValidClient(ClientTransferProxy client) {
        if (client.getType() == "perm") {
            return true;
        }
        return this.isMaxActiveCount(client) || this.isMaxIdleCount(client);
    }

    private boolean isMaxActiveCount(ClientTransferProxy client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(String.valueOf(client.getClient().getNodeKeyOfIDSServer()) + "'s ActiveCount=" + client.getActiveCount() + ",maxActiveCount=" + this.maxIdleCount));
        }
        return this.maxActivedCount == -1 ? false : client.getActiveCount() >= this.maxActivedCount;
    }

    private boolean isMaxIdleCount(ClientTransferProxy client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(String.valueOf(client.getClient().getNodeKeyOfIDSServer()) + "'s IdleCount=" + client.getIdleCount() + ",maxIdleCount=" + this.maxIdleCount));
        }
        return this.maxIdleCount == -1 ? false : client.getIdleCount() >= this.maxIdleCount;
    }

    private void leave(ClientTransferProxy client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ClientTransferProxy (" + client + ")to leave the idle queue."));
        }
        client.endIdle();
        this.manager.getHost(client).onLeaveIdle();
    }

    public ClientTransferProxy getClientTransfer() {
        ClientTransferProxy client = super.pop();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ClientTransferProxy (" + client + ") get it."));
        }
        if (client != null) {
            this.leave(client);
            return client;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTransferProxy[] removeByHost(String host) {
        LOG.info((Object)("ClientTransfers to host(" + host + ") to remove from idle queue."));
        ArrayList<ClientTransferProxy> toRemoveProxies = new ArrayList<ClientTransferProxy>();
        if (host == null) {
            return toRemoveProxies.toArray(new ClientTransferProxy[0]);
        }
        List list = this.clientTransferProxies;
        synchronized (list) {
            int i = 0;
            while (i < this.clientTransferProxies.size()) {
                ClientTransferProxy proxy = (ClientTransferProxy)this.clientTransferProxies.get(i);
                if (proxy == null) break;
                if (host.equals(proxy.getClient().getHost())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Proxy:" + proxy + " to remove from idle queue."));
                    }
                    this.clientTransferProxies.remove(i);
                    this.leave(proxy);
                    toRemoveProxies.add(proxy);
                    continue;
                }
                ++i;
            }
            LOG.info((Object)("The size of ClientTransfer2Remove is:" + toRemoveProxies.size()));
            return toRemoveProxies.toArray(new ClientTransferProxy[0]);
        }
    }

    public ClientTransferProxy getClientTransfer(String nodeKey) {
        return this.getClientTransfer();
    }

    class IdleSocketBackgroundProcessor
    implements Runnable {
        private final Logger LOG = Logger.getLogger(IdleSocketBackgroundProcessor.class);
        static final int DETECT_INTERVAL = 120000;
        private IdleSocketManager idleSocketManager;

        IdleSocketBackgroundProcessor(IdleSocketManager idleSocketManager2) {
            this.idleSocketManager = idleSocketManager2;
        }

        public void run() {
            while (!this.idleSocketManager.getClientTransferManager().isThreadDone()) {
                try {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException e) {
                        this.LOG.info((Object)"IdleSocketBackgroundProcessor interrupted. ");
                    }
                    ClientTransferProxy[] proxies = this.idleSocketManager.listAllProxies();
                    int errorAmount = proxies.length;
                    if (errorAmount > 0) {
                        int i = 0;
                        while (i < errorAmount) {
                            this.idleSocketManager.refresh(proxies[i]);
                            ++i;
                        }
                    }
                    this.ping();
                }
                catch (Exception e) {
                    this.LOG.error((Object)"---------- IdleQueueBackgroundProcessor Thread Error------------");
                    this.LOG.error((Object)e);
                    this.LOG.error((Object)"------------------------------------------");
                }
            }
        }

        private byte[] ping() {
            byte[] bs = new byte[]{};
            try {
                RequestPacket req = new RequestPacket(100, bs);
                this.idleSocketManager.getClientTransferManager().doTransfer(req.toBytes());
            }
            catch (Exception e) {
                this.LOG.error((Object)("agent and ids disconnected! agent=" + IdleSocketManager.this.manager.getAgent()), (Throwable)e);
            }
            return bs;
        }
    }
}

