/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.interact.agent.IAgent;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.CookieHelper;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class AgentUtil {
    private static final Logger LOG = Logger.getLogger(AgentUtil.class);

    public static boolean alreadyBindSSO(CookieHelper ckHelper, IAgent agent) {
        boolean useStdHttpSession = agent.getServletAppActorV2().useStandardHttpSession();
        LOG.debug((Object)("useStdHttpSession: " + useStdHttpSession));
        if (useStdHttpSession) {
            return AgentUtil.alreadyBindSSOFromSession(ckHelper, agent);
        }
        return AgentUtil.alreadyBindSSOFromCookie(ckHelper, agent);
    }

    public static void removeSSOBind(CookieHelper ckHelper, IAgent agent) {
        if (agent.getServletAppActorV2().useStandardHttpSession()) {
            AgentUtil.removeSSOBindFromSession(ckHelper, agent);
        } else {
            AgentUtil.removeSSOBindFromCookie(ckHelper, agent);
        }
    }

    private static boolean alreadyBindSSOFromSession(CookieHelper ckHelper, IAgent agent) {
        HttpSession session = ckHelper.getRequest().getSession(false);
        LOG.debug((Object)("HttpSession from ckHelper.getRequest().getSession(false): " + session));
        if (session == null) {
            return false;
        }
        LOG.debug((Object)("HttpSession ID: " + session.getId()));
        String ssoIdInUrl = AgentUtil.getBindSSOIdInUrl(ckHelper.getRequest());
        String ssoIdInSession = null;
        try {
            ssoIdInSession = (String)session.getAttribute(agent.getAnonymousFlag());
        }
        catch (Exception e) {
            LOG.warn((Object)("the ERROR can ignore: " + e.toString()));
            return false;
        }
        String agModeInUrl = AgentUtil.getBindAgModeInUrl(ckHelper.getRequest().getQueryString());
        String agModeInSession = (String)session.getAttribute("com.trs.ids.guest");
        boolean mayGuest = ssoIdInSession != null || ssoIdInUrl != null || agModeInSession != null || agModeInUrl != null;
        LOG.debug((Object)("Already bind ssoId in httpSession: " + mayGuest + "; httpSessionId is: " + session + "; ssoIdInSession: " + ssoIdInSession + "; ssoIdInUrl: " + ssoIdInUrl + "; agModeInSession: " + agModeInSession + "; agModeInUrl: " + agModeInUrl));
        if (mayGuest) {
            if (ssoIdInSession == null && ssoIdInUrl != null) {
                session.setAttribute(agent.getAnonymousFlag(), (Object)ssoIdInUrl);
            }
            if (agModeInSession == null && agModeInUrl != null) {
                session.setAttribute("com.trs.ids.guest", (Object)"1");
            }
        }
        return mayGuest;
    }

    public static void saveSSOId(String ssoIdInUrl, CookieHelper ckHelper, IAgent agent) {
        if (agent.getServletAppActorV2().useStandardHttpSession()) {
            HttpSession session = ckHelper.getRequest().getSession(false);
            if (session != null) {
                session.setAttribute(agent.getAnonymousFlag(), (Object)ssoIdInUrl);
            }
        } else {
            ckHelper.addCookie(agent.getAnonymousFlag(), ssoIdInUrl);
        }
    }

    private static boolean alreadyBindSSOFromCookie(CookieHelper ckHelper, IAgent agent) {
        String ssoIdInUrl = AgentUtil.getBindSSOIdInUrl(ckHelper.getRequest());
        String ssoIdInCookie = ckHelper.getValue(agent.getAnonymousFlag());
        LOG.debug((Object)("ssoIdInUrl: " + ssoIdInUrl + "; ssoIdInCookie: " + ssoIdInCookie));
        String agModeInUrl = AgentUtil.getBindAgModeInUrl(ckHelper.getRequest().getQueryString());
        String agModeInCookie = ckHelper.getValue("com.trs.ids.guest");
        boolean mayGuest = ssoIdInCookie != null || ssoIdInUrl != null || agModeInCookie != null || agModeInUrl != null;
        String currentCoSessionId = agent.getServletAppActorV2().getSessionId(ckHelper.getRequest(), ckHelper.getResponse(), true);
        String coSessionIdInCookie = ckHelper.getValue(agent.getCoSessionIdFlag());
        LOG.debug((Object)("currentCoSessionId: " + currentCoSessionId + "; " + "coSessionIdInCookie: " + coSessionIdInCookie));
        boolean coSessionIdInCookieEqualsCurrentSessionId = currentCoSessionId.equals(coSessionIdInCookie);
        boolean alreadyBindSSO = mayGuest && coSessionIdInCookieEqualsCurrentSessionId;
        LOG.debug((Object)("alreadyBindSSO: " + alreadyBindSSO + "; mayGuest: " + mayGuest + "; coSessionId in Cookie equals current sessionId: " + coSessionIdInCookieEqualsCurrentSessionId));
        if (alreadyBindSSO) {
            if (ssoIdInCookie == null && ssoIdInUrl != null) {
                ckHelper.addCookie(agent.getAnonymousFlag(), ssoIdInUrl);
            }
            if (agModeInCookie == null && agModeInUrl != null) {
                ckHelper.addCookie("com.trs.ids.guest", "1");
            }
        }
        return alreadyBindSSO;
    }

    private static void removeSSOBindFromCookie(CookieHelper ckHelper, IAgent agent) {
        ckHelper.removeCookie("com.trs.ids.guest");
        ckHelper.removeCookie(agent.getAnonymousFlag());
    }

    private static void removeSSOBindFromSession(CookieHelper ckHelper, IAgent agent) {
        block3: {
            HttpSession session = ckHelper.getRequest().getSession(false);
            if (session != null) {
                try {
                    session.removeAttribute(agent.getAnonymousFlag());
                    session.removeAttribute("com.trs.ids.guest");
                }
                catch (IllegalStateException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("the ERROR can ignore. session.removeAttribute fail: " + e.toString()));
                }
            }
        }
    }

    public static String getBindSSOId(CookieHelper ckHelper, IAgent agent) {
        if (agent.getServletAppActorV2().useStandardHttpSession()) {
            return AgentUtil.getBindSSOIdFromSession(ckHelper, agent);
        }
        return AgentUtil.getBindSSOIdFromCookie(ckHelper, agent);
    }

    public static String getBindSSOIdInUrl(HttpServletRequest request) {
        String qryStr = request.getQueryString();
        if (qryStr == null) {
            return null;
        }
        int pos = qryStr.lastIndexOf("com.trs.idm.gSessionId=");
        if (pos == -1) {
            return null;
        }
        if (pos == 0) {
            return qryStr.substring("com.trs.idm.gSessionId".length() + 1);
        }
        if (qryStr.charAt(pos - 1) != '&') {
            return null;
        }
        return qryStr.substring(pos + "com.trs.idm.gSessionId".length() + 1);
    }

    private static String getBindSSOIdFromCookie(CookieHelper ckHelper, IAgent agent) {
        return ckHelper.getValue(agent.getAnonymousFlag());
    }

    static String getBindAgModeInUrl(String reqQueryString) {
        String agModeFlag = "agMode=1";
        if (StringHelper.isEmpty(reqQueryString)) {
            return null;
        }
        int pos = reqQueryString.lastIndexOf(agModeFlag);
        if (pos < 0) {
            return null;
        }
        if (pos == 0) {
            return agModeFlag;
        }
        char preChar = reqQueryString.charAt(pos - 1);
        if (preChar != '&' & preChar != '?') {
            return null;
        }
        return agModeFlag;
    }

    private static String getBindSSOIdFromSession(CookieHelper ckHelper, IAgent agent) {
        HttpSession session = ckHelper.getRequest().getSession(false);
        if (session == null) {
            return null;
        }
        try {
            return (String)session.getAttribute(agent.getAnonymousFlag());
        }
        catch (Exception e) {
            LOG.warn((Object)("the ERROR can ignore: " + e.toString()));
            return null;
        }
    }

    public static void processHttpServeltResponse(HttpServletResponse response) {
        if (response == null) {
            return;
        }
        if (response.isCommitted()) {
            LOG.info((Object)"call page actor, response has been commited");
            return;
        }
    }

    public static String getLogoutReturnUrl(HttpServletRequest request, IAgent agent) {
        String oldReturnUrl = request.getParameter("retUrl");
        String newReturnUrl = request.getParameter("targeturl");
        String actualRetUrl = !StringHelper.isEmpty(newReturnUrl) ? newReturnUrl : oldReturnUrl;
        if (StringHelper.isEmpty(actualRetUrl)) {
            actualRetUrl = RequestUtil.getContextRoot(request, agent.getOriginalHostHttpHeader());
        }
        return actualRetUrl;
    }

    public static void forwardToAutosubmitPageWithPostParam(HttpServletRequest request, HttpServletResponse response, CookieHelper ckHelper, String originUrl) throws ServletException, IOException {
        boolean hasPostParamInCookie = AgentUtil.havePostParamInCookie(ckHelper);
        LOG.debug((Object)("hasPostParamInCookie with cookie name[com.trs.ids.app.postParam]: " + hasPostParamInCookie));
        String appOriginalpostPrameters = "";
        if (hasPostParamInCookie) {
            appOriginalpostPrameters = Base64Util.decode(ckHelper.getValue("com.trs.ids.app.postParam"), "UTF-8");
            LOG.debug((Object)("originUrl: " + originUrl + "; appOriginalpostPrameters: " + appOriginalpostPrameters + "; encodedPostParam in Cookie: " + ckHelper.getValue("com.trs.ids.app.postParam")));
            ckHelper.removeCookie("com.trs.ids.app.postParam");
        } else {
            String postPrametersInRequest = RequestUtil.getPostParametersAsString(request);
            LOG.debug((Object)("hasPostParam in current request: " + StringHelper.isEmpty(postPrametersInRequest)));
            if (!StringHelper.isEmpty(postPrametersInRequest)) {
                LOG.debug((Object)("postPrametersInRequest: " + postPrametersInRequest));
                appOriginalpostPrameters = postPrametersInRequest;
            }
        }
        request.setAttribute("targetUrl", (Object)originUrl);
        request.setAttribute("postParameters", (Object)appOriginalpostPrameters);
        request.getRequestDispatcher("/WEB-INF/idsAgentPages/autoSubmit.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public static boolean havePostParamInCookie(CookieHelper ckHelper) {
        return ckHelper.getCookie("com.trs.ids.app.postParam") != null;
    }

    public static void savePostParamInCookie(HttpServletRequest request, CookieHelper ckHelper) {
        String appOriginalPostParams = RequestUtil.getPostParametersAsString(request);
        String encodedPostParams = Base64Util.encode(appOriginalPostParams, "UTF-8");
        LOG.debug((Object)("appOriginalPostParams: " + appOriginalPostParams + "; encodedPostParams: " + encodedPostParams));
        if (!StringHelper.isEmpty(appOriginalPostParams)) {
            LOG.info((Object)"has appOriginalPostParams in request, save it into cookie");
            ckHelper.addCookie("com.trs.ids.app.postParam", encodedPostParams);
        }
    }

    public static void saveCoSessionIdInCookie(CookieHelper ckHelper, IAgent agent, String coSessionId) {
        String valueInCookie = ckHelper.getValue(agent.getCoSessionIdFlag());
        if (StringHelper.isEmpty(coSessionId)) {
            coSessionId = agent.getServletAppActorV2().getSessionId(ckHelper.getRequest(), ckHelper.getResponse(), true);
        }
        LOG.debug((Object)("already has " + agent.getCoSessionIdFlag() + ": " + valueInCookie + " in cookie, current coSessionId :" + coSessionId + "."));
        ckHelper.addCookie(agent.getCoSessionIdFlag(), coSessionId);
    }

    public static void saveCoSessionIdInCookie(CookieHelper ckHelper, IAgent agent) {
        AgentUtil.saveCoSessionIdInCookie(ckHelper, agent, null);
    }
}

