/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.authorization.processor;

import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.authorization.IAuthorizationActor;
import com.trs.idm.client.authorization.bo.Role;
import com.trs.idm.client.authorization.processor.IAuthorizationProcessor;
import com.trs.idm.util.StringHelper;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class UpdURAProcessor
implements IAuthorizationProcessor {
    private static final Logger logger = Logger.getLogger(UpdURAProcessor.class);
    private IAuthorizationActor actor;

    public UpdURAProcessor(IAuthorizationActor actor) {
        this.actor = actor;
    }

    public String process(String data) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request data from server is " + data));
        }
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)data);
        }
        catch (DocumentException e) {
            logger.error((Object)("parse user's role assignments failed,data is " + data), (Throwable)e);
        }
        if (doc == null) {
            return null;
        }
        Element assignments = doc.getRootElement();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("update user's role assignments to " + assignments.asXML()));
        }
        if (assignments != null) {
            String userName = assignments.attributeValue("userName");
            String sourceName = assignments.attributeValue("sourceName");
            logger.debug((Object)("userName: " + userName + "; sourceName: " + sourceName));
            if (StringHelper.isEmpty(userName)) {
                logger.error((Object)"can not get userName from new ura.");
                return null;
            }
            if (StringHelper.isEmpty(sourceName)) {
                sourceName = "ids_internal";
            }
            Properties userProps = new Properties();
            try {
                userProps.put("userName", userName);
                userProps.put("sourceName", sourceName);
            }
            catch (Exception e) {
                logger.error((Object)("Put userName[" + userName + "] and sourceName[" + sourceName + "] to properties fail! "), (Throwable)e);
            }
            logger.debug((Object)("userProps after created: " + userProps));
            SSOUser user = new SSOUser(userProps);
            logger.debug((Object)("Generate user " + user + " form properties [" + userProps + "]"));
            Iterator iter = assignments.elementIterator("role");
            logger.debug((Object)("Generate roles from xml: " + iter));
            if (iter != null) {
                while (iter.hasNext()) {
                    Element eleRole = (Element)iter.next();
                    String id = eleRole.attributeValue("id");
                    String name = eleRole.attributeValue("name");
                    boolean isAssigned = "true".equalsIgnoreCase(eleRole.attributeValue("assigned"));
                    Role role = new Role(id, name);
                    logger.debug((Object)("isAssigned: " + isAssigned + "; actor.isRoleAssigned(role, user): " + this.actor.isRoleAssigned(role, user)));
                    if (isAssigned == this.actor.isRoleAssigned(role, user)) continue;
                    if (isAssigned) {
                        logger.debug((Object)("Assign user[" + user + "] to role[" + role + "]"));
                        this.actor.assignRole(role, user);
                        logger.debug((Object)"AssignRole done!");
                        continue;
                    }
                    logger.debug((Object)("Revoke user[" + user + "] from role" + role + "]"));
                    this.actor.revokeRole(role, user);
                    logger.debug((Object)"RevokeRole done!");
                }
            }
        }
        return null;
    }
}

