/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.authorization.processor;

import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.authorization.IAuthorizationActor;
import com.trs.idm.client.authorization.bo.Group;
import com.trs.idm.client.authorization.processor.IAuthorizationProcessor;
import com.trs.idm.util.StringHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GetUGAProcessor
implements IAuthorizationProcessor {
    private static final Logger logger = Logger.getLogger(GetUGAProcessor.class);
    private IAuthorizationActor actor;

    public GetUGAProcessor(IAuthorizationActor actor) {
        this.actor = actor;
    }

    public String process(String data) {
        Map parameters;
        String userName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request data is " + data));
        }
        if (StringHelper.isEmpty(userName = (String)(parameters = this.parseQueryRequest(data)).get("userName"))) {
            logger.error((Object)"request to get user's group assignments,but userName is empty.");
            return null;
        }
        Element assignments = DocumentHelper.createDocument().addElement("user_group_assignments");
        Properties userProps = new Properties();
        userProps.put("userName", userName);
        SSOUser user = new SSOUser(userProps);
        List roots = this.actor.listRootGroups();
        if (roots != null && !roots.isEmpty()) {
            for (Group root : roots) {
                this.buildGroupRecursive(assignments, root, user);
            }
        }
        String result = assignments.asXML();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get user " + userName + "'s group assignments is : " + result));
        }
        return result;
    }

    private void buildGroupRecursive(Element eleParent, Group group, SSOUser user) {
        Element eleGroup = eleParent.addElement("group");
        eleGroup.addAttribute("id", group.getId());
        eleGroup.addAttribute("name", group.getName());
        eleGroup.addAttribute("assigned", this.actor.isGroupAssigned(group, user) ? "true" : "false");
        List children = this.actor.listSubGroups(group);
        if (children != null && !children.isEmpty()) {
            for (Group child : children) {
                this.buildGroupRecursive(eleGroup, child, user);
            }
        }
    }

    private Map parseQueryRequest(String request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Iterator parameterIterator = null;
        try {
            parameterIterator = DocumentHelper.parseText((String)request).getRootElement().elementIterator("parameter");
        }
        catch (DocumentException documentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (parameterIterator != null) {
            while (parameterIterator.hasNext()) {
                Element eleParameter = (Element)parameterIterator.next();
                String name = eleParameter.attributeValue("name");
                if (StringHelper.isEmpty(name)) continue;
                parameters.put(name, eleParameter.attributeValue("value"));
            }
        }
        return parameters;
    }
}

