/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dl.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DbConnUtil {
    private static final Logger LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.dl.util.DbConnUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public static Connection tryConnect(String driver, String url, String user, String pwd) throws ClassNotFoundException, SQLException {
        if (driver == null || driver.trim().length() == 0) {
            throw new IllegalArgumentException("the jdbc driver class is empty!");
        }
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("the jdbc url is empty!");
        }
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("load JDBC Driver fail! driverClass: " + driver), (Throwable)e);
            throw e;
        }
        try {
            Connection conn = DriverManager.getConnection(url, user, pwd);
            return conn;
        }
        catch (SQLException e) {
            LOG.error((Object)("DriverManager.getConnection(" + url + ", " + user + ", " + pwd + ") fail! jdbcDriver=" + driver), (Throwable)e);
            throw new SQLException("connect db fail! (url, user, driver)=(" + url + ", " + user + ", " + driver + "), err: " + e.getMessage());
        }
    }

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.error((Object)"fail to close db connection!", (Throwable)e);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.error((Object)"fail to close resultset!", (Throwable)e);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("fail to close " + stmt.getClass().getName()), (Throwable)e);
            }
        }
    }
}

