/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.session.impl;

import com.trs.dev4.jdk16.cacheserver.memcached.IMemcachedClient;
import com.trs.dev4.jdk16.session.ISessionUser;
import com.trs.dev4.jdk16.session.impl.ApplicationSession;
import com.trs.dev4.jdk16.session.impl.LocalSessionHandler;
import com.trs.dev4.jdk16.utils.StringHelper;
import javax.annotation.Resource;
import org.apache.log4j.Logger;

public class CachedSessionHandler<T extends ISessionUser>
extends LocalSessionHandler<T> {
    private static final String ASID_PREFIX = "ASID_";
    private static final String LOGIN_PREFIX = "L_";
    private static final Logger logger = Logger.getLogger(CachedSessionHandler.class);
    @Resource(name="memcachedClient")
    protected IMemcachedClient memcachedClient = null;

    @Override
    protected void applicationSessionUpdated(ApplicationSession as) {
        super.applicationSessionUpdated(as);
        if (as != null && as.isLogined()) {
            this.updateCache(as);
        } else {
            logger.debug((Object)("ApplicationSession(" + as + ") is anonymous session,don't update to memcache."));
        }
    }

    private void updateCache(ApplicationSession as) {
        if (this.memcachedClient != null) {
            this.memcachedClient.set(LOGIN_PREFIX + as.getUserName(), (int)this.getLoginedTTL() * 1000, as.getId());
            logger.debug((Object)("ApplicationSession(" + as + ") update to memcache."));
            if (this.memcachedShared()) {
                this.memcachedClient.set(ASID_PREFIX + as.getId(), (int)this.getLoginedTTL() * 1000, as);
            }
        } else {
            logger.debug((Object)"MemcachedClient is null.");
        }
    }

    protected boolean memcachedShared() {
        return false;
    }

    public void setMemcachedClient(IMemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    @Override
    public boolean isLogined(String userName) {
        if (this.memcachedClient != null) {
            String cachedApplicationSessionId = (String)this.memcachedClient.get(LOGIN_PREFIX + userName);
            logger.debug((Object)("ApplicationSessionId(" + cachedApplicationSessionId + ") got from memcache by (" + userName + ")."));
            return !StringHelper.isEmpty(cachedApplicationSessionId);
        }
        logger.debug((Object)"MemcacedClient is null.");
        return true;
    }

    @Override
    protected void applicationSessionDeleted(ApplicationSession as) {
        super.applicationSessionDeleted(as);
        if (as != null && as.isLogined()) {
            this.deleteCache(as);
        } else {
            logger.debug((Object)("ApplicationSession(" + as + ") is anonymous session,don't need delete from memcache."));
        }
    }

    @Override
    protected void timeout(ApplicationSession as) {
        super.timeout(as);
        if (as != null && as.isLogined()) {
            this.deleteCache(as);
        } else {
            logger.debug((Object)("ApplicationSession(" + as + ") is anonymous session,don't need delete from memcache."));
        }
    }

    private void deleteCache(ApplicationSession as) {
        if (this.memcachedClient != null) {
            this.memcachedClient.delete(LOGIN_PREFIX + as.getUserName());
            logger.debug((Object)("ApplicationSession(" + as + ") delete from memcache with L_" + as.getUserName() + "."));
            if (this.memcachedShared()) {
                this.memcachedClient.delete(ASID_PREFIX + as.getId());
            }
        } else {
            logger.debug((Object)"MemcachedClient is null.");
        }
    }
}

