/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.license;

import com.trs.dev4.license.ILicenseServer;
import com.trs.dev4.license.LicenseConst;
import org.apache.log4j.Logger;

public abstract class BaseLicenseServer
implements ILicenseServer {
    private static final Logger LOG;
    private Thread expireChecker;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.dev4.license.BaseLicenseServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public boolean licenseRegistered() {
        return this.getLicenseStatus() == 1;
    }

    public boolean licenseStillOnTrail() {
        return this.getLicenseStatus() == -1;
    }

    public String getLicenseStatusAsStr() {
        return LicenseConst.getStatusString(this.getLicenseStatus(), this.getAvailableTrialDays());
    }

    public final void startServer(String basePath) {
        this.startServerInternal(basePath);
        LOG.info((Object)this.getLicenseStatusAsStr());
        if (this.licenseStillOnTrail()) {
            LOG.info((Object)"still on trial, so start LicenseExpireChecker");
            this.expireChecker = new Thread(new LicenseExpireChecker(this));
            this.expireChecker.setName("TRSDev4.ExpireChecker");
            this.expireChecker.start();
        }
    }

    protected abstract void startServerInternal(String var1);

    public final void stopServer() {
        if (this.expireChecker != null) {
            this.expireChecker.interrupt();
            this.expireChecker = null;
        }
        this.stopServerInternal();
    }

    protected void stopServerInternal() {
    }

    public abstract int getLicenseStatus();

    protected class LicenseExpireChecker
    implements Runnable {
        private static final int SLEEP_INTERVER = 3000;
        private ILicenseServer licenseServer;

        LicenseExpireChecker(ILicenseServer licenseServer) {
            this.licenseServer = licenseServer;
        }

        public void run() {
            LOG.info((Object)"ExpireChecker Started.");
            while (!Thread.currentThread().isInterrupted()) {
                if (this.licenseServer.licenseRegistered()) break;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.licenseServer.updateTrialRemainDays();
            }
            LOG.info((Object)"ExpireChecker Stopped.");
        }
    }
}

