/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.view.dwr;

import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.bean.DbParams;
import com.trs.cis4.gateway.bean.FtpConfig;
import com.trs.cis4.gateway.bean.LogData;
import com.trs.cis4.gateway.bean.MachineData;
import com.trs.cis4.gateway.bean.TaskStatus;
import com.trs.cis4.gateway.logic.IConfigLogic;
import com.trs.cis4.gateway.view.form.MissionForm;
import com.trs.cis4.gateway.view.util.TrsagentServerExtend;
import com.trs.cis4.socket.config.RobotConfig;
import com.trs.cis4.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwrUtil {
    private Logger log = Logger.getLogger(this.getClass());
    private IConfigLogic configLogic;

    public List<MissionForm> dwr_getMissionList(String robotid, int dbtype, int trspolicy) {
        ArrayList<MissionForm> list = new ArrayList<MissionForm>();
        if (this.setRobotConfig(robotid)) {
            try {
                List<AgentConfig> agentConfigs = this.getConfigLogic().gets();
                List<TaskStatus> taskStatus = this.getConfigLogic().getTaskStatus();
                for (AgentConfig aconfig : agentConfigs) {
                    MissionForm missionForm = new MissionForm();
                    int rdb_type = aconfig.getRdbConfig().getRdb_type();
                    int trs_policy = aconfig.getTrsConfig().getTrs_policy();
                    String source = "";
                    String target = "";
                    if (dbtype != -1 && (dbtype != rdb_type || trspolicy != -1 && trspolicy != trs_policy)) continue;
                    missionForm.setTask_name(aconfig.getTask_name());
                    missionForm.setRun_policy(aconfig.getRunConfig().getRun_policy());
                    missionForm.setBelongtoType(aconfig);
                    missionForm.setUpdate_mode(aconfig);
                    for (TaskStatus status : taskStatus) {
                        if (!status.getTask_name().equalsIgnoreCase(aconfig.getTask_name())) continue;
                        missionForm.setStatus(status.getStatus());
                        missionForm.setRun_times(status.getRun_time());
                        missionForm.setNext_run_time_format(status.getNext_runtime());
                        break;
                    }
                    if (rdb_type == 0) {
                        MachineData machineData;
                        if (trs_policy == 0) {
                            source = aconfig.getTrsConfig().getTrs_directory();
                            if (aconfig.getMachine_list().size() > 0) {
                                machineData = aconfig.getMachine_list().get(0);
                                target = String.valueOf(machineData.getTrs_database()) + "@" + machineData.getTrs_server();
                            }
                            missionForm.setMissionType(2);
                        }
                        if (trs_policy == 1) {
                            if (aconfig.getMachine_list().size() > 0) {
                                machineData = aconfig.getMachine_list().get(0);
                                source = String.valueOf(machineData.getTrs_database()) + "@" + machineData.getTrs_server();
                            }
                            missionForm.setMissionType(1);
                        }
                    } else {
                        source = String.valueOf(aconfig.getRdbConfig().getRdb_table()) + "@" + aconfig.getRdbConfig().getRdb_server();
                        if (trs_policy == 1) {
                            if (aconfig.getMachine_list().size() > 0) {
                                int i = 0;
                                while (i < aconfig.getMachine_list().size()) {
                                    MachineData machineData = aconfig.getMachine_list().get(i);
                                    if (machineData.getMachine_view() != 1) {
                                        target = String.valueOf(machineData.getTrs_database()) + "@" + machineData.getTrs_server();
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            missionForm.setMissionType(4);
                        }
                        if (trs_policy == 0) {
                            target = aconfig.getTrsConfig().getTrs_directory();
                            missionForm.setMissionType(3);
                        }
                    }
                    missionForm.setSource(source);
                    missionForm.setTarget(target);
                    list.add(missionForm);
                }
            }
            catch (Exception e) {
                list = new ArrayList();
                this.log.error((Object)("dwrUtil\u83b7\u53d6\u4efb\u52a1\u5217\u8868\u5931\u8d25\uff1a" + e));
            }
        }
        return list;
    }

    public String dwr_TestDBLink(String robotid, String rdbClientCharset, String dbservername, String trs_port, String dbusername, String dbpassword, int rdb_type) {
        String info = "";
        if (this.setRobotConfig(robotid)) {
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(dbservername);
            dbParams.setDbport(Integer.parseInt(trs_port));
            dbParams.setDbuser(dbusername);
            dbParams.setDbpassword(dbpassword);
            dbParams.setDbtype(rdb_type);
            dbParams.setRdbClientCharset(rdbClientCharset);
            try {
                info = this.getConfigLogic().loginDb(dbParams);
            }
            catch (Exception e) {
                info = e instanceof ExceptionUtil ? e.getMessage() : "\u8fde\u63a5\u5931\u8d25\uff01";
                this.log.error((Object)("dwrUtil\u6d4b\u8bd5\u6570\u636e\u5e93\u7684\u8fde\u901a\u6027\u5931\u8d25\uff1a" + e));
            }
        }
        return info;
    }

    public List<String> dwr_getUserSchema(String robotid, String rdbClientCharset, String dbservername, String dbusername, String dbpassword, int rdb_type, int isTable) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.setRobotConfig(robotid)) {
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(dbservername);
            dbParams.setDbuser(dbusername);
            dbParams.setDbpassword(dbpassword);
            dbParams.setDbtype(rdb_type);
            dbParams.setRdbClientCharset(rdbClientCharset);
            Map<Object, Object> usersMap = new HashMap();
            try {
                usersMap = isTable == 1 ? this.getTableByUser(robotid, dbParams) : this.getViewByUser(robotid, dbParams);
                String log = (String)((List)usersMap.get("log")).get(0);
                result.add(log);
                usersMap.remove("log");
                Set<Object> userSet = usersMap.keySet();
                result.addAll(userSet);
            }
            catch (Exception e) {
                result = new ArrayList();
                this.log.error((Object)("dwrUtil\u83b7\u53d6\u6570\u636e\u5e93schama\u5931\u8d25\uff1a" + e));
            }
        }
        return result;
    }

    public List<String> dwr_getView(String robotid, String rdbClientCharset, String dbservername, String dbusername, String dbpassword, int rdb_type, String dbdatabase, String user) {
        List<String> result = new ArrayList<String>();
        if (this.setRobotConfig(robotid)) {
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(dbservername);
            dbParams.setDbuser(dbusername);
            dbParams.setDbpassword(dbpassword);
            dbParams.setDbtype(rdb_type);
            dbParams.setDbdatabase(dbdatabase);
            dbParams.setRdbClientCharset(rdbClientCharset);
            try {
                if ("-1".equals(user)) {
                    result = this.configLogic.getView(dbParams);
                    String log = this.getConfigLogic().getSystemLog();
                    if (result != null) {
                        result.add(log);
                    }
                } else {
                    Map<Object, Object> views = new HashMap();
                    views = this.getViewByUser(robotid, dbParams);
                    result = (List)views.get(user);
                    String log = this.getConfigLogic().getSystemLog();
                    if (result != null) {
                        result.add(log);
                    }
                }
            }
            catch (Exception e) {
                result = new ArrayList();
                this.log.error((Object)("dwrUtil\u6570\u636e\u5e93\u4e2d\u89c6\u56fe\u5217\u8868\u5931\u8d25\uff1a" + e));
            }
        }
        return result;
    }

    public List<String> dwr_getViewTable(String robotid, String rdbClientCharset, String dbservername, String dbusername, String dbpassword, int rdb_type, String dbdatabase, String view) {
        List<String> dbviews = new ArrayList<String>();
        if (this.setRobotConfig(robotid)) {
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(dbservername);
            dbParams.setDbuser(dbusername);
            dbParams.setDbpassword(dbpassword);
            dbParams.setDbtype(rdb_type);
            dbParams.setDbdatabase(dbdatabase);
            dbParams.setView(view);
            dbParams.setRdbClientCharset(rdbClientCharset);
            try {
                dbviews = this.getConfigLogic().getViewTable(dbParams);
                String log = this.getConfigLogic().getSystemLog();
                dbviews.add(log);
            }
            catch (Exception e) {
                dbviews = new ArrayList();
                this.log.error((Object)("dwrUtil\u83b7\u53d6\u6570\u636e\u5e93\u89c6\u56fe\u7684\u57fa\u8868\u7684\u5217\u8868\u5931\u8d25\uff1a" + e));
            }
        }
        return dbviews;
    }

    public List<String> dwr_getTable(String robotid, String rdbClientCharset, String dbservername, String dbusername, String dbpassword, int rdb_type, String dbdatabase, String user) {
        List<String> result = new ArrayList<String>();
        if (this.setRobotConfig(robotid)) {
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(dbservername);
            dbParams.setDbuser(dbusername);
            dbParams.setDbpassword(dbpassword);
            dbParams.setDbtype(rdb_type);
            dbParams.setDbdatabase(dbdatabase);
            dbParams.setRdbClientCharset(rdbClientCharset);
            try {
                if ("-1".equals(user)) {
                    result = this.configLogic.getTable(dbParams);
                    String log = this.getConfigLogic().getSystemLog();
                    if (result != null) {
                        result.add(log);
                    }
                } else {
                    Map<Object, Object> table = new HashMap();
                    table = this.getTableByUser(robotid, dbParams);
                    result = (List)table.get(user);
                    String log = this.getConfigLogic().getSystemLog();
                    if (result != null) {
                        result.add(log);
                    }
                }
            }
            catch (Exception e) {
                result = new ArrayList();
                this.log.error((Object)("dwrUtil\u83b7\u53d6\u6570\u636e\u5e93\u8868\u540d\u5217\u8868\u5931\u8d25\uff1a" + e));
            }
        }
        return result;
    }

    public List<String> dwr_getTrsTable(String robotid, String dbservername, String trs_port, String dbusername, String dbpassword) {
        List<String> dbtables = new ArrayList<String>();
        if (this.setRobotConfig(robotid)) {
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(dbservername);
            dbParams.setDbport(Integer.parseInt(trs_port));
            dbParams.setDbuser(dbusername);
            dbParams.setDbpassword(dbpassword);
            dbParams.setDbtype(0);
            try {
                dbtables = this.getConfigLogic().getTable(dbParams);
                String log = this.getConfigLogic().getSystemLog();
                dbtables.add(log);
            }
            catch (Exception e) {
                dbtables = new ArrayList();
                this.log.error((Object)("dwrUtil\u83b7\u53d6TRS Server\u6570\u636e\u5e93\u8868\u5931\u8d25\uff1a" + e));
            }
        }
        return dbtables;
    }

    public List<String> dwr_getTrsView(String robotid, String dbservername, String trs_port, String dbusername, String dbpassword) {
        List<String> dbviews = new ArrayList<String>();
        if (this.setRobotConfig(robotid)) {
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(dbservername);
            dbParams.setDbuser(dbusername);
            dbParams.setDbport(Integer.parseInt(trs_port));
            dbParams.setDbpassword(dbpassword);
            dbParams.setDbtype(0);
            try {
                dbviews = this.getConfigLogic().getView(dbParams);
                String log = this.getConfigLogic().getSystemLog();
                dbviews.add(log);
            }
            catch (Exception e) {
                dbviews = new ArrayList();
                this.log.error((Object)("dwrUtil\u83b7\u53d6TRS Server\u6570\u636e\u5e93\u89c6\u56fe\u96c6\u5408\u5931\u8d25\uff1a" + e));
            }
        }
        return dbviews;
    }

    public List<String> dwr_getDatabase(String robotid, String dbservername, String trs_port, String dbusername, String dbpassword) {
        List<String> dbviews = new ArrayList<String>();
        if (this.setRobotConfig(robotid)) {
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(dbservername);
            dbParams.setDbuser(dbusername);
            dbParams.setDbport(Integer.parseInt(trs_port));
            dbParams.setDbpassword(dbpassword);
            dbParams.setDbtype(0);
            try {
                dbviews = this.getConfigLogic().getDatabase(dbParams);
                String log = this.getConfigLogic().getSystemLog();
                dbviews.add(log);
            }
            catch (Exception e) {
                dbviews = new ArrayList();
                this.log.error((Object)("dwrUtil\u83b7\u53d6TRS Server\u6570\u636e\u5e93\u89c6\u56fe+\u8868\u7684\u96c6\u5408\u5931\u8d25\uff1a" + e));
            }
        }
        return dbviews;
    }

    public List<String> dwr_getVirtualView(String robotid, String dbservername, String trs_port, String dbusername, String dbpassword) {
        List<String> dbviews = new ArrayList<String>();
        if (this.setRobotConfig(robotid)) {
            DbParams dbParams = new DbParams();
            dbParams.setDbserver(dbservername);
            dbParams.setDbuser(dbusername);
            dbParams.setDbport(Integer.parseInt(trs_port));
            dbParams.setDbpassword(dbpassword);
            dbParams.setDbtype(0);
            try {
                dbviews = this.getConfigLogic().getVirtualView(dbParams);
                String log = this.getConfigLogic().getSystemLog();
                dbviews.add(log);
            }
            catch (Exception e) {
                dbviews = new ArrayList();
                this.log.error((Object)("dwrUtil\u83b7\u53d6TRS Server\u96c6\u7fa4\u7684\u865a\u62df\u89c6\u56fe\u7684\u96c6\u5408\u5931\u8d25\uff1a" + e));
            }
        }
        return dbviews;
    }

    public String dwr_loginFtp(String robotid, String servername, String ftp_port, String ftp_user, String ftp_password, int os_type) {
        String info = "";
        if (this.setRobotConfig(robotid)) {
            FtpConfig ftp = new FtpConfig();
            ftp.setFtp_server(servername);
            ftp.setFtp_port(Integer.parseInt(ftp_port));
            ftp.setFtp_user(ftp_user);
            ftp.setFtp_password(ftp_password);
            try {
                boolean islogin = this.getConfigLogic().loginFtp(ftp);
                if (islogin) {
                    info = "\u767b\u5f55ftp\u670d\u52a1\u5668\u6210\u529f\uff01";
                }
            }
            catch (Exception e) {
                info = e.getLocalizedMessage();
                this.log.error((Object)("\u767b\u5f55ftp\u670d\u52a1\u5668\u5931\u8d25\uff1a" + e));
            }
        }
        return info;
    }

    public List<LogData> dwr_getNowLog(String robotid, String task_name, int dbtype, int trspolicy) {
        if (this.setRobotConfig(robotid)) {
            try {
                List<LogData> allLogs = this.getConfigLogic().getLogNow();
                if (task_name != null && !task_name.equals("")) {
                    Iterator<LogData> iter = allLogs.iterator();
                    while (iter.hasNext()) {
                        LogData data = iter.next();
                        if (data.getTask_name().equals(task_name)) continue;
                        iter.remove();
                        allLogs.remove(data);
                    }
                }
                if (dbtype != -1) {
                    ArrayList<LogData> result = new ArrayList<LogData>();
                    List<MissionForm> missionList = this.dwr_getMissionList(robotid, dbtype, trspolicy);
                    for (LogData data : allLogs) {
                        for (MissionForm form : missionList) {
                            if (!data.getTask_name().equals(form.getTask_name()) && !data.getTask_name().equals("")) continue;
                            result.add(data);
                        }
                    }
                    return result;
                }
                if (allLogs != null) {
                    return allLogs;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("dwrUtil\u83b7\u53d6\u5b9e\u65f6\u65e5\u5fd7\u5931\u8d25\uff1a" + e));
            }
        }
        return new ArrayList<LogData>();
    }

    public Map<String, List> getTableByUser(String robotid, DbParams dbParams) {
        HashMap<String, List<Object>> userTable = new HashMap<String, List>();
        if (this.setRobotConfig(robotid)) {
            try {
                List<String> table = this.configLogic.getTable(dbParams);
                ArrayList<String> log = new ArrayList<String>();
                log.add(this.configLogic.getSystemLog());
                userTable.put("log", log);
                for (String tab : table) {
                    List<String> list;
                    String[] user_table = tab.split("\\.");
                    if (user_table.length != 2) continue;
                    if (userTable.containsKey(user_table[0])) {
                        list = (List)userTable.get(user_table[0]);
                        list.add(tab);
                        continue;
                    }
                    list = new ArrayList<String>();
                    list.add(tab);
                    userTable.put(user_table[0], list);
                }
            }
            catch (Exception e) {
                userTable = new HashMap();
                this.log.error((Object)("dwrUtil\u83b7\u53d6\u8868\u540dMap\u5931\u8d25\uff1a" + e));
            }
        }
        return userTable;
    }

    public Map<String, List> getViewByUser(String robotid, DbParams dbParams) {
        HashMap<String, List<Object>> userView = new HashMap<String, List>();
        if (this.setRobotConfig(robotid)) {
            try {
                List<String> view = this.configLogic.getView(dbParams);
                ArrayList<String> log = new ArrayList<String>();
                log.add(this.configLogic.getSystemLog());
                userView.put("log", log);
                for (String tab : view) {
                    List<String> list;
                    String[] user_table = tab.split("\\.");
                    if (user_table.length != 2) continue;
                    if (userView.containsKey(user_table[0])) {
                        list = (List)userView.get(user_table[0]);
                        list.add(tab);
                        continue;
                    }
                    list = new ArrayList<String>();
                    list.add(tab);
                    userView.put(user_table[0], list);
                }
            }
            catch (Exception e) {
                userView = new HashMap();
                this.log.error((Object)("dwrUtil\u83b7\u53d6\u89c6\u56fe\u540d\u79f0\u7684Map\u5931\u8d25\uff1a" + e));
            }
        }
        return userView;
    }

    public Date dwr_getServerTime(String robotid) {
        Date serverDate = new Date();
        if (this.setRobotConfig(robotid)) {
            try {
                serverDate = this.configLogic.getServerTime();
                return serverDate;
            }
            catch (Exception e) {
                serverDate = new Date();
                this.log.error((Object)("dwrUtil\u83b7\u53d6\u670d\u52a1\u5668\u65f6\u95f4\u5931\u8d25\uff1a" + e));
            }
        }
        return serverDate;
    }

    public String dwr_loadExt(String robotid) {
        String boolAndLog = "";
        if (this.setRobotConfig(robotid)) {
            try {
                String log;
                boolAndLog = log = this.configLogic.loadExt();
            }
            catch (Exception e) {
                boolAndLog = e.getLocalizedMessage();
                this.log.error((Object)("dwrUtil\u52a0\u8f7d\u670d\u52a1\u5668\u7ec4\u4ef6\u5931\u8d25\uff1a" + e));
            }
        }
        return boolAndLog;
    }

    public String dwr_getServerMac(String robothost, int robotport) {
        RobotConfig rc = new RobotConfig();
        rc.setRobothost(robothost);
        rc.setRobotport(robotport);
        rc.setCharset("GBK");
        rc.setRobotvalue(4000);
        rc.setLinkTimeout(3);
        rc.setReadWriteTimeout(10);
        try {
            this.getConfigLogic().setRobotConfig(rc);
            String machineCode = this.configLogic.getMachineCode();
            return machineCode;
        }
        catch (Exception e) {
            this.log.error((Object)("dwrUtil\u6dfb\u52a0\u6269\u5c55\u670d\u52a1\u5668\u5931\u8d25\uff1a" + e));
            return "";
        }
    }

    public String dwr_checkRegex(String robotid, String regextest, String regex) {
        String info = "";
        if (this.setRobotConfig(robotid)) {
            try {
                boolean isPassCheck = this.getConfigLogic().checkRegex(regextest, regex);
                if (isPassCheck) {
                    info = "\u9a8c\u8bc1\u6b63\u5219\u8868\u8fbe\u5f0f\u6210\u529f\uff01";
                }
            }
            catch (Exception e) {
                info = e.getLocalizedMessage();
                this.log.error((Object)("dwrUtil\u9a8c\u8bc1\u6b63\u5219\u8868\u8fbe\u5f0f\u5931\u8d25\uff1a" + e));
            }
        }
        return info;
    }

    public String dwr_createFolder(String robotid, String directiory) {
        String infoString = "";
        if (this.setRobotConfig(robotid)) {
            try {
                boolean isCreate = this.configLogic.createFolder(directiory);
                if (isCreate) {
                    infoString = "\u521b\u5efa\u6587\u4ef6\u5939\u6210\u529f!";
                }
            }
            catch (Exception e) {
                infoString = e.getLocalizedMessage();
                this.log.error((Object)("dwrUtil\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + e));
            }
        }
        return infoString;
    }

    public boolean dwr_checkBkserver(String robotid, String dbservername, String trs_port, String dbusername, String dbpassword, String dbdatabase) {
        if (this.setRobotConfig(robotid)) {
            boolean bean;
            DbParams dbtype = new DbParams();
            dbtype.setDbtype(0);
            dbtype.setDbserver(dbservername);
            int trsport = 8888;
            if (trs_port != null) {
                try {
                    trsport = Integer.parseInt(trs_port);
                }
                catch (NumberFormatException e) {
                    trsport = 8888;
                    this.log.error((Object)e.getMessage());
                }
            }
            dbtype.setDbport(trsport);
            dbtype.setDbuser(dbusername);
            dbtype.setDbpassword(dbpassword);
            dbtype.setDbdatabase(dbdatabase);
            try {
                bean = this.configLogic.checkBkserver(dbtype);
            }
            catch (ExceptionUtil e) {
                bean = false;
                this.log.error((Object)e.getMessage());
            }
            return bean;
        }
        return false;
    }

    private boolean setRobotConfig(String robotid) {
        if (robotid != null && !robotid.equals("")) {
            RobotConfig rc = TrsagentServerExtend.getRobotConfig(robotid);
            if (rc != null) {
                this.getConfigLogic().setRobotConfig(rc);
                return true;
            }
            return false;
        }
        return false;
    }

    public IConfigLogic getConfigLogic() {
        return this.configLogic;
    }

    public void setConfigLogic(IConfigLogic configLogic) {
        this.configLogic = configLogic;
    }
}

