/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.helper;

import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.bean.CkmData;
import com.trs.cis4.gateway.bean.FieldData;
import com.trs.cis4.gateway.bean.FieldData2;
import com.trs.cis4.gateway.bean.FtpConfig;
import com.trs.cis4.gateway.bean.MachineData;
import com.trs.cis4.gateway.bean.RdbConfig;
import com.trs.cis4.gateway.bean.RunConfig;
import com.trs.cis4.gateway.bean.TrsConfig;
import com.trs.cis4.gateway.helper.HelperUtils;
import com.trs.cis4.util.DateTimeUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHelper {
    private static final String ROOT_FLAG = "INFO";
    private static final String REC_FLAG = "REC";
    private static final String ENCODING = "GB18030";

    public static String objectsToString(List<AgentConfig> agentConfigs) {
        try {
            Element catainfo = ConfigHelper.saveBeanElement(agentConfigs);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(ENCODING);
            Document doc = catainfo.getDocument();
            StringWriter sw = new StringWriter();
            XMLWriter xw = new XMLWriter((Writer)sw, format);
            try {
                try {
                    xw.write(doc);
                    xw.flush();
                }
                catch (IOException e) {
                    throw new IOException("\u683c\u5f0f\u5316XML\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!", e);
                }
            }
            finally {
                if (xw != null) {
                    xw.close();
                }
            }
            String content = sw.toString();
            return content;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void getElement(Element node, Object object) {
        Field[] fields = object.getClass().getDeclaredFields();
        int k = 0;
        while (k < fields.length) {
            String name = fields[k].getName();
            String value = ConfigHelper.getValue(name, object);
            if (value != null) {
                node.addElement(name).setText(value);
            }
            ++k;
        }
    }

    private static Element saveBeanElement(List<AgentConfig> agentConfigs) {
        Document doc = DocumentHelper.createDocument();
        Element info = doc.addElement(ROOT_FLAG);
        int i = 0;
        while (i < agentConfigs.size()) {
            Element field_len;
            Element field_type2;
            Element field_name2;
            Element field;
            FieldData fieldData;
            int a;
            AgentConfig agentConfig = agentConfigs.get(i);
            Element node = info.addElement(REC_FLAG);
            ConfigHelper.getElement(node, agentConfig);
            if (agentConfig.getRdbConfig() != null) {
                ConfigHelper.getElement(node, agentConfig.getRdbConfig());
            }
            if (agentConfig.getMachine_list() != null) {
                Element machine_list = node.addElement("machine_list");
                a = 0;
                while (a < agentConfig.getMachine_list().size()) {
                    MachineData machineData = agentConfig.getMachine_list().get(a);
                    Element machine = machine_list.addElement("machine");
                    ConfigHelper.getElement(machine, machineData);
                    ++a;
                }
            }
            if (agentConfig.getExt_func_list() != null) {
                Element ext_func_list = node.addElement("ext_func_list");
                a = 0;
                while (a < agentConfig.getExt_func_list().size()) {
                    CkmData ckmData = agentConfig.getExt_func_list().get(a);
                    Element ckm = ext_func_list.addElement("ext_func_field");
                    ConfigHelper.getElement(ckm, ckmData);
                    ++a;
                }
            }
            if (agentConfig.getTrsConfig() != null) {
                ConfigHelper.getElement(node, agentConfig.getTrsConfig());
            }
            if (agentConfig.getFtpConfig() != null) {
                ConfigHelper.getElement(node, agentConfig.getFtpConfig());
            }
            if (agentConfig.getRunConfig() != null) {
                ConfigHelper.getElement(node, agentConfig.getRunConfig());
            }
            if (agentConfig.getField_list() != null) {
                Element field_list = node.addElement("field_list");
                a = 0;
                while (a < agentConfig.getField_list().size()) {
                    fieldData = agentConfig.getField_list().get(a);
                    field = field_list.addElement("field");
                    ConfigHelper.getElement(field, fieldData);
                    field_name2 = field.addElement("field_name2");
                    field_name2.setText(fieldData.getFieldData2().getField_name2());
                    field_type2 = field.addElement("field_type2");
                    field_type2.setText(new Integer(fieldData.getFieldData2().getField_type2()).toString());
                    field_len = field.addElement("field_len");
                    field_len.setText(new Integer(fieldData.getFieldData2().getField_len()).toString());
                    ++a;
                }
            }
            if (agentConfig.getExt_list() != null) {
                Element ext_list = node.addElement("ext_list");
                a = 0;
                while (a < agentConfig.getExt_list().size()) {
                    fieldData = agentConfig.getExt_list().get(a);
                    field = ext_list.addElement("field");
                    ConfigHelper.getElement(field, fieldData);
                    field_name2 = field.addElement("field_name2");
                    field_name2.setText(fieldData.getFieldData2().getField_name2());
                    field_type2 = field.addElement("field_type2");
                    field_type2.setText(new Integer(fieldData.getFieldData2().getField_type2()).toString());
                    field_len = field.addElement("field_len");
                    field_len.setText(new Integer(fieldData.getFieldData2().getField_len()).toString());
                    ++a;
                }
            }
            if (agentConfig.getNode_list() != null) {
                Element node_list = node.addElement("node_list");
                int k = 0;
                while (k < agentConfig.getNode_list().size()) {
                    String value = agentConfig.getNode_list().get(k);
                    Element regex = node_list.addElement("regex");
                    regex.setText(value);
                    ++k;
                }
            }
            ++i;
        }
        return info;
    }

    public static List<AgentConfig> stringToObjects(String string) {
        try {
            Document document = DocumentHelper.parseText((String)string);
            document.setXMLEncoding(ENCODING);
            List<AgentConfig> catalogs = ConfigHelper.getAllObjects(document);
            return catalogs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<AgentConfig> getAllObjects(Document document) {
        ArrayList<AgentConfig> list = new ArrayList<AgentConfig>();
        Element element = document.getRootElement();
        List level1 = element.elements();
        int j = 0;
        while (j < level1.size()) {
            Element level2 = (Element)level1.get(j);
            AgentConfig agentConfig = ConfigHelper.getBeanFormElement(level2);
            agentConfig.setId(agentConfig.getTask_name());
            list.add(agentConfig);
            ++j;
        }
        return list;
    }

    private static AgentConfig getBeanFormElement(Element _element) {
        AgentConfig agentConfig = new AgentConfig();
        ArrayList<MachineData> machine_list = new ArrayList<MachineData>();
        ArrayList<CkmData> ext_func_list = new ArrayList<CkmData>();
        ArrayList<FieldData> field_list = new ArrayList<FieldData>();
        ArrayList<FieldData> ext_list = new ArrayList<FieldData>();
        ArrayList<String> node_list = new ArrayList<String>();
        RdbConfig rdbConfig = new RdbConfig();
        TrsConfig trsConfig = new TrsConfig();
        FtpConfig ftpConfig = new FtpConfig();
        RunConfig runConfig = new RunConfig();
        List recChild = _element.elements();
        int j = 0;
        while (j < recChild.size()) {
            Element level2 = (Element)recChild.get(j);
            List level2Child = level2.elements();
            if (level2Child.size() == 0) {
                String fieldName = level2.getName();
                String value = level2.getText();
                if (ConfigHelper.ifCurrenrConfig(fieldName, AgentConfig.class)) {
                    ConfigHelper.setObjectValue(agentConfig, fieldName, value);
                } else if (ConfigHelper.ifCurrenrConfig(fieldName, RdbConfig.class)) {
                    ConfigHelper.setObjectValue(rdbConfig, fieldName, value);
                } else if (ConfigHelper.ifCurrenrConfig(fieldName, TrsConfig.class)) {
                    ConfigHelper.setObjectValue(trsConfig, fieldName, value);
                } else if (ConfigHelper.ifCurrenrConfig(fieldName, FtpConfig.class)) {
                    ConfigHelper.setObjectValue(ftpConfig, fieldName, value);
                } else if (ConfigHelper.ifCurrenrConfig(fieldName, RunConfig.class)) {
                    ConfigHelper.setObjectValue(runConfig, fieldName, value);
                } else {
                    System.out.println("\u5b57\u6bb5\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u8be5\u5b57\u6bb5\u503c\uff01" + fieldName);
                }
            } else {
                int k = 0;
                while (k < level2Child.size()) {
                    Element level3Element = (Element)level2Child.get(k);
                    List level3Child = level3Element.elements();
                    if (level3Child.size() > 0) {
                        Element element;
                        int m;
                        String level2Name = level2.getName();
                        if (level2Name.equals("machine_list")) {
                            MachineData machineData = new MachineData();
                            m = 0;
                            while (m < level3Child.size()) {
                                element = (Element)level3Child.get(m);
                                ConfigHelper.setObjectValue(machineData, element.getName(), element.getText());
                                ++m;
                            }
                            machine_list.add(machineData);
                        }
                        if (level2Name.equals("ext_func_list")) {
                            CkmData ckmData = new CkmData();
                            m = 0;
                            while (m < level3Child.size()) {
                                element = (Element)level3Child.get(m);
                                ConfigHelper.setObjectValue(ckmData, element.getName(), element.getText());
                                ++m;
                            }
                            ext_func_list.add(ckmData);
                        }
                        if (level2Name.equals("field_list")) {
                            field_list.add(ConfigHelper.getFieldData(level3Child));
                        }
                        if (level2Name.equals("ext_list")) {
                            ext_list.add(ConfigHelper.getFieldData(level3Child));
                        }
                    } else {
                        node_list.add(level3Element.getText());
                    }
                    ++k;
                }
            }
            ++j;
        }
        agentConfig.setMachine_list(machine_list);
        agentConfig.setExt_func_list(ext_func_list);
        agentConfig.setField_list(field_list);
        agentConfig.setExt_list(ext_list);
        agentConfig.setNode_list(node_list);
        agentConfig.setRdbConfig(rdbConfig);
        agentConfig.setTrsConfig(trsConfig);
        agentConfig.setFtpConfig(ftpConfig);
        agentConfig.setRunConfig(runConfig);
        return agentConfig;
    }

    private static FieldData getFieldData(List<Element> level3Child) {
        FieldData fieldData = new FieldData();
        FieldData2 fieldData2 = new FieldData2();
        int m = 0;
        while (m < level3Child.size()) {
            Element element = level3Child.get(m);
            String name = element.getName();
            String value = element.getText();
            if (name.equals("field_name2") || name.equals("field_type2")) {
                ConfigHelper.setObjectValue(fieldData2, name, value);
                fieldData.setFieldData2(fieldData2);
            } else {
                ConfigHelper.setObjectValue(fieldData, name, value);
            }
            ++m;
        }
        return fieldData;
    }

    private static boolean ifCurrenrConfig(String name, Class clsName) {
        Field[] fields = AgentConfig.class.getDeclaredFields();
        int k = 0;
        while (k < fields.length) {
            String nameString = fields[k].getName();
            if (nameString.equals(name)) {
                if (clsName.getName().indexOf("AgentConfig") >= 0) {
                    return true;
                }
            } else {
                Class<?> cls = fields[k].getType();
                Field[] clsfields = cls.getDeclaredFields();
                int m = 0;
                while (m < clsfields.length) {
                    String fieldName = clsfields[m].getName();
                    if (fieldName.equals(name)) {
                        if (cls.getName().equals(RdbConfig.class.getName()) && clsName.getName().indexOf("RdbConfig") >= 0) {
                            return true;
                        }
                        if (cls.getName().equals(TrsConfig.class.getName()) && clsName.getName().indexOf("TrsConfig") >= 0) {
                            return true;
                        }
                        if (cls.getName().equals(FtpConfig.class.getName()) && clsName.getName().indexOf("FtpConfig") >= 0) {
                            return true;
                        }
                        if (!cls.getName().equals(RunConfig.class.getName()) || clsName.getName().indexOf("RunConfig") < 0) break;
                        return true;
                    }
                    ++m;
                }
            }
            ++k;
        }
        return false;
    }

    public static void setObjectValue(Object bean, String _field, String _value) {
        Field[] fields = bean.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            String tempField = fields[i].getName();
            if (_field.equals(tempField)) {
                Class<Object> clsType = null;
                Object value = null;
                try {
                    String fil = fields[i].getType().getName();
                    if (fil.indexOf("String") >= 0) {
                        clsType = Class.forName("java.lang.String");
                        value = _value;
                    } else if (fil.equals("int")) {
                        clsType = Integer.TYPE;
                        if (_value == null || _value.equals("")) {
                            _value = "0";
                        }
                        value = new Integer(_value);
                    } else if (fil.equals("long")) {
                        clsType = Long.TYPE;
                        if (_value == null || _value.equals("")) {
                            _value = "0";
                        }
                        value = new Long(_value);
                    } else {
                        if (!fil.equals("boolean")) break;
                        clsType = Boolean.TYPE;
                        if (_value == null || _value.equals("")) {
                            _value = "0";
                        }
                        value = _value.equals("1") ? new Boolean(true) : new Boolean(false);
                    }
                    String methodName = "set" + tempField.substring(0, 1).toUpperCase() + tempField.substring(1);
                    ConfigHelper.setValue(bean, methodName, clsType, value);
                    if (bean != null) break;
                }
                catch (Exception ex) {
                    System.out.println("setObjectValue " + ex);
                }
                break;
            }
            ++i;
        }
    }

    public static void setValue(Object object, String methodName, Class clsType, Object value) {
        try {
            Method method = object.getClass().getMethod(methodName, clsType);
            method.invoke(object, value);
        }
        catch (Exception ex1) {
            System.out.println("method " + ex1);
        }
    }

    public static String getValue(String name, Object object) {
        Method method;
        String ret;
        block25: {
            if (name.equals("id") || name.indexOf("Config") >= 0 || name.indexOf("fieldData2") >= 0 || name.indexOf("list") >= 0 || name.indexOf("trs_view") >= 0) {
                return null;
            }
            ret = "";
            try {
                String prop = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
                Class[] types = new Class[]{};
                method = null;
                try {
                    method = object.getClass().getMethod("get" + prop, types);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (method != null) break block25;
                try {
                    method = object.getClass().getMethod("is" + prop, types);
                }
                catch (Exception e) {
                    System.out.println("getValue1 " + e);
                    return null;
                }
            }
            catch (Exception e) {
                System.out.println("getValue2 " + e);
                return null;
            }
        }
        Object result = method.invoke(object, new Object[0]);
        if (method.getReturnType().getName().indexOf("String") >= 0) {
            ret = (String)result;
        } else if (method.getReturnType().getName().indexOf("Integer") >= 0) {
            ret = ((Integer)result).toString();
        } else if (method.getReturnType().getName().indexOf("int") >= 0) {
            ret = ((Integer)result).toString();
        } else if (method.getReturnType().getName().indexOf("long") >= 0) {
            ret = ((Long)result).toString();
        } else if (method.getReturnType().getName().indexOf("Long") >= 0) {
            ret = ((Long)result).toString();
        } else if (method.getReturnType().getName().indexOf("Boolean") >= 0) {
            ret = new Integer(HelperUtils.convertBooltoNum((Boolean)result)).toString();
        } else if (method.getReturnType().getName().indexOf("boolean") >= 0) {
            ret = new Integer(HelperUtils.convertBooltoNum((Boolean)result)).toString();
        } else if (method.getReturnType().getName().indexOf("Date") >= 0) {
            Date temp = (Date)result;
            ret = DateTimeUtil.getYMDHMSFromDate((Date)temp);
        } else if (method.getReturnType().getName().indexOf("date") >= 0) {
            Date temp = (Date)result;
            ret = DateTimeUtil.getYMDHMSFromDate((Date)temp);
        }
        return ret;
    }
}

