/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.dao.impl;

import com.trs.cis4.gateway.bean.DbParams;
import com.trs.cis4.gateway.bean.FieldData2;
import com.trs.cis4.gateway.bean.FtpConfig;
import com.trs.cis4.gateway.bean.LogConfig;
import com.trs.cis4.gateway.dao.IBaseRobotDAO;
import com.trs.cis4.socket.IRobotSocket;
import com.trs.cis4.socket.config.RobotBean;
import com.trs.cis4.socket.config.RobotConfig;
import com.trs.cis4.socket.impl.HandlerProxy;
import com.trs.cis4.util.ExceptionUtil;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseRobotDAOProxy
implements IBaseRobotDAO {
    protected RobotConfig robotConfig;
    private IRobotSocket robotSocket = new HandlerProxy().getHandlerImpl();

    @Override
    public void setRobotConfig(RobotConfig robotConfig) {
        this.robotSocket.setRobotConfig(robotConfig);
    }

    @Override
    public RobotBean getRobotParams() {
        return this.robotSocket.getRobotParams();
    }

    @Override
    public String downloadConfig() throws ExceptionUtil {
        this.robotSocket.setCommand(103);
        return this.robotSocket.getStream();
    }

    @Override
    public String[] getRegisteredRdb() throws ExceptionUtil {
        this.robotSocket.setCommand(101);
        return this.robotSocket.getStrings();
    }

    @Override
    public String[] getLoadedRdb() throws ExceptionUtil {
        this.robotSocket.setCommand(102);
        return this.robotSocket.getStrings();
    }

    @Override
    public String[] getTaskStatus() throws ExceptionUtil {
        this.robotSocket.setCommand(104);
        return this.robotSocket.getStrings();
    }

    @Override
    public String getWorkPath() throws ExceptionUtil {
        this.robotSocket.setCommand(105);
        return this.robotSocket.getString();
    }

    @Override
    public String[] getLogConfig() throws ExceptionUtil {
        this.robotSocket.setCommand(106);
        return this.robotSocket.getStrings();
    }

    @Override
    public String loginDb(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(201);
        this._setDbParams(dbParams);
        return this.robotSocket.getString();
    }

    @Override
    public String[] getDatabase(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(202);
        this._setDbParams(dbParams);
        String[] database = this.robotSocket.getStrings();
        if (database.length >= 1) {
            if (dbParams.getDbtype() == 0) {
                if (database[database.length - 1].startsWith("Log\uff1a")) {
                    database = Arrays.copyOfRange(database, 0, database.length - 1);
                }
            } else if (dbParams.getDbtype() > 0 && dbParams.getDbtype() < 8 && database[database.length - 1].startsWith("Log\uff1aSELECT")) {
                database = Arrays.copyOfRange(database, 0, database.length - 1);
            }
        }
        return database;
    }

    @Override
    public String[] getView(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(203);
        this._setDbParams(dbParams);
        this.robotSocket.setString(dbParams.getDbdatabase());
        this.robotSocket.setString(dbParams.getView());
        this.robotSocket.setString(dbParams.getTable());
        String[] view = this.robotSocket.getStrings();
        if (view.length >= 1) {
            if (dbParams.getDbtype() == 0) {
                if (view[view.length - 1].startsWith("Log\uff1a")) {
                    view = Arrays.copyOfRange(view, 0, view.length - 1);
                }
            } else if (dbParams.getDbtype() > 0 && dbParams.getDbtype() < 8 && view[view.length - 1].startsWith("Log\uff1aSELECT")) {
                view = Arrays.copyOfRange(view, 0, view.length - 1);
            }
        }
        return view;
    }

    @Override
    public String[] getTable(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(204);
        this._setDbParams(dbParams);
        this.robotSocket.setString(dbParams.getDbdatabase());
        this.robotSocket.setString(dbParams.getView());
        this.robotSocket.setString(dbParams.getTable());
        String[] table = this.robotSocket.getStrings();
        if (table.length >= 1) {
            if (dbParams.getDbtype() == 0) {
                if (table[table.length - 1].startsWith("Log\uff1a")) {
                    table = Arrays.copyOfRange(table, 0, table.length - 1);
                }
            } else if (dbParams.getDbtype() > 0 && dbParams.getDbtype() < 8 && table[table.length - 1].startsWith("Log\uff1aSELECT")) {
                table = Arrays.copyOfRange(table, 0, table.length - 1);
            }
        }
        return table;
    }

    @Override
    public String[] getViewTable(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(205);
        this._setDbParams(dbParams);
        this.robotSocket.setString(dbParams.getDbdatabase());
        this.robotSocket.setString(dbParams.getView());
        this.robotSocket.setString(dbParams.getTable());
        String[] vtable = this.robotSocket.getStrings();
        if (vtable.length >= 1 && vtable[vtable.length - 1].startsWith("Log\uff1aSELECT")) {
            vtable = Arrays.copyOfRange(vtable, 0, vtable.length - 1);
        }
        return vtable;
    }

    @Override
    public String[] getTableColumn(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(206);
        this._setDbParams(dbParams);
        this.robotSocket.setString(dbParams.getDbdatabase());
        this.robotSocket.setString(dbParams.getView());
        this.robotSocket.setString(dbParams.getTable());
        return this.robotSocket.getStrings();
    }

    @Override
    public String[] getViewColumn(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(207);
        this._setDbParams(dbParams);
        this.robotSocket.setString(dbParams.getDbdatabase());
        this.robotSocket.setString(dbParams.getView());
        this.robotSocket.setString(dbParams.getTable());
        return this.robotSocket.getStrings();
    }

    @Override
    public String[] getTrsUser(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(208);
        this._setDbParams(dbParams);
        return this.robotSocket.getStrings();
    }

    @Override
    public String createTrsDatabase(DbParams dbParams, List<FieldData2> fList) throws ExceptionUtil {
        this.robotSocket.setCommand(209);
        this._setDbParams(dbParams);
        this.robotSocket.setString(new Integer(dbParams.getType()).toString());
        this.robotSocket.setString(dbParams.getOwner());
        this.robotSocket.setString(dbParams.getDbdatabase());
        this.robotSocket.setString(dbParams.getLanguage());
        this._setFieldData2(fList);
        return this.robotSocket.getString();
    }

    @Override
    public String[] getVirtualView(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(210);
        this._setDbParams(dbParams);
        String[] virtualView = this.robotSocket.getStrings();
        if (virtualView.length >= 1 && virtualView[virtualView.length - 1].startsWith("Log\uff1a")) {
            virtualView = Arrays.copyOfRange(virtualView, 0, virtualView.length - 1);
        }
        return virtualView;
    }

    @Override
    public String[] getVirtualViewBkserver(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(211);
        this._setDbParams(dbParams);
        this.robotSocket.setString(dbParams.getAddition());
        String[] virtualView = this.robotSocket.getStrings();
        if (virtualView.length >= 1 && virtualView[virtualView.length - 1].startsWith("Log\uff1a")) {
            virtualView = Arrays.copyOfRange(virtualView, 0, virtualView.length - 1);
        }
        return virtualView;
    }

    @Override
    public String[] getLogNow() throws ExceptionUtil {
        this.robotSocket.setCommand(308);
        return this.robotSocket.getStrings();
    }

    @Override
    public int run(String taskName) throws ExceptionUtil {
        this.robotSocket.setCommand(301);
        this.robotSocket.setString(taskName);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int stop(String taskName) throws ExceptionUtil {
        this.robotSocket.setCommand(302);
        this.robotSocket.setString(taskName);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int add(String config) throws ExceptionUtil {
        this.robotSocket.setCommand(303);
        this.robotSocket.setStream(config);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int edit(String oldTaskName, String config) throws ExceptionUtil {
        this.robotSocket.setCommand(304);
        this.robotSocket.setString(oldTaskName);
        this.robotSocket.setStream(config);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int delete(String taskName) throws ExceptionUtil {
        this.robotSocket.setCommand(305);
        this.robotSocket.setString(taskName);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int setWatchConfig(String config) throws ExceptionUtil {
        this.robotSocket.setCommand(306);
        this.robotSocket.setString(config);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int setLogConfig(LogConfig logConfig) throws ExceptionUtil {
        this.robotSocket.setCommand(307);
        this._setLogConfig(logConfig);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int checkRegex(String regexStr, String content) throws ExceptionUtil {
        this.robotSocket.setCommand(401);
        this.robotSocket.setString(regexStr);
        this.robotSocket.setString(content);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int checkBkserver(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setCommand(402);
        this._setDbParams(dbParams);
        this.robotSocket.setString(dbParams.getDbdatabase());
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int loginFtp(FtpConfig ftpConfig) throws ExceptionUtil {
        this.robotSocket.setCommand(403);
        this._setFtpConfig(ftpConfig);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int createFolder(String folder) throws ExceptionUtil {
        this.robotSocket.setCommand(404);
        this.robotSocket.setString(folder);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public int exit() throws ExceptionUtil {
        this.robotSocket.setCommand(501);
        return this.robotSocket.getReturnCode();
    }

    @Override
    public String getServerTime() throws ExceptionUtil {
        this.robotSocket.setCommand(405);
        return this.robotSocket.getString();
    }

    @Override
    public String loadExt() throws ExceptionUtil {
        this.robotSocket.setCommand(502);
        return this.robotSocket.getString();
    }

    @Override
    public String extStat() throws ExceptionUtil {
        this.robotSocket.setCommand(505);
        return this.robotSocket.getString();
    }

    @Override
    public String getMachineCode() throws ExceptionUtil {
        this.robotSocket.setCommand(504);
        return this.robotSocket.getString();
    }

    @Override
    public String getSystemLog() throws ExceptionUtil {
        return null;
    }

    @Override
    public String getReturnLog() throws ExceptionUtil {
        return this.robotSocket.getReturnLog();
    }

    @Override
    public int getReturnCode() throws ExceptionUtil {
        return this.robotSocket.getReturnCode();
    }

    @Override
    public String getServerVersion() throws ExceptionUtil {
        this.robotSocket.setCommand(509);
        return this.robotSocket.getString();
    }

    private void _setDbParams(DbParams dbParams) throws ExceptionUtil {
        this.robotSocket.setString(new Integer(dbParams.getDbtype()).toString());
        this.robotSocket.setString(dbParams.getDbserver());
        this.robotSocket.setString(new Integer(dbParams.getDbport()).toString());
        this.robotSocket.setString(dbParams.getDbuser());
        this.robotSocket.setString(dbParams.getDbpassword());
        this.robotSocket.setString(dbParams.getRdbClientCharset());
    }

    private void _setLogConfig(LogConfig logConfig) throws ExceptionUtil {
        this.robotSocket.setString(new Integer(logConfig.getLog_size()).toString());
        this.robotSocket.setString(new Integer(logConfig.getBak_span()).toString());
        this.robotSocket.setString(new Integer(logConfig.getBak_count()).toString());
        this.robotSocket.setString(new Integer(logConfig.getLog_type()).toString());
        this.robotSocket.setString(new Integer(logConfig.getOutput_type()).toString());
    }

    private void _setFtpConfig(FtpConfig ftpConfig) throws ExceptionUtil {
        this.robotSocket.setString(ftpConfig.getFtp_server());
        this.robotSocket.setString(new Integer(ftpConfig.getFtp_port()).toString());
        this.robotSocket.setString(ftpConfig.getFtp_user());
        this.robotSocket.setString(ftpConfig.getFtp_password());
    }

    private void _setFieldData2(List<FieldData2> fList) {
        this.robotSocket.setString(new Integer(fList.size()).toString());
        int i = 0;
        while (i < fList.size()) {
            FieldData2 fieldData2 = fList.get(i);
            this.robotSocket.setString(fieldData2.getField_name2());
            this.robotSocket.setString(new Integer(fieldData2.getField_type2()).toString());
            this.robotSocket.setString(new Integer(fieldData2.getField_len()).toString());
            ++i;
        }
    }
}

