/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.session.util;

import com.trs.infra.session.Session;
import com.trs.infra.session.SessionAccessor;
import com.trs.infra.session.SessionContext;
import com.trs.infra.session.util.HttpServletRequestFacade;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class SessionFilterBase
implements Filter {
    private static final Logger s_logger;
    private FilterConfig filterConfig;
    private boolean filterInitialized = false;
    private SessionContext sessionContext = null;
    private SessionAccessor sessionAccessor = null;
    private String[] ignoreURIPrefix = null;
    private String[] ignoreURISurfix = null;
    private boolean httpSessionCompatible = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.session.util.SessionFilterBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.filterInitialized) {
            this.filterInitialize();
        }
        if (this.sessionContext == null) {
            chain.doFilter(request, response);
            return;
        }
        Object req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.isIgnoreHttpRequest((HttpServletRequest)req)) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        SessionContext context = this.sessionContext;
        Session session = context.loadSession((HttpServletRequest)req, res);
        if (session == null) {
            if (this.httpSessionCompatible) {
                req = new HttpServletRequestFacade((HttpServletRequest)req, context, res);
            } else {
                session = context.makeSession((HttpServletRequest)req, res);
                if (session == null) {
                    res.sendError(406);
                    return;
                }
            }
        } else {
            if (session.getLevel() <= -1) {
                res.sendError(403);
                return;
            }
            if (this.httpSessionCompatible) {
                req = new HttpServletRequestFacade((HttpServletRequest)req, context, res, session);
            }
        }
        SessionAccessor accessor = this.sessionAccessor;
        try {
            if (session != null) {
                if (accessor != null) {
                    accessor.setSession(session.getHttpSession());
                }
                session.accessStart();
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        finally {
            if (session != null) {
                if (accessor != null) {
                    accessor.clearSession();
                }
                session.accessEnd();
            }
        }
    }

    private boolean isIgnoreHttpRequest(HttpServletRequest request) {
        String[] sIgnoreSurfix;
        String sServletPath = null;
        String[] sIgnorePrefix = this.ignoreURIPrefix;
        if (sIgnorePrefix != null) {
            sServletPath = request.getServletPath();
            if (sServletPath == null) {
                return false;
            }
            int i = sIgnorePrefix.length - 1;
            while (i >= 0) {
                String prefix = sIgnorePrefix[i];
                if (sServletPath.startsWith(prefix)) {
                    return true;
                }
                --i;
            }
        }
        if ((sIgnoreSurfix = this.ignoreURISurfix) != null) {
            if (sServletPath == null) {
                sServletPath = request.getServletPath();
            }
            if (sServletPath == null) {
                return false;
            }
            int i = sIgnoreSurfix.length - 1;
            while (i >= 0) {
                String surfix = sIgnoreSurfix[i];
                if (sServletPath.endsWith(surfix)) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void filterInitialize() {
        SessionFilterBase sessionFilterBase = this;
        synchronized (sessionFilterBase) {
            if (this.filterInitialized) {
                return;
            }
            this.sessionContext = this.loadSeesionContext(this.filterConfig);
            if (this.sessionContext == null) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)"In filterInitialize(), sessionContext is null");
                }
                this.filterInitialized = true;
                return;
            }
            this.sessionContext.setServletContext(this.filterConfig.getServletContext());
            this.sessionAccessor = this.loadSessionAccessor(this.filterConfig);
            this.ignoreURIPrefix = this.loadIgnoreURIPrefix(this.filterConfig);
            this.ignoreURISurfix = this.loadIgnoreURISurfix(this.filterConfig);
            this.httpSessionCompatible = this.loadHttpSessionCompatible(this.filterConfig);
            this.filterInitialized = true;
        }
        s_logger.info((Object)("In filterInitialize(), sessionContext:" + this.sessionContext));
        s_logger.info((Object)("In filterInitialize(), sessionAccessor:" + this.sessionAccessor));
        if (this.ignoreURIPrefix == null) {
            s_logger.info((Object)"In filterInitialize(), ignoreURIPrefix:null");
        } else {
            s_logger.info((Object)("In filterInitialize(), ignoreURIPrefix" + this.ignoreURIPrefix));
            int i = 0;
            while (i < this.ignoreURIPrefix.length) {
                s_logger.info((Object)("\t[" + i + "]:" + this.ignoreURIPrefix[i]));
                ++i;
            }
        }
        if (this.ignoreURISurfix == null) {
            s_logger.info((Object)"In filterInitialize(), ignoreURIPrefix:null");
        } else {
            s_logger.info((Object)("In filterInitialize(), ignoreURIPrefix:" + this.ignoreURISurfix));
            int i = 0;
            while (i < this.ignoreURISurfix.length) {
                s_logger.info((Object)("\t[" + i + "]:" + this.ignoreURISurfix[i]));
                ++i;
            }
        }
        s_logger.info((Object)("In filterInitialize(), httpSessionCompatible:" + this.httpSessionCompatible));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
        this.filterInitialized = false;
        this.sessionContext = null;
        this.sessionAccessor = null;
        this.ignoreURIPrefix = null;
        this.ignoreURISurfix = null;
        this.httpSessionCompatible = false;
    }

    protected abstract SessionContext loadSeesionContext(FilterConfig var1);

    protected abstract SessionAccessor loadSessionAccessor(FilterConfig var1);

    protected abstract String[] loadIgnoreURIPrefix(FilterConfig var1);

    protected abstract String[] loadIgnoreURISurfix(FilterConfig var1);

    protected abstract boolean loadHttpSessionCompatible(FilterConfig var1);
}

