/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.member;

import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.StreamReader;
import com.trs.infra.cluster.StreamType;
import com.trs.infra.cluster.StreamWriter;
import com.trs.infra.cluster.member.MemberTransport;
import com.trs.infra.cluster.util.StringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MemberImpl
implements Member {
    private String _guid;
    private String name;
    private String host;
    private InetAddress tcpAddress;
    private int tcpPort;
    private InetAddress udpAddress;
    private int udpPort;
    private Member.State state;
    private boolean local;
    private boolean master;
    private long startTime;
    private long pulseTime;
    private long maxMemory;
    private long freeMemory;
    private long totalMemory;
    private long timeDifference;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private MemberTransport transport;
    private Map attributes = new HashMap();

    public boolean equals(Object obj) {
        if (obj instanceof MemberImpl) {
            MemberImpl other = (MemberImpl)obj;
            return this._guid().equals(other._guid());
        }
        return false;
    }

    public int hashCode() {
        return this._guid().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("MemberImpl:");
        sb.append("{");
        sb.append("guid:").append(this._guid());
        sb.append(",name:").append(this.getName());
        sb.append(",host:").append(this.getHost());
        sb.append(",tcpAddress:").append(this.getTCPAddress().getHostAddress());
        sb.append(",tcpPort:").append(this.getTCPPort());
        sb.append(",udpAddress:").append(this.getUDPAddress().getHostAddress());
        sb.append(",udpPort:").append(this.getUDPPort());
        sb.append("}");
        return sb.toString();
    }

    public String _guid() {
        if (this._guid == null) {
            String address = StringUtil.bytes2hex(this.tcpAddress.getAddress(), 0, 4);
            String port = StringUtil.short2hex(this.tcpPort);
            this._guid = String.valueOf(address) + port;
        }
        return this._guid;
    }

    public StreamType _type() {
        return null;
    }

    public void _load(StreamReader is) throws IOException {
        this._guid = is.read_string();
        this.name = is.read_string();
        this.host = is.read_string();
        this.tcpPort = is.read_int();
        this.udpPort = is.read_int();
        this.master = is.read_boolean();
        this.startTime = is.read_long();
        this.maxMemory = is.read_long();
        byte[] publicKeyData = is.read_byte_array();
        try {
            InetAddress[] addresses = (InetAddress[])is.read_object();
            this.setTCPAddress(addresses[0]);
            this.setUDPAddress(addresses[1]);
        }
        catch (ClassNotFoundException addresses) {}
        try {
            while (is.read_boolean()) {
                String name = is.read_string();
                Serializable value = (Serializable)is.read_object();
                this.setAttribute(name, value);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _save(StreamWriter os) throws IOException {
        os.write_string(this._guid());
        os.write_string(this.name);
        os.write_string(this.host);
        os.write_int(this.tcpPort);
        os.write_int(this.udpPort);
        os.write_boolean(this.master);
        os.write_long(this.startTime);
        os.write_long(this.maxMemory);
        if (this.publicKey == null) {
            os.write_byte_array(null);
        } else {
            os.write_byte_array(this.publicKey.getEncoded());
        }
        InetAddress[] addresses = new InetAddress[]{this.tcpAddress, this.udpAddress};
        os.write_object((Serializable)addresses);
        Map map = this.attributes;
        synchronized (map) {
            if (!this.attributes.isEmpty()) {
                Iterator entItr = this.attributes.entrySet().iterator();
                while (entItr.hasNext()) {
                    Map.Entry ent = entItr.next();
                    Object value = ent.getValue();
                    if (!(value instanceof Serializable)) continue;
                    os.write_boolean(true);
                    os.write_string((String)ent.getKey());
                    os.write_object((Serializable)value);
                }
            }
        }
        os.write_boolean(false);
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public final void setHost(String host) {
        this.host = host;
    }

    public InetAddress getTCPAddress() {
        return this.tcpAddress;
    }

    public final void setTCPAddress(InetAddress tcpAddress) {
        if (tcpAddress == null) {
            throw new IllegalArgumentException("tcpAddress is null.");
        }
        this.tcpAddress = tcpAddress;
    }

    public int getTCPPort() {
        return this.tcpPort;
    }

    public final void setTCPPort(int tcpPort) {
        this.tcpPort = tcpPort;
    }

    public InetAddress getUDPAddress() {
        return this.udpAddress;
    }

    public final void setUDPAddress(InetAddress udpAddress) {
        if (udpAddress == null) {
            throw new IllegalArgumentException("udpAddress is null.");
        }
        this.udpAddress = udpAddress;
    }

    public int getUDPPort() {
        return this.udpPort;
    }

    public final void setUDPPort(int udpPort) {
        this.udpPort = udpPort;
    }

    public Member.State getState() {
        return this.state;
    }

    final void setState(Member.State state) {
        this.state = state;
    }

    public boolean isValid() {
        return Member.State.NORMAL == this.state;
    }

    public boolean isLocal() {
        return this.local;
    }

    public final void setLocal(boolean local) {
        this.local = local;
    }

    public final boolean isMaster() {
        return this.master;
    }

    public final void setMaster(boolean master) {
        this.master = master;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getPulseTime() {
        return this.pulseTime;
    }

    public final void setPulseTime(long pulseTime) {
        this.pulseTime = pulseTime;
    }

    public final long getMaxMemory() {
        return this.maxMemory;
    }

    public final void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public final long getFreeMemory() {
        if (this.freeMemory == Integer.MIN_VALUE) {
            return Runtime.getRuntime().freeMemory();
        }
        return this.freeMemory;
    }

    public final void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public final long getTotalMemory() {
        if (this.totalMemory == Integer.MIN_VALUE) {
            return Runtime.getRuntime().totalMemory();
        }
        return this.totalMemory;
    }

    public final void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public long getTimeDifference() {
        return this.timeDifference;
    }

    public final void setTimeDifference(long timeDifference) {
        this.timeDifference = timeDifference;
    }

    public long currentTimeMillis() {
        return System.currentTimeMillis() + this.timeDifference;
    }

    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public final void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public final synchronized void prepareTransport() {
        if (this.transport == null) {
            this.transport = new MemberTransport();
        }
    }

    public final MemberTransport getTransport() {
        return this.transport;
    }

    public final void setTransport(MemberTransport transport) {
        this.transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Map map = this.attributes;
        synchronized (map) {
            if (value == null) {
                this.attributes.remove(name);
            } else {
                this.attributes.put(name, value);
            }
        }
    }
}

