/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.EncodingUtil;
import java.io.File;
import java.net.URL;
import javax.activation.FileDataSource;
import junit.framework.TestCase;

public class EncodingUtilTest
extends TestCase {
    public void testDetectCharset() throws Exception {
        EncodingUtilTest.assertEquals((String)"GB2312", (String)EncodingUtil.detectCharset(new URL("http://www.sohu.com/")));
        EncodingUtilTest.assertEquals((String)"GB2312", (String)EncodingUtil.detectCharset(new URL("http://www.baidu.com")));
        EncodingUtilTest.assertEquals((String)"UTF-8", (String)EncodingUtil.detectCharset(new URL("http://www.trs.com.cn")));
        FileDataSource fds = new FileDataSource("resource/\u6587\u4ef6\u8bfb\u5199\u6d4b\u8bd5.txt");
        File utf8File = fds.getFile();
        EncodingUtilTest.assertEquals((String)"UTF-8", (String)EncodingUtil.detectCharset(utf8File));
        fds = new FileDataSource("resource/\u97e9\u6587\u5185\u5bb9.txt");
        File krFile = fds.getFile();
        EncodingUtilTest.assertEquals((String)"ISO-2022-KR", (String)EncodingUtil.detectCharset(krFile));
    }
}

