/*
 * Decompiled with CFR 0.152.
 */
package t4j.http;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import t4j.Configuration;
import t4j.TBlogException;
import t4j.http.AccessToken;
import t4j.http.BASE64Encoder;
import t4j.http.OAuth;
import t4j.http.OAuthToken;
import t4j.http.PostParameter;
import t4j.http.RequestToken;
import t4j.http.Response;

public class HttpClient
implements Serializable {
    private static final long serialVersionUID = 808018030183407996L;
    private static final int OK = 200;
    private static final int NOT_MODIFIED = 304;
    private static final int BAD_REQUEST = 400;
    private static final int NOT_AUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int NOT_ACCEPTABLE = 406;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final boolean DEBUG = Configuration.getDebug();
    private String basic = null;
    private int retryCount = Configuration.getRetryCount();
    private int retryIntervalMillis = Configuration.getRetryIntervalSecs() * 1000;
    private String userId = Configuration.getUser();
    private String password = Configuration.getPassword();
    private String proxyHost = Configuration.getProxyHost();
    private int proxyPort = Configuration.getProxyPort();
    private String proxyAuthUser = Configuration.getProxyUser();
    private String proxyAuthPassword = Configuration.getProxyPassword();
    private int connectionTimeout = Configuration.getConnectionTimeout();
    private int readTimeout = Configuration.getReadTimeout();
    private static boolean isJDK14orEarlier = false;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private OAuth oauth = null;
    private String requestTokenURL = String.valueOf(Configuration.getScheme()) + "api.t.163.com/oauth/request_token";
    private String authenticationURL = String.valueOf(Configuration.getScheme()) + "api.t.163.com/oauth/authenticate";
    private String accessTokenURL = String.valueOf(Configuration.getScheme()) + "api.t.163.com/oauth/access_token";
    private OAuthToken oauthToken = null;

    static {
        try {
            String versionStr = System.getProperty("java.specification.version");
            if (versionStr != null) {
                isJDK14orEarlier = 1.5 > Double.parseDouble(versionStr);
            }
        }
        catch (AccessControlException ace) {
            isJDK14orEarlier = true;
        }
    }

    public HttpClient(String userId, String password) {
        this();
        this.setUserId(userId);
        this.setPassword(password);
    }

    public HttpClient() {
        this.setUserAgent(null);
        this.setOAuthConsumer(null, null);
        this.setRequestHeader("Accept-Encoding", "gzip");
    }

    public void setUserId(String userId) {
        this.userId = userId;
        this.encodeBasicAuthenticationString();
    }

    public void setPassword(String password) {
        this.password = password;
        this.encodeBasicAuthenticationString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticationEnabled() {
        return this.basic != null || this.oauth != null;
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        consumerKey = Configuration.getOAuthConsumerKey(consumerKey);
        consumerSecret = Configuration.getOAuthConsumerSecret(consumerSecret);
        if (consumerKey != null && consumerSecret != null && consumerKey.length() != 0 && consumerSecret.length() != 0) {
            this.oauth = new OAuth(consumerKey, consumerSecret);
        }
    }

    public RequestToken setToken(String token, String tokenSecret) {
        this.oauthToken = new RequestToken(token, tokenSecret);
        return (RequestToken)this.oauthToken;
    }

    public RequestToken getOAuthRequestToken() throws TBlogException {
        this.oauthToken = new RequestToken(this.httpRequest(this.requestTokenURL, null, true), this);
        return (RequestToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(RequestToken token) throws TBlogException {
        try {
            this.oauthToken = token;
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[0], true));
        }
        catch (TBlogException te) {
            throw new TBlogException("The user has not given access to the account.", te, te.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getXAuthAccessToken(String passport, String password, boolean isMD5) throws TBlogException {
        String passtype = "1";
        if (isMD5) {
            passtype = "0";
        }
        PostParameter[] params = new PostParameter[]{new PostParameter("x_auth_username", passport), new PostParameter("x_auth_password", password), new PostParameter("x_auth_mode", "client_auth"), new PostParameter("x_auth_passtype", passtype)};
        this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, params, true));
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(RequestToken token, String pin) throws TBlogException {
        try {
            this.oauthToken = token;
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[]{new PostParameter("oauth_verifier", pin)}, true));
        }
        catch (TBlogException te) {
            throw new TBlogException("The user has not given access to the account.", te, te.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret) throws TBlogException {
        try {
            this.oauthToken = new OAuthToken(token, tokenSecret){};
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[0], true));
        }
        catch (TBlogException te) {
            throw new TBlogException("The user has not given access to the account.", te, te.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret, String oauth_verifier) throws TBlogException {
        try {
            this.oauthToken = new OAuthToken(token, tokenSecret){};
            this.oauthToken = new AccessToken(this.httpRequest(this.accessTokenURL, new PostParameter[]{new PostParameter("oauth_verifier", oauth_verifier)}, true));
        }
        catch (TBlogException te) {
            throw new TBlogException("The user has not given access to the account.", te, te.getStatusCode());
        }
        return (AccessToken)this.oauthToken;
    }

    public void setOAuthAccessToken(AccessToken token) {
        this.oauthToken = token;
    }

    public void setRequestTokenURL(String requestTokenURL) {
        this.requestTokenURL = requestTokenURL;
    }

    public String getRequestTokenURL() {
        return this.requestTokenURL;
    }

    public String getAuthenticationRL() {
        return this.authenticationURL;
    }

    public void setAccessTokenURL(String accessTokenURL) {
        this.accessTokenURL = accessTokenURL;
    }

    public String getAccessTokenURL() {
        return this.accessTokenURL;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = Configuration.getProxyHost(proxyHost);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = Configuration.getProxyPort(proxyPort);
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public void setProxyAuthUser(String proxyAuthUser) {
        this.proxyAuthUser = Configuration.getProxyUser(proxyAuthUser);
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = Configuration.getProxyPassword(proxyAuthPassword);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = Configuration.getConnectionTimeout(connectionTimeout);
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = Configuration.getReadTimeout(readTimeout);
    }

    private void encodeBasicAuthenticationString() {
        if (this.userId != null && this.password != null) {
            this.basic = "Basic " + new String(new BASE64Encoder().encode((String.valueOf(this.userId) + ":" + this.password).getBytes()));
            this.oauth = null;
        }
    }

    public void setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("RetryCount cannot be negative.");
        }
        this.retryCount = Configuration.getRetryCount(retryCount);
    }

    public void setUserAgent(String ua) {
        this.setRequestHeader("User-Agent", Configuration.getUserAgent(ua));
    }

    public String getUserAgent() {
        return this.getRequestHeader("User-Agent");
    }

    public void setRetryIntervalSecs(int retryIntervalSecs) {
        if (retryIntervalSecs < 0) {
            throw new IllegalArgumentException("RetryInterval cannot be negative.");
        }
        this.retryIntervalMillis = Configuration.getRetryIntervalSecs(retryIntervalSecs) * 1000;
    }

    public Response post(String url, PostParameter[] postParameters, boolean authenticated) throws TBlogException {
        PostParameter[] newPostParameters = new PostParameter[postParameters.length];
        System.arraycopy(postParameters, 0, newPostParameters, 0, postParameters.length);
        return this.httpRequest(url, newPostParameters, authenticated);
    }

    public Response delete(String url, boolean authenticated) throws TBlogException {
        return this.httpRequest(url, null, authenticated, "DELETE");
    }

    public Response multPartURL(String fileParamName, String url, PostParameter[] params, File file, boolean authenticated) throws TBlogException {
        PostMethod post = new PostMethod(url);
        org.apache.commons.httpclient.HttpClient client = new org.apache.commons.httpclient.HttpClient();
        try {
            long t = System.currentTimeMillis();
            Part[] parts = null;
            parts = params == null ? new Part[1] : new Part[params.length + 1];
            if (params != null) {
                int i = 0;
                PostParameter[] postParameterArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    PostParameter entry = postParameterArray[n2];
                    parts[i++] = new StringPart(entry.getName(), entry.getValue());
                    ++n2;
                }
            }
            FilePart filePart = new FilePart(fileParamName, file.getName(), file, new MimetypesFileTypeMap().getContentType(file), "UTF-8");
            filePart.setTransferEncoding("binary");
            parts[parts.length - 1] = filePart;
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            ArrayList<Header> headers = new ArrayList<Header>();
            if (authenticated) {
                if (this.basic == null) {
                    // empty if block
                }
                String authorization = null;
                if (this.oauth != null) {
                    authorization = this.oauth.generateAuthorizationHeader("POST", url, params, this.oauthToken);
                } else if (this.basic != null) {
                    authorization = this.basic;
                } else {
                    throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
                }
                headers.add(new Header("Authorization", authorization));
                HttpClient.log("Authorization: " + authorization);
            }
            client.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
            client.executeMethod((HttpMethod)post);
            Response response = new Response();
            response.setResponseAsString(post.getResponseBodyAsString());
            response.setStatusCode(post.getStatusCode());
            HttpClient.log("multPartURL URL:" + url + ", result:" + response + ", time:" + (System.currentTimeMillis() - t));
            Response response2 = response;
            return response2;
        }
        catch (Exception ex) {
            throw new TBlogException(ex.getMessage(), ex, -1);
        }
        finally {
            post.releaseConnection();
            client = null;
        }
    }

    public Response post(String url, boolean authenticated) throws TBlogException {
        return this.httpRequest(url, new PostParameter[0], authenticated);
    }

    public Response post(String url, PostParameter[] PostParameters) throws TBlogException {
        return this.httpRequest(url, PostParameters, false);
    }

    public Response post(String url) throws TBlogException {
        return this.httpRequest(url, new PostParameter[0], false);
    }

    public Response get(String url, boolean authenticated) throws TBlogException {
        return this.httpRequest(url, null, authenticated);
    }

    public Response get(String url) throws TBlogException {
        return this.httpRequest(url, null, false);
    }

    protected Response httpRequest(String url, PostParameter[] postParams, boolean authenticated) throws TBlogException {
        int len = 1;
        PostParameter[] newPostParameters = postParams;
        String method = "GET";
        if (postParams != null) {
            method = "POST";
            len = postParams.length;
            System.arraycopy(postParams, 0, newPostParameters, 0, postParams.length);
        }
        return this.httpRequest(url, newPostParameters, authenticated, method);
    }

    public Response httpRequest(String url, PostParameter[] postParams, boolean authenticated, String httpMethod) throws TBlogException {
        int retry = this.retryCount + 1;
        Response res = null;
        int retriedCount = 0;
        while (retriedCount < retry) {
            block25: {
                int responseCode = -1;
                try {
                    HttpURLConnection con = null;
                    OutputStream osw = null;
                    try {
                        con = this.getConnection(url);
                        con.setDoInput(true);
                        this.setHeaders(url, postParams, con, authenticated, httpMethod);
                        if (postParams != null || "POST".equals(httpMethod)) {
                            con.setRequestMethod("POST");
                            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            con.setDoOutput(true);
                            String postParam = "";
                            if (postParams != null) {
                                postParam = HttpClient.encodeParameters(postParams);
                            }
                            HttpClient.log("Post Params: ", postParam);
                            byte[] bytes = postParam.getBytes("UTF-8");
                            con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                            osw = con.getOutputStream();
                            osw.write(bytes);
                            osw.flush();
                            osw.close();
                        } else if ("DELETE".equals(httpMethod)) {
                            con.setRequestMethod("DELETE");
                        } else {
                            con.setRequestMethod("GET");
                        }
                        res = new Response(con);
                        responseCode = con.getResponseCode();
                        if (DEBUG) {
                            HttpClient.log("Response: ");
                            Map<String, List<String>> responseHeaders = con.getHeaderFields();
                            for (String key : responseHeaders.keySet()) {
                                List<String> values = responseHeaders.get(key);
                                for (String value : values) {
                                    if (key != null) {
                                        HttpClient.log(String.valueOf(key) + ": " + value);
                                        continue;
                                    }
                                    HttpClient.log(value);
                                }
                            }
                        }
                        if (responseCode == 200) break;
                        if (responseCode < 500 || retriedCount == this.retryCount) {
                            throw new TBlogException(String.valueOf(HttpClient.getCause(responseCode)) + "\n" + res.asString(), responseCode);
                        }
                    }
                    finally {
                        try {
                            osw.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException ioe) {
                    if (retriedCount != this.retryCount) break block25;
                    throw new TBlogException(ioe.getMessage(), ioe, responseCode);
                }
            }
            try {
                if (DEBUG && res != null) {
                    res.asString();
                }
                HttpClient.log("Sleeping " + this.retryIntervalMillis + " millisecs for next retry.");
                Thread.sleep(this.retryIntervalMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++retriedCount;
        }
        return res;
    }

    public static String encodeParameters(PostParameter[] postParams) {
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < postParams.length) {
            if (j != 0) {
                buf.append("&");
            }
            try {
                buf.append(URLEncoder.encode(postParams[j].name, "UTF-8")).append("=").append(URLEncoder.encode(postParams[j].value, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++j;
        }
        return buf.toString();
    }

    private void setHeaders(String url, PostParameter[] params, HttpURLConnection connection, boolean authenticated, String httpMethod) {
        HttpClient.log("Request: ");
        HttpClient.log(String.valueOf(httpMethod) + " ", url);
        if (authenticated) {
            if (this.basic == null) {
                // empty if block
            }
            String authorization = null;
            if (this.oauth != null) {
                authorization = this.oauth.generateAuthorizationHeader(httpMethod, url, params, this.oauthToken);
            } else if (this.basic != null) {
                authorization = this.basic;
            } else {
                throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
            }
            connection.addRequestProperty("Authorization", authorization);
            HttpClient.log("Authorization: " + authorization);
        }
        for (String key : this.requestHeaders.keySet()) {
            connection.addRequestProperty(key, this.requestHeaders.get(key));
            HttpClient.log(String.valueOf(key) + ": " + this.requestHeaders.get(key));
        }
    }

    public void setRequestHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    public String getRequestHeader(String name) {
        return this.requestHeaders.get(name);
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection con = null;
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                HttpClient.log("Proxy AuthUser: " + this.proxyAuthUser);
                HttpClient.log("Proxy AuthPassword: " + this.proxyAuthPassword);
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClient.this.proxyAuthUser, HttpClient.this.proxyAuthPassword.toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.proxyHost, this.proxyPort));
            if (DEBUG) {
                HttpClient.log("Opening proxied connection(" + this.proxyHost + ":" + this.proxyPort + ")");
            }
            con = (HttpURLConnection)new URL(url).openConnection(proxy);
        } else {
            con = (HttpURLConnection)new URL(url).openConnection();
        }
        if (this.connectionTimeout > 0 && !isJDK14orEarlier) {
            con.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout > 0 && !isJDK14orEarlier) {
            con.setReadTimeout(this.readTimeout);
        }
        return con;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpClient)) {
            return false;
        }
        HttpClient that = (HttpClient)o;
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.proxyPort != that.proxyPort) {
            return false;
        }
        if (this.readTimeout != that.readTimeout) {
            return false;
        }
        if (this.retryCount != that.retryCount) {
            return false;
        }
        if (this.retryIntervalMillis != that.retryIntervalMillis) {
            return false;
        }
        if (this.accessTokenURL != null ? !this.accessTokenURL.equals(that.accessTokenURL) : that.accessTokenURL != null) {
            return false;
        }
        if (!this.authenticationURL.equals(that.authenticationURL)) {
            return false;
        }
        if (this.basic != null ? !this.basic.equals(that.basic) : that.basic != null) {
            return false;
        }
        if (this.oauth != null ? !this.oauth.equals(that.oauth) : that.oauth != null) {
            return false;
        }
        if (this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.proxyAuthPassword != null ? !this.proxyAuthPassword.equals(that.proxyAuthPassword) : that.proxyAuthPassword != null) {
            return false;
        }
        if (this.proxyAuthUser != null ? !this.proxyAuthUser.equals(that.proxyAuthUser) : that.proxyAuthUser != null) {
            return false;
        }
        if (this.proxyHost != null ? !this.proxyHost.equals(that.proxyHost) : that.proxyHost != null) {
            return false;
        }
        if (!this.requestHeaders.equals(that.requestHeaders)) {
            return false;
        }
        if (!this.requestTokenURL.equals(that.requestTokenURL)) {
            return false;
        }
        return !(this.userId != null ? !this.userId.equals(that.userId) : that.userId != null);
    }

    public int hashCode() {
        int result = this.basic != null ? this.basic.hashCode() : 0;
        result = 31 * result + this.retryCount;
        result = 31 * result + this.retryIntervalMillis;
        result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.proxyHost != null ? this.proxyHost.hashCode() : 0);
        result = 31 * result + this.proxyPort;
        result = 31 * result + (this.proxyAuthUser != null ? this.proxyAuthUser.hashCode() : 0);
        result = 31 * result + (this.proxyAuthPassword != null ? this.proxyAuthPassword.hashCode() : 0);
        result = 31 * result + this.connectionTimeout;
        result = 31 * result + this.readTimeout;
        result = 31 * result + this.requestHeaders.hashCode();
        result = 31 * result + (this.oauth != null ? this.oauth.hashCode() : 0);
        result = 31 * result + this.requestTokenURL.hashCode();
        result = 31 * result + this.authenticationURL.hashCode();
        result = 31 * result + (this.accessTokenURL != null ? this.accessTokenURL.hashCode() : 0);
        result = 31 * result + (this.oauthToken != null ? this.oauthToken.hashCode() : 0);
        return result;
    }

    private static void log(String message) {
        if (DEBUG) {
            System.out.println("[" + new Date() + "]" + message);
        }
    }

    private static void log(String message, String message2) {
        if (DEBUG) {
            HttpClient.log(String.valueOf(message) + message2);
        }
    }

    private static String getCause(int statusCode) {
        String cause = null;
        switch (statusCode) {
            case 304: {
                break;
            }
            case 400: {
                cause = "The request was invalid.  An accompanying error message will explain why. This is the status code will be returned during rate limiting.";
                break;
            }
            case 401: {
                cause = "Authentication credentials were missing or incorrect.";
                break;
            }
            case 403: {
                cause = "The request is understood, but it has been refused.  An accompanying error message will explain why.";
                break;
            }
            case 404: {
                cause = "The URI requested is invalid or the resource requested, such as a user, does not exists.";
                break;
            }
            case 406: {
                cause = "Returned by the Search API when an invalid format is specified in the request.";
                break;
            }
            case 500: {
                cause = "Something is broken.  Please post to the group so the team can investigate.";
                break;
            }
            case 502: {
                cause = "server is down or being upgraded.";
                break;
            }
            case 503: {
                cause = "Service Unavailable: The servers are up, but overloaded with requests. Try again later. The search and trend methods use this to indicate when you are being rate limited.";
                break;
            }
            default: {
                cause = "";
            }
        }
        return String.valueOf(statusCode) + ":" + cause;
    }
}

