/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.ResultReader;
import org.springframework.jdbc.object.SqlQuery;

public abstract class UpdatableSqlQuery
extends SqlQuery {
    public UpdatableSqlQuery() {
        this.setUpdatableResults(true);
    }

    public UpdatableSqlQuery(DataSource ds, String sql) {
        super(ds, sql);
        this.setUpdatableResults(true);
    }

    protected ResultReader newResultReader(int rowsExpected, Object[] parameters, Map context) {
        return new ResultReaderImpl(rowsExpected, context);
    }

    protected abstract Object updateRow(ResultSet var1, int var2, Map var3) throws SQLException;

    protected class ResultReaderImpl
    implements ResultReader {
        private final List results;
        private final Map context;
        private int rowNum = 0;

        public ResultReaderImpl(int rowsExpected, Map context) {
            this.results = rowsExpected > 0 ? new ArrayList(rowsExpected) : new LinkedList();
            this.context = context;
        }

        public void processRow(ResultSet rs) throws SQLException {
            this.results.add(UpdatableSqlQuery.this.updateRow(rs, this.rowNum++, this.context));
            rs.updateRow();
        }

        public List getResults() {
            return this.results;
        }
    }
}

