/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.ApplicationContextAwareProcessor;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceEditor;

public abstract class AbstractApplicationContext
extends DefaultResourceLoader
implements ConfigurableApplicationContext {
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    public static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "applicationEventMulticaster";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext parent;
    private final List beanFactoryPostProcessors = new ArrayList();
    private String displayName = this.getClass().getName() + ";hashCode=" + this.hashCode();
    private long startupTime;
    private MessageSource messageSource;
    private ApplicationEventMulticaster applicationEventMulticaster;
    static /* synthetic */ Class class$org$springframework$context$event$ContextClosedEvent;
    static /* synthetic */ Class class$org$springframework$core$io$Resource;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$org$springframework$core$io$ResourceLoader;
    static /* synthetic */ Class class$org$springframework$context$ApplicationContext;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanFactoryPostProcessor;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanPostProcessor;
    static /* synthetic */ Class class$org$springframework$context$ApplicationListener;

    public AbstractApplicationContext() {
    }

    public AbstractApplicationContext(ApplicationContext parent) {
        this.parent = parent;
    }

    public ApplicationContext getParent() {
        return this.parent;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getStartupDate() {
        return this.startupTime;
    }

    public void publishEvent(ApplicationEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publishing event in context [" + this.getDisplayName() + "]: " + event.toString()));
        }
        this.applicationEventMulticaster.multicastEvent(event);
        if (this.parent != null) {
            this.parent.publishEvent(event);
        }
    }

    public void setParent(ApplicationContext parent) {
        this.parent = parent;
    }

    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor beanFactoryPostProcessor) {
        this.beanFactoryPostProcessors.add(beanFactoryPostProcessor);
    }

    public List getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    public void refresh() throws BeansException {
        this.startupTime = System.currentTimeMillis();
        this.refreshBeanFactory();
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        beanFactory.registerCustomEditor(class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = AbstractApplicationContext.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource, new ResourceEditor(this));
        beanFactory.registerCustomEditor(class$java$io$InputStream == null ? (class$java$io$InputStream = AbstractApplicationContext.class$("java.io.InputStream")) : class$java$io$InputStream, new InputStreamEditor(new ResourceEditor(this)));
        beanFactory.addBeanPostProcessor(new ApplicationContextAwareProcessor(this));
        beanFactory.ignoreDependencyType(class$org$springframework$core$io$ResourceLoader == null ? (class$org$springframework$core$io$ResourceLoader = AbstractApplicationContext.class$("org.springframework.core.io.ResourceLoader")) : class$org$springframework$core$io$ResourceLoader);
        beanFactory.ignoreDependencyType(class$org$springframework$context$ApplicationContext == null ? (class$org$springframework$context$ApplicationContext = AbstractApplicationContext.class$("org.springframework.context.ApplicationContext")) : class$org$springframework$context$ApplicationContext);
        this.postProcessBeanFactory(beanFactory);
        Iterator it = this.getBeanFactoryPostProcessors().iterator();
        while (it.hasNext()) {
            BeanFactoryPostProcessor factoryProcessor = (BeanFactoryPostProcessor)it.next();
            factoryProcessor.postProcessBeanFactory(beanFactory);
        }
        if (this.getBeanDefinitionCount() == 0) {
            this.logger.warn((Object)("No beans defined in ApplicationContext [" + this.getDisplayName() + "]"));
        } else {
            this.logger.info((Object)(this.getBeanDefinitionCount() + " beans defined in ApplicationContext [" + this.getDisplayName() + "]"));
        }
        this.invokeBeanFactoryPostProcessors();
        this.registerBeanPostProcessors();
        this.initMessageSource();
        this.initApplicationEventMulticaster();
        this.onRefresh();
        this.refreshListeners();
        beanFactory.preInstantiateSingletons();
        this.publishEvent(new ContextRefreshedEvent(this));
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void invokeBeanFactoryPostProcessors() throws BeansException {
        int i;
        String[] beanNames = this.getBeanDefinitionNames(class$org$springframework$beans$factory$config$BeanFactoryPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanFactoryPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanFactoryPostProcessor")) : class$org$springframework$beans$factory$config$BeanFactoryPostProcessor);
        BeanFactoryPostProcessor[] factoryProcessors = new BeanFactoryPostProcessor[beanNames.length];
        for (i = 0; i < beanNames.length; ++i) {
            factoryProcessors[i] = (BeanFactoryPostProcessor)this.getBean(beanNames[i]);
        }
        Arrays.sort(factoryProcessors, new OrderComparator());
        for (i = 0; i < factoryProcessors.length; ++i) {
            BeanFactoryPostProcessor factoryProcessor = factoryProcessors[i];
            factoryProcessor.postProcessBeanFactory(this.getBeanFactory());
        }
    }

    private void registerBeanPostProcessors() throws BeansException {
        String[] beanNames = this.getBeanDefinitionNames(class$org$springframework$beans$factory$config$BeanPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanPostProcessor")) : class$org$springframework$beans$factory$config$BeanPostProcessor);
        if (beanNames.length > 0) {
            ArrayList<Object> beanProcessors = new ArrayList<Object>();
            for (int i = 0; i < beanNames.length; ++i) {
                beanProcessors.add(this.getBean(beanNames[i]));
            }
            Collections.sort(beanProcessors, new OrderComparator());
            Iterator it = beanProcessors.iterator();
            while (it.hasNext()) {
                this.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)it.next());
            }
        }
    }

    private void initMessageSource() throws BeansException {
        try {
            this.messageSource = (MessageSource)this.getBean(MESSAGE_SOURCE_BEAN_NAME);
            if (this.parent != null && this.messageSource instanceof HierarchicalMessageSource && Arrays.asList(this.getBeanDefinitionNames()).contains(MESSAGE_SOURCE_BEAN_NAME)) {
                ((HierarchicalMessageSource)this.messageSource).setParentMessageSource(this.parent);
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.logger.info((Object)("No MessageSource found for context [" + this.getDisplayName() + "]: using empty default"));
            this.messageSource = new StaticMessageSource();
        }
    }

    private void initApplicationEventMulticaster() throws BeansException {
        try {
            this.applicationEventMulticaster = (ApplicationEventMulticaster)this.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME);
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.logger.info((Object)("No ApplicationEventMulticaster found for context [" + this.getDisplayName() + "]: using default"));
            this.applicationEventMulticaster = new SimpleApplicationEventMulticaster();
        }
    }

    protected void onRefresh() throws BeansException {
    }

    private void refreshListeners() throws BeansException {
        this.logger.info((Object)"Refreshing listeners");
        Collection listeners = this.getBeansOfType(class$org$springframework$context$ApplicationListener == null ? (class$org$springframework$context$ApplicationListener = AbstractApplicationContext.class$("org.springframework.context.ApplicationListener")) : class$org$springframework$context$ApplicationListener, true, false).values();
        this.logger.debug((Object)("Found " + listeners.size() + " listeners in bean factory"));
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ApplicationListener listener = (ApplicationListener)it.next();
            this.addListener(listener);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Application listener [" + listener + "] added"));
        }
    }

    protected void addListener(ApplicationListener listener) {
        this.applicationEventMulticaster.addApplicationListener(listener);
    }

    public void close() {
        this.logger.info((Object)("Closing application context [" + this.getDisplayName() + "]"));
        this.getBeanFactory().destroySingletons();
        this.publishEvent(new ContextClosedEvent(this));
    }

    public Object getBean(String name) throws BeansException {
        return this.getBeanFactory().getBean(name);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBeanFactory().getBean(name, requiredType);
    }

    public boolean containsBean(String name) {
        return this.getBeanFactory().containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isSingleton(name);
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getAliases(name);
    }

    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    public String[] getBeanDefinitionNames(Class type) {
        return this.getBeanFactory().getBeanDefinitionNames(type);
    }

    public boolean containsBeanDefinition(String name) {
        return this.getBeanFactory().containsBeanDefinition(name);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type, includePrototypes, includeFactoryBeans);
    }

    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    protected BeanFactory getInternalParentBeanFactory() {
        return this.getParent() instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)this.getParent()).getBeanFactory() : this.getParent();
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, locale);
    }

    protected abstract void refreshBeanFactory() throws BeansException;

    public abstract ConfigurableListableBeanFactory getBeanFactory();

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(": ");
        sb.append("displayName=[").append(this.displayName).append("]; ");
        sb.append("startup date=[").append(new Date(this.startupTime)).append("]; ");
        if (this.parent == null) {
            sb.append("root of ApplicationContext hierarchy");
        } else {
            sb.append("parent=[").append(this.parent).append(']');
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        (class$org$springframework$context$event$ContextClosedEvent == null ? (class$org$springframework$context$event$ContextClosedEvent = AbstractApplicationContext.class$("org.springframework.context.event.ContextClosedEvent")) : class$org$springframework$context$event$ContextClosedEvent).getName();
    }
}

