/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodOverrides;

public class LookupOverride
extends MethodOverride {
    private final String beanName;

    public LookupOverride(String methodName, String beanName) {
        super(methodName);
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean matches(Method method, MethodOverrides overrides) {
        return method.getName().equals(this.getMethodName());
    }

    public String toString() {
        return "LookupOverride for method '" + this.getMethodName() + "'; will return bean '" + this.beanName + "'";
    }
}

