/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.LimiterInputStream;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.tds.SybBigDecimal;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class SybPreparedStatement
extends SybStatement
implements com.sybase.jdbcx.SybPreparedStatement {
    private static final int MAX_PARAMETERS = 1000;
    protected static final int BASE_MAX_BATCH_PARAMETERS = 255;
    String _dynStmtName = null;
    int _paramCount = 0;
    Vector _batchParams = null;
    protected String _query = null;
    protected ParamManager _paramMgr;

    SybPreparedStatement(ProtocolContext protocolContext, String string) throws SQLException {
        super(protocolContext);
        string = this.doEscapeProcessing(string);
        this._paramMgr = this.countParams(string);
    }

    SybPreparedStatement(ProtocolContext protocolContext, String string, int n) throws SQLException {
        super(protocolContext);
        string = this.doEscapeProcessing(string);
        this._paramMgr = this.countParams(string);
        String string2 = "dyn" + n;
        this._protocol.dynamicPrepare(protocolContext, string2, string);
        this._dynStmtName = string2;
    }

    public void addBatch() throws SQLException {
        this.checkDead();
        if (this._rpcName != null) {
            this._rpcName = null;
            this._doneinproc = true;
            this._query = "execute " + this._query;
            super.addBatch(this._query);
        } else {
            String string = "execute";
            if (this._query.toLowerCase().startsWith(string)) {
                this._doneinproc = true;
            }
            super.addBatch(this._query);
        }
        if (this._paramCount == 0) {
            this._paramCount = this._paramMgr._params.length;
        }
        if (this._batchParams == null) {
            this._batchParams = new Vector();
        }
        int n = 0;
        while (n < this._paramCount) {
            Param param = this._paramMgr._params[n].cloneMe();
            this._batchParams.addElement(param);
            ++n;
        }
    }

    public void addBatch(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "addBatch(String)");
    }

    protected boolean checkBatch() throws SQLException {
        boolean bl = super.checkBatch();
        boolean bl2 = false;
        if (this._dbmda != null) {
            bl2 = this._dbmda.execParameterizedBatchUpdatesInLoop();
            if (bl2 && this._context._conn._props.getBoolean(15)) {
                bl2 = false;
            }
            bl |= bl2;
        }
        return bl;
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        this._batchParams = null;
        this._paramCount = 0;
    }

    public void clearParameters() throws SQLException {
        this.checkDead();
        try {
            this._paramMgr.clearParams(true);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    /*
     * Exception decompiling
     */
    private ParamManager countParams(String var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Vector createDynamicExecuteBatchParams() throws SQLException {
        Vector<ParamManager> vector = new Vector<ParamManager>();
        int n = 0;
        int n2 = 0;
        while (n2 < this._batchCmds.size()) {
            ParamManager paramManager = this.countParams((String)this._batchCmds.elementAt(0));
            int n3 = paramManager._params.length;
            int n4 = 0;
            while (n4 < n3) {
                Param param = (Param)this._batchParams.elementAt(n);
                paramManager.setParam(n4 + 1, param._sqlType, param._inValue, param._scale);
                ++n;
                ++n4;
            }
            vector.add(paramManager);
            ++n2;
        }
        return vector;
    }

    protected void deallocateDynamic() throws SQLException {
        if (this._dynStmtName != null) {
            this._protocol.dynamicDeallocate(this._context, this._dynStmtName);
        }
    }

    public boolean execute() throws SQLException {
        return super.execute(this._query, this._paramMgr);
    }

    public boolean execute(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "execute(String)");
        return false;
    }

    public int[] executeBatch() throws SQLException {
        this.checkDead();
        if (this._batchCmds == null) {
            return new int[0];
        }
        int[] nArray = new int[this._batchCmds.size()];
        if (this.checkBatch()) {
            int n = 0;
            int n2 = 0;
            while (n2 < this._batchCmds.size()) {
                Object object;
                ParamManager paramManager = this.countParams((String)this._batchCmds.elementAt(n2));
                int n3 = paramManager._params.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = (Param)this._batchParams.elementAt(n);
                    paramManager.setParam(n4 + 1, object._sqlType, object._inValue, object._scale);
                    ++n;
                    ++n4;
                }
                try {
                    object = super.executeBatch(paramManager);
                    nArray[n2] = object[0];
                }
                catch (SQLException sQLException) {
                    this.handleBatchException(sQLException, nArray, n2);
                }
                ++n2;
            }
            this.clearBatch();
            return nArray;
        }
        if (this._dynStmtName != null) {
            return super.executeBatch(null);
        }
        boolean bl = this._context._conn._props.getBoolean(15);
        int n = 0;
        if (!bl) {
            n = this._dbmda == null ? 255 : this._dbmda.getMaxParamsPerBatch();
        }
        if (!bl && this._batchCmdsCount * this._paramCount > n && this._paramCount <= n) {
            int n5 = n / this._paramCount;
            int[] nArray2 = null;
            String string = (String)this._batchCmds.firstElement();
            Vector<String> vector = new Vector<String>();
            int n6 = 0;
            while (n6 < n5) {
                vector.add(string);
                ++n6;
            }
            this._batchCmds = vector;
            int n7 = this._batchCmdsCount;
            int n8 = 0;
            int n9 = 0;
            int n10 = n5;
            while (n7 > 0) {
                if (n7 < n5) {
                    vector.clear();
                    int n11 = 0;
                    while (n11 < n7) {
                        vector.add(string);
                        ++n11;
                    }
                    this._batchCmds = vector;
                    n10 = n7;
                }
                this._batchCmdsCount = n10;
                ParamManager paramManager = this.countParams(this.batchToString());
                int n12 = 0;
                while (n12 < this._paramCount * n10) {
                    Param param = (Param)this._batchParams.elementAt(n8);
                    paramManager.setParam(n12 + 1, param._sqlType, param._inValue, param._scale);
                    ++n8;
                    ++n12;
                }
                try {
                    nArray2 = super.executeBatch(paramManager, false);
                }
                catch (SQLException sQLException) {
                    this.handleBatchException(sQLException, nArray, n9);
                }
                int n13 = 0;
                while (n13 < n10) {
                    nArray[n9] = nArray2[n13];
                    ++n9;
                    ++n13;
                }
                n7 -= n10;
            }
            return nArray;
        }
        ParamManager paramManager = this.countParams(this.batchToString());
        int n14 = this._batchParams.size();
        int n15 = 0;
        while (n15 < n14) {
            Param param = (Param)this._batchParams.elementAt(n15);
            paramManager.setParam(n15 + 1, param._sqlType, param._inValue, param._scale);
            ++n15;
        }
        return super.executeBatch(paramManager);
    }

    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this._query, this._paramMgr);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "executeQuery(String)");
        return null;
    }

    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this._query, this._paramMgr);
    }

    public int executeUpdate(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "executeUpdate(String)");
        return 0;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkDead();
        ResultSetMetaData resultSetMetaData = this._protocol.dynamicMetaData(this._context);
        if (resultSetMetaData == null) {
            ErrorMessage.raiseError("JZ0DP");
        }
        return resultSetMetaData;
    }

    public boolean sendQuery(String string, ParamManager paramManager) throws SQLException {
        this.checkDead();
        if (this._dynStmtName != null && this._cursor == null && !this.checkBatch()) {
            try {
                if (this._batchCmds == null) {
                    this._protocol.dynamicExecute(this._context, this._dynStmtName, paramManager);
                } else {
                    this._protocol.dynamicExecuteBatch(this._context, this._dynStmtName, this.createDynamicExecuteBatchParams());
                }
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            this._state = 2;
            return false;
        }
        if (this._batchCmds != null) {
            return super.sendQuery(string, paramManager);
        }
        return super.sendQuery(this._query, this._paramMgr);
    }

    public void setArray(int n, Array array) throws SQLException {
        Debug.notSupported(this, "setArray(int, Array)");
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkDead();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n2), "8859_1");
            this.setParam(-1, n, inputStreamReader, n2);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkDead();
        this.setParam(2, n, bigDecimal, bigDecimal.scale());
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        this.checkDead();
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal("0");
        }
        SybBigDecimal sybBigDecimal = new SybBigDecimal(bigDecimal, n2, n3);
        this.setParam(2, n, sybBigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkDead();
        this.setParam(-4, n, inputStream, n2);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        Debug.notSupported(this, "setBlob(int, Blob)");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkDead();
        Boolean bl2 = new Boolean(bl);
        this.setParam(-7, n, bl2);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkDead();
        Integer n2 = new Integer(by);
        if (n2 < 0) {
            this.setParam(5, n, n2);
        } else {
            this.setParam(-6, n, n2);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkDead();
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        if (n2 > 255) {
            this.setParam(-4, n, byArray);
        } else {
            this.setParam(-3, n, byArray);
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkDead();
        this.setParam(-1, n, reader, n2);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        Debug.notSupported(this, "setClob(int, Clob)");
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkDead();
        if (date == null) {
            this.setParam(91, n, date);
        } else {
            this.setParam(91, n, new DateObject(date));
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkDead();
        if (date == null) {
            this.setParam(91, n, date);
        } else {
            this.setParam(91, n, new DateObject(date, calendar));
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkDead();
        Double d2 = new Double(d);
        this.setParam(8, n, d2);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkDead();
        Float f2 = new Float(f);
        this.setParam(7, n, f2);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkDead();
        Integer n3 = new Integer(n2);
        this.setParam(4, n, n3);
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkDead();
        Long l2 = new Long(l);
        this.setParam(-5, n, l2);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkDead();
        this.setParam(n2, n, null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        Debug.notImplemented(this, "setNull(int, int, String)");
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkDead();
        if (object == null) {
            ErrorMessage.raiseError("JZ0SE");
        }
        if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Boolean) {
            this.setParam(-7, n, object);
        } else if (object instanceof Integer) {
            this.setParam(4, n, object);
        } else if (object instanceof Long) {
            this.setParam(-5, n, object);
        } else if (object instanceof Float) {
            this.setParam(7, n, object);
        } else if (object instanceof Double) {
            this.setParam(8, n, object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Serializable) {
            this.setParam(2000, n, object);
        } else {
            ErrorMessage.raiseError("JZ0SE");
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkDead();
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkDead();
        if (object == null) {
            this.setParam(n2, n, null, n3);
        }
        switch (n2) {
            case -7: {
                this.setParam(n2, n, Convert.objectToBoolean(object), n3);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                this.setParam(n2, n, Convert.objectToInt(object), n3);
                break;
            }
            case -5: {
                this.setParam(n2, n, Convert.objectToLong(object), n3);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, Convert.objectToString(object));
                break;
            }
            case 2: 
            case 3: {
                if (n3 < 0) {
                    ErrorMessage.raiseError("JZ00I");
                }
                this.setParam(n2, n, Convert.objectToBigDecimal(object), n3);
                break;
            }
            case 7: {
                this.setParam(n2, n, Convert.objectToFloat(object), n3);
                break;
            }
            case 6: 
            case 8: {
                this.setParam(n2, n, Convert.objectToDouble(object), n3);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(n, Convert.objectToBytes(object));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.setParam(n2, n, Convert.objectToDateObject(object, n2, null), n3);
                break;
            }
            case 1111: 
            case 2000: {
                if (object instanceof Serializable) {
                    this.setParam(2000, n, object);
                    break;
                }
            }
            default: {
                ErrorMessage.raiseError("JZ0SE");
            }
        }
    }

    private void setParam(int n, int n2, Object object) throws SQLException {
        this.setParam(n, n2, object, 0);
    }

    private void setParam(int n, int n2, Object object, int n3) throws SQLException {
        this._paramMgr.setParam(n2, n, object, n3);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        Debug.notSupported(this, "setRef(int, Ref)");
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkDead();
        Integer n2 = new Integer(s);
        this.setParam(5, n, n2);
    }

    public void setString(int n, String string) throws SQLException {
        this.checkDead();
        int n2 = 0;
        if (string != null && (n2 = string.length()) == 0) {
            string = new String(" ");
        }
        this.setParam(12, n, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkDead();
        if (time == null) {
            this.setParam(92, n, time);
        } else {
            this.setParam(92, n, new DateObject(time));
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkDead();
        if (time == null) {
            this.setParam(92, n, time);
        } else {
            this.setParam(92, n, new DateObject(time, calendar));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkDead();
        if (timestamp == null) {
            this.setParam(93, n, timestamp);
        } else {
            this.setParam(93, n, new DateObject(timestamp));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkDead();
        if (timestamp == null) {
            this.setParam(93, n, timestamp);
        } else {
            this.setParam(93, n, new DateObject(timestamp, calendar));
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkDead();
        this.setParam(-1, n, inputStream, n2);
    }

    public void switchContext(ProtocolContext protocolContext) {
        this._context = protocolContext;
    }
}

