/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.statement;

import java.sql.SQLException;
import org.dbunit.database.statement.IPreparedBatchStatement;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class AutomaticPreparedBatchStatement
implements IPreparedBatchStatement {
    private final IPreparedBatchStatement _statement;
    private int _batchCount = 0;
    private int _threshold;
    private int _result = 0;

    public AutomaticPreparedBatchStatement(IPreparedBatchStatement statement, int threshold) {
        this._statement = statement;
        this._threshold = threshold;
    }

    public void addValue(Object value, DataType dataType) throws TypeCastException, SQLException {
        this._statement.addValue(value, dataType);
    }

    public void addBatch() throws SQLException {
        this._statement.addBatch();
        ++this._batchCount;
        if (this._batchCount % this._threshold == 0) {
            this._result += this._statement.executeBatch();
        }
    }

    public int executeBatch() throws SQLException {
        this._result += this._statement.executeBatch();
        return this._result;
    }

    public void clearBatch() throws SQLException {
        this._statement.clearBatch();
        this._batchCount = 0;
    }

    public void close() throws SQLException {
        this._statement.close();
    }
}

