/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class DB2Blob
implements Blob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected DB2InputStream db2is;
    protected DB2Request db2req;
    protected boolean closed = false;
    protected byte[] data = null;

    public DB2Blob(DB2Statement dB2Statement, int n) throws SQLException {
        this.connection = (DB2Connection)dB2Statement.getConnection();
        this.locator = n;
        this.lobType = 31;
        this.db2is = new DB2InputStream(dB2Statement, n, this.lobType, false);
        this.statement = this.connection.getInputStreamStmt();
        this.db2req = this.statement.db2req;
    }

    public DB2Blob(byte[] byArray) {
        this.data = byArray == null ? new byte[0] : byArray;
    }

    protected int SQLGetPosition(byte[] byArray, int n) throws SQLException {
        int n2 = -1;
        try {
            DB2Statement dB2Statement = this.statement;
            synchronized (dB2Statement) {
                this.db2req.write((short)207);
                this.db2req.write(this.statement.getHandle());
                this.db2req.write(this.locator);
                this.db2req.write(byArray);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                this.connection.sqlExcptGen.check_return_code(this.statement, n3);
                n2 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.connection.sqlExcptGen.throw_IOException(iOException);
        }
        return n2;
    }

    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            if (!this.closed && this.db2is != null) {
                this.db2is.close();
            }
            this.closed = true;
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "close()");
            }
        }
    }

    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "finalize()");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream() throws SQLException {
        DB2InputStream dB2InputStream;
        block5: {
            ByteArrayInputStream byteArrayInputStream;
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getBinaryStream()");
                    }
                    if (this.db2is == null) {
                        byteArrayInputStream = new ByteArrayInputStream(this.data);
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return byteArrayInputStream;
                        break block4;
                    }
                    DB2InputStream dB2InputStream2 = null;
                    dB2InputStream = dB2InputStream2 = new DB2InputStream(this.statement, this.locator, this.lobType, false);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
            return byteArrayInputStream;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return dB2InputStream;
        DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
        return dB2InputStream;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray = null;
        if (this.db2is == null) {
            if (l > (long)this.data.length || n == 0) {
                byArray = new byte[]{};
            } else {
                n = (int)Math.min((long)this.data.length - l + 1L, (long)n);
                byArray = new byte[n];
                System.arraycopy(this.data, (int)l - 1, byArray, 0, n);
            }
        } else {
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            try {
                this.db2is.moveTo((int)l);
                n2 = this.db2is.read(byArray2);
                if (n2 >= 0) {
                    if (n2 != n) {
                        byArray = new byte[n2];
                        System.arraycopy(byArray2, 0, byArray, 0, n2);
                    } else {
                        byArray = byArray2;
                    }
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        }
        return byArray;
    }

    int getLocator() {
        return this.locator;
    }

    public long length() throws SQLException {
        long l = 0L;
        l = this.db2is == null ? (long)this.data.length : this.db2is.getLength();
        return l;
    }

    public long position(Blob blob, long l) throws SQLException {
        if (blob instanceof DB2Blob && ((DB2Blob)blob).db2is != null && this.db2is != null) {
            DB2Blob dB2Blob = (DB2Blob)blob;
            int n = dB2Blob.getLocator();
            int n2 = -1;
            try {
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    this.db2req.write((short)208);
                    this.db2req.write(this.statement.getHandle());
                    this.db2req.write(this.locator);
                    this.db2req.write(this.lobType);
                    this.db2req.write(n);
                    this.db2req.write((int)l);
                    this.db2req.sendAndRecv();
                    int n3 = this.db2req.readInt();
                    this.connection.sqlExcptGen.check_return_code(this.statement, n3);
                    n2 = this.db2req.readInt();
                }
            }
            catch (IOException iOException) {
                this.connection.sqlExcptGen.throw_IOException(iOException);
            }
            return n2;
        }
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        long l2 = -1L;
        if (byArray == null || byArray.length == 0) {
            l2 = -1L;
        } else if (this.db2is == null) {
            while (l + (long)byArray.length - 1L < (long)this.data.length) {
                int n = (int)l - 1;
                int n2 = 0;
                while (n2 < byArray.length && this.data[n] == byArray[n2]) {
                    ++n;
                    ++n2;
                }
                if (byArray.length == n2) {
                    l2 = l;
                }
                ++l;
            }
        } else {
            l2 = this.SQLGetPosition(byArray, (int)l);
        }
        return l2;
    }
}

