/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.sql.SQLException;

public class DB2ScrollableResultSet
extends DB2ResultSet {
    private int rowNumber = 0;
    private int activeFetchSize = -1;
    private int rowSetStart = -1;
    private int rowSetEnd = -1;
    static final int SQL_POSITION = 0;
    static final int SQL_LOCK_NO_CHANGE = 0;

    public DB2ScrollableResultSet(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        super(dB2Statement, n);
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2ScrollableResultSet( colNum=" + n + ",rowNum=" + n2 + ")");
            }
            this.rowNumber = n2;
            this.rsType = 1004;
            this.currentRowId = 0;
        }
        finally {
            Object var5_4 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "DB2ScrollableResultSet()");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean absolute(int n) throws SQLException {
        boolean bl;
        boolean bl2;
        block19: {
            boolean bl3;
            block18: {
                boolean bl4;
                block17: {
                    boolean bl5;
                    block16: {
                        boolean bl6;
                        block15: {
                            bl2 = false;
                            try {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.methodEntry(this, "absolute()");
                                }
                                if (this.connection.closed) {
                                    this.sqlExcptGen.throwConnectionClosedError();
                                }
                                if (this.statement.closed) {
                                    this.sqlExcptGen.throwClosedError();
                                }
                                if (n == 0) {
                                    this.sqlExcptGen.throwInvalidAbsoluteCall();
                                }
                                if (this.rowNumber == 0) {
                                    bl2 = false;
                                    bl6 = false;
                                    Object var5_8 = null;
                                    if (!DB2Trace.TraceOn) return bl6;
                                    break block15;
                                }
                                if (n > this.rowNumber) {
                                    if (this.currentRowId > this.rowNumber) {
                                        bl2 = false;
                                        bl5 = false;
                                        break block16;
                                    }
                                    n = this.rowNumber + 1;
                                } else if (-n > this.rowNumber) {
                                    if (this.currentRowId < 1) {
                                        bl2 = false;
                                        bl4 = false;
                                        break block17;
                                    }
                                    n = 0;
                                } else if (n < 0) {
                                    n = this.rowNumber + n + 1;
                                }
                                if (n == this.currentRowId) {
                                    bl2 = true;
                                    bl3 = true;
                                    break block18;
                                }
                                bl2 = this.fetchRowSet(n);
                                this.currentRowId = n;
                                bl = bl2;
                                break block19;
                            }
                            catch (Throwable throwable) {
                                Object var5_13 = null;
                                if (!DB2Trace.TraceOn) throw throwable;
                                DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(bl2));
                                throw throwable;
                            }
                        }
                        DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(bl2));
                        return bl6;
                    }
                    Object var5_9 = null;
                    if (!DB2Trace.TraceOn) return bl5;
                    DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(bl2));
                    return bl5;
                }
                Object var5_10 = null;
                if (!DB2Trace.TraceOn) return bl4;
                DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(bl2));
                return bl4;
            }
            Object var5_11 = null;
            if (!DB2Trace.TraceOn) return bl3;
            DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(bl2));
            return bl3;
        }
        Object var5_12 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "absolute()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterLast() throws SQLException {
        try {
            block8: {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "afterLast()");
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.statement.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (this.rowNumber == 0) break block8;
                if (this.currentRowId <= this.rowNumber) break block9;
            }
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "currentRowId", this.currentRowId);
            DB2Trace.methodExit(this, "afterLast()");
            throw throwable;
        }
        DB2Trace.data(10, "currentRowId", this.currentRowId);
        DB2Trace.methodExit(this, "afterLast()");
        {
            block9: {
                return;
            }
            this.fetchRowSet(this.rowNumber + 1);
            this.currentRowId = this.rowNumber + 1;
        }
        Object var2_2 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "currentRowId", this.currentRowId);
        DB2Trace.methodExit(this, "afterLast()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeFirst() throws SQLException {
        try {
            block8: {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "beforeFirst()");
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.statement.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (this.rowNumber == 0) break block8;
                if (this.currentRowId >= 1) break block9;
            }
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "currentRowId", this.currentRowId);
            DB2Trace.methodExit(this, "beforeFirst()");
            throw throwable;
        }
        DB2Trace.data(10, "currentRowId", this.currentRowId);
        DB2Trace.methodExit(this, "beforeFirst()");
        {
            block9: {
                return;
            }
            this.fetchRowSet(0);
            this.currentRowId = 0;
        }
        Object var2_2 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "currentRowId", this.currentRowId);
        DB2Trace.methodExit(this, "beforeFirst()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean fetchRowSet(int n) throws SQLException {
        boolean bl;
        boolean bl2 = false;
        int n2 = this.fetchSize;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "fetchRowSet(" + n + ")");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "rowSetStart, rowSetEnd, fetchSize, fetchDirection, rowNumber, currentRowId", String.valueOf(this.rowSetStart) + "," + this.rowSetEnd + "," + this.fetchSize + "," + this.fetchDirection + "," + this.rowNumber + "," + this.currentRowId);
            }
            this.clearIsList();
            this.clearWarnings();
            if (n >= this.rowSetStart && n <= this.rowSetEnd) {
                bl2 = this.setPos(n);
            } else {
                int n3;
                int n4;
                if (this.fetchSize < 1) {
                    n2 = 1;
                }
                int n5 = this.rowSetStart;
                int n6 = this.rowSetEnd;
                switch (this.fetchDirection) {
                    case 1000: {
                        this.rowSetStart = Math.max(1, n);
                        this.rowSetEnd = Math.min(this.rowNumber, this.rowSetStart + n2 - 1);
                        break;
                    }
                    case 1001: {
                        this.rowSetEnd = Math.min(this.rowNumber, n);
                        this.rowSetStart = Math.max(1, this.rowSetEnd - n2 + 1);
                        break;
                    }
                    case 1002: {
                        n4 = (n2 - 1) / 2;
                        this.rowSetStart = Math.max(1, n - n4);
                        this.rowSetEnd = Math.min(this.rowNumber, this.rowSetStart + n2 - 1);
                        break;
                    }
                    default: {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "Unknown fetch direction of " + this.fetchDirection);
                            DB2Trace.data(10, "Assuming Forward Only");
                        }
                        this.rowSetStart = Math.max(1, n);
                        this.rowSetEnd = Math.min(this.rowNumber, this.rowSetStart + n2 - 1);
                    }
                }
                n4 = 5;
                if (this.rowSetStart == n6 + 1 && this.fetchDirection == 1000) {
                    n4 = 1;
                } else if (this.rowSetEnd == n5 - 1 && this.fetchDirection == 1001) {
                    n4 = 4;
                }
                if (n < this.rowSetStart || n > this.rowSetEnd) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Moving to Invalid Row SQLFetchScroll(" + n + ")");
                    }
                    n3 = this.SQLFetchScroll(this.statement.statementHandle, n4, n, 0);
                } else if (this.activeFetchSize == n2) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "SQLFetchScroll(" + this.rowSetStart + ", resetFetchSize=FALSE )");
                    }
                    n3 = this.SQLFetchScroll(this.statement.statementHandle, n4, this.rowSetStart, 0);
                } else {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "SQLFetchScroll(" + this.rowSetStart + ", resetFetchSize=" + n2 + ")");
                    }
                    n3 = this.SQLFetchScroll(this.statement.statementHandle, n4, this.rowSetStart, n2);
                }
                if (n3 != 100) {
                    this.sqlExcptGen.check_return_code(this.statement, this, n3);
                    bl2 = true;
                    this.activeFetchSize = n2;
                    if (n != this.rowSetStart) {
                        bl2 = this.setPos(n);
                    }
                } else {
                    bl2 = false;
                    this.rowSetStart = -1;
                    this.rowSetEnd = -1;
                    this.activeFetchSize = -1;
                }
            }
            bl = bl2;
            Object var7_9 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "rowSetStart, rowSetEnd, fetchSize, tmpFetchSize, fetchDirection, rowNumber, currentRowId", String.valueOf(this.rowSetStart) + "," + this.rowSetEnd + "," + this.fetchSize + "," + n2 + "," + this.fetchDirection + "," + this.rowNumber + "," + this.currentRowId);
            DB2Trace.methodExit((Object)this, "fetchRowSet", String.valueOf(bl2));
            throw throwable;
        }
        DB2Trace.data(10, "rowSetStart, rowSetEnd, fetchSize, tmpFetchSize, fetchDirection, rowNumber, currentRowId", String.valueOf(this.rowSetStart) + "," + this.rowSetEnd + "," + this.fetchSize + "," + n2 + "," + this.fetchDirection + "," + this.rowNumber + "," + this.currentRowId);
        DB2Trace.methodExit((Object)this, "fetchRowSet", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean first() throws SQLException {
        boolean bl;
        boolean bl2;
        block9: {
            boolean bl3;
            block8: {
                boolean bl4;
                block7: {
                    bl2 = false;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "first()");
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (this.statement.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        if (this.rowNumber == 0) {
                            bl2 = false;
                            bl4 = false;
                            Object var4_5 = null;
                            if (!DB2Trace.TraceOn) return bl4;
                            break block7;
                        }
                        if (this.currentRowId == 1) {
                            bl2 = true;
                            bl3 = true;
                            break block8;
                        }
                        bl2 = this.fetchRowSet(1);
                        this.currentRowId = 1;
                        bl = bl2;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit((Object)this, "first()", String.valueOf(bl2));
                        throw throwable;
                    }
                }
                DB2Trace.methodExit((Object)this, "first()", String.valueOf(bl2));
                return bl4;
            }
            Object var4_6 = null;
            if (!DB2Trace.TraceOn) return bl3;
            DB2Trace.methodExit((Object)this, "first()", String.valueOf(bl2));
            return bl3;
        }
        Object var4_7 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "first()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRow() throws SQLException {
        int n;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getRow()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            n2 = this.rowNumber == 0 || this.currentRowId < 1 || this.currentRowId > this.rowNumber ? 0 : this.currentRowId;
            n = n2;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getRow()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getRow()", n2);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAfterLast() throws SQLException {
        boolean bl;
        boolean bl2 = false;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "isAfterLast()");
            }
            bl = bl2 = this.rowNumber > 0 && this.currentRowId > this.rowNumber;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "isAfterLast()", String.valueOf(bl2));
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "isAfterLast()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        boolean bl2 = false;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "isBeforeFirst()");
            }
            bl = bl2 = this.rowNumber > 0 && this.currentRowId < 1;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "isBeforeFirst()", String.valueOf(bl2));
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "isBeforeFirst()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFirst() throws SQLException {
        boolean bl;
        boolean bl2 = false;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "isFirst()");
            }
            bl = bl2 = this.rowNumber > 0 && this.currentRowId == 1;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "isFirst()", String.valueOf(bl2));
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "isFirst()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLast() throws SQLException {
        boolean bl;
        boolean bl2 = false;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "isLast()");
            }
            bl = bl2 = this.rowNumber > 0 && this.currentRowId == this.rowNumber;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "isLast()", String.valueOf(bl2));
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "isLast()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean last() throws SQLException {
        boolean bl;
        boolean bl2;
        block9: {
            boolean bl3;
            block8: {
                boolean bl4;
                block7: {
                    bl2 = false;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "last()");
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (this.statement.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        if (this.rowNumber == 0) {
                            bl2 = false;
                            bl4 = false;
                            Object var4_5 = null;
                            if (!DB2Trace.TraceOn) return bl4;
                            break block7;
                        }
                        if (this.currentRowId == this.rowNumber) {
                            bl2 = true;
                            bl3 = true;
                            break block8;
                        }
                        bl2 = this.fetchRowSet(this.rowNumber);
                        this.currentRowId = this.rowNumber;
                        bl = bl2;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit((Object)this, "last()", String.valueOf(bl2));
                        throw throwable;
                    }
                }
                DB2Trace.methodExit((Object)this, "last()", String.valueOf(bl2));
                return bl4;
            }
            Object var4_6 = null;
            if (!DB2Trace.TraceOn) return bl3;
            DB2Trace.methodExit((Object)this, "last()", String.valueOf(bl2));
            return bl3;
        }
        Object var4_7 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "last()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean next() throws SQLException {
        boolean bl;
        boolean bl2 = false;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "next()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            bl2 = this.rowNumber == 0 || this.currentRowId > this.rowNumber ? false : this.fetchRowSet(this.currentRowId + 1);
            ++this.currentRowId;
            bl = bl2;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "next()", String.valueOf(bl2));
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "next()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean previous() throws SQLException {
        boolean bl;
        boolean bl2 = false;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "previous()");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            bl2 = this.rowNumber == 0 || this.currentRowId < 1 ? false : this.fetchRowSet(this.currentRowId - 1);
            --this.currentRowId;
            bl = bl2;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "previous()", String.valueOf(bl2));
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "previous()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean relative(int n) throws SQLException {
        boolean bl;
        boolean bl2;
        block10: {
            boolean bl3;
            block9: {
                boolean bl4;
                block8: {
                    bl2 = false;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "relative()");
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (this.statement.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        if (this.getRow() == 0) {
                            this.sqlExcptGen.throwInvalidRelativeCall();
                        }
                        if (this.rowNumber == 0) {
                            bl2 = false;
                            bl4 = false;
                            Object var5_6 = null;
                            if (!DB2Trace.TraceOn) return bl4;
                            break block8;
                        }
                        int n2 = this.currentRowId + n;
                        if (n2 <= 0) {
                            this.beforeFirst();
                            bl2 = false;
                            bl3 = false;
                            break block9;
                        }
                        bl = bl2 = this.absolute(n2);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit((Object)this, "relative()", String.valueOf(bl2));
                        throw throwable;
                    }
                }
                DB2Trace.methodExit((Object)this, "relative()", String.valueOf(bl2));
                return bl4;
            }
            Object var5_7 = null;
            if (!DB2Trace.TraceOn) return bl3;
            DB2Trace.methodExit((Object)this, "relative()", String.valueOf(bl2));
            return bl3;
        }
        Object var5_8 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "relative()", String.valueOf(bl2));
        return bl;
    }

    protected void reset(int n, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "reset( " + n + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            this.reset(n);
            this.rowNumber = n2;
            this.currentRowId = 0;
            this.rowSetStart = -1;
            this.rowSetEnd = -1;
            this.fetchSize = this.statement.fetchSize;
            this.fetchDirection = this.statement.fetchDirection;
        }
        finally {
            Object var4_3 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "reset()");
            }
        }
    }

    protected void resetRows(int n) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "resetRows( " + n + " )");
            }
            this.rowNumber = n;
            this.currentRowId = 0;
            this.rowSetStart = -1;
            this.rowSetEnd = -1;
            this.fetchSize = this.statement.fetchSize;
            this.fetchDirection = this.statement.fetchDirection;
        }
        finally {
            Object var3_2 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "resetRows()");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean setPos(int n) throws SQLException {
        boolean bl;
        int n2 = 0;
        boolean bl2 = false;
        try {
            int n3;
            n2 = n - this.rowSetStart + 1;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setPos(" + n + ")");
                DB2Trace.data(10, "rowInSet", n2);
            }
            if ((n3 = this.SQLSetPos(this.statement.statementHandle, n2, 0, 0)) == 0) {
                bl2 = true;
            } else if (n3 == 1) {
                this.sqlExcptGen.check_return_code(this.statement, this, n3);
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "setPos", String.valueOf(bl2));
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "setPos", String.valueOf(bl2));
        return bl;
    }
}

