/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2PooledConnection;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import java.sql.SQLException;
import java.util.Properties;

public class DB2ReusableConnection
extends DB2Connection {
    private DB2PooledConnection pCon = null;

    public DB2ReusableConnection(String string, Properties properties, int n, DB2PooledConnection dB2PooledConnection, boolean bl) throws SQLException {
        super(string, properties, n, bl);
        this.pCon = dB2PooledConnection;
    }

    public void close() throws SQLException {
        DB2Trace.methodEntry(this, "close()");
        if (!this.closed) {
            super.setClosed(true);
            if (this.isConnectionAlive(this.connectionHandle)) {
                this.pCon.backToPool();
            } else {
                try {
                    this.realClose();
                }
                catch (SQLException sQLException) {}
                if (this.pCon != null) {
                    this.pCon.exceptionThrown(new DB2Exception(this.errMsgClass.getString("0600"), "S1000", -99999, null));
                }
            }
        }
        DB2Trace.methodExit(this, "close()");
        DB2Trace.flush();
    }

    public void realClose() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "realClose()");
            }
            this.close2();
        }
        finally {
            Object var2_1 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "realClose()");
            }
        }
    }
}

