/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Binary2AsciiInputStream;
import COM.ibm.db2.jdbc.app.DB2Binary2UnicodeInputStream;
import COM.ibm.db2.jdbc.app.DB2Blob;
import COM.ibm.db2.jdbc.app.DB2CharReader;
import COM.ibm.db2.jdbc.app.DB2Clob;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaDataTrace;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.DB2UnicodeStream;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2ResultSet
implements ResultSet {
    private Hashtable name2Index;
    private DB2ResultSetMetaData rsMetaData;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected SQLExceptionGenerator sqlExcptGen;
    protected int numCols = 0;
    protected boolean mappedRS = false;
    protected boolean nullTag = true;
    protected boolean closed = false;
    protected Vector isList = new Vector();
    protected int currentRowId = 0;
    private int year = 0;
    private int month = 0;
    private int date = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private int nano = 0;
    private int sqlSuccess = 0;
    protected int maxFieldSize;
    protected int[] colTypes = null;
    protected int[] colSizes = null;
    protected String[] mappedColumnNames = null;
    protected int returnCode = 0;
    protected int returnLen = 0;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int maxRows = 0;

    public DB2ResultSet(DB2Statement dB2Statement, int n) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2ResultSet( stmt, nCols=" + n + ")");
            }
            this.statement = dB2Statement;
            this.connection = this.statement.getDB2Connection();
            this.maxFieldSize = this.statement.maxFieldSize;
            this.fetchSize = this.statement.fetchSize;
            this.fetchDirection = this.statement.fetchDirection;
            this.numCols = this.getColCount();
            this.nullTag = true;
            this.closed = false;
            this.mappedRS = false;
            this.rsMetaData = null;
            this.name2Index = null;
            this.colTypes = new int[this.numCols];
            this.colSizes = new int[this.numCols];
            int n2 = 0;
            while (n2 < this.numCols) {
                this.colTypes[n2] = 0;
                this.colSizes[n2] = 0;
                ++n2;
            }
            this.sqlExcptGen = dB2Statement.sqlExcptGen;
        }
        finally {
            Object var4_4 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "numCols", this.numCols);
                DB2Trace.methodExit(this, "DB2ResultSet()");
            }
        }
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        this(dB2Statement, n);
        this.numCols = n2;
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n, int n2, String[] stringArray) throws SQLException {
        this(dB2Statement, n);
        this.mappedColumnNames = stringArray;
        this.numCols = n2;
    }

    protected native int SQLFetch(int var1);

    protected native int SQLFetchScroll(int var1, int var2, int var3, int var4);

    protected native int SQLFreeStmtClose(int var1);

    protected native int SQLGetColumnCount(int var1);

    protected native String SQLGetCursorName(int var1, int var2);

    protected native int SQLGetDateData(int var1, int var2);

    protected native double SQLGetDoubleData(int var1, int var2);

    protected native float SQLGetFloatData(int var1, int var2);

    protected native int SQLGetIntegerData(int var1, int var2);

    protected native int SQLGetLocator(int var1, int var2, Integer var3, int var4);

    protected native byte[] SQLGetLongBinaryData(int var1, int var2, int var3, int var4, int var5);

    protected native byte[] SQLGetLongCharData(int var1, int var2, int var3);

    protected native long SQLGetLongData(int var1, int var2);

    protected native String SQLGetNumericStringData(int var1, int var2);

    protected native byte[] SQLGetRowDataInternal(int var1);

    protected native int SQLGetSmallIntData(int var1, int var2);

    protected native String SQLGetStringData(int var1, int var2, int var3, int var4, int var5);

    protected native int SQLGetTimeData(int var1, int var2);

    protected native int SQLGetTimestampData(int var1, int var2);

    protected native int SQLGetType(int var1, int var2, int var3);

    protected native int SQLSetPos(int var1, int var2, int var3, int var4);

    public boolean absolute(int n) throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    protected void addIsList(DB2InputStream dB2InputStream) {
        if (dB2InputStream != null) {
            this.isList.addElement(dB2InputStream);
        }
    }

    protected void addWarning(SQLWarning sQLWarning) {
        this.statement.addWarning(sQLWarning);
    }

    public void afterLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
    }

    public void beforeFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
    }

    public void cancelRowUpdates() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    protected void clearIsList() throws SQLException {
        if (!this.isList.isEmpty()) {
            Enumeration enumeration = this.isList.elements();
            while (enumeration.hasMoreElements()) {
                DB2InputStream dB2InputStream = (DB2InputStream)enumeration.nextElement();
                dB2InputStream.close();
            }
            this.isList.removeAllElements();
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.statement.warnings = null;
    }

    public void close() throws SQLException {
        if (!this.closed) {
            this.close2(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close2(boolean bl) throws SQLException {
        block19: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "close2( " + bl + " )");
                }
                if (this.closed) {
                    Object var3_2 = null;
                    if (!DB2Trace.TraceOn) return;
                    DB2Trace.methodExit(this, "close2()");
                    return;
                }
                this.closed = true;
                if (this.statement == null) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(5, "statement is null");
                    }
                    Object var3_3 = null;
                    if (!DB2Trace.TraceOn) return;
                    DB2Trace.methodExit(this, "close2()");
                    return;
                }
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    if (this.statement.closed) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "statement is closed");
                        }
                        Object var5_10 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 14] lbl27 : MonitorExitStatement: MONITOREXIT : var4_9
                        Object var3_4 = null;
                        if (!DB2Trace.TraceOn) return;
                        DB2Trace.methodExit(this, "close2()");
                        return;
                    }
                    if (this.connection == null) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(20, "connection is null");
                        }
                        Object var5_11 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 12] lbl38 : MonitorExitStatement: MONITOREXIT : var4_9
                        Object var3_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        DB2Trace.methodExit(this, "close2()");
                        return;
                    }
                    DB2Connection dB2Connection = this.connection;
                    synchronized (dB2Connection) {
                        int n;
                        if (this.connection.closed) {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(25, "connection is closed");
                            }
                            Object var7_14 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 4, 10] lbl52 : MonitorExitStatement: MONITOREXIT : var6_13
                            Object var5_12 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 10] lbl55 : MonitorExitStatement: MONITOREXIT : var4_9
                            Object var3_6 = null;
                            if (!DB2Trace.TraceOn) return;
                            DB2Trace.methodExit(this, "close2()");
                            return;
                        }
                        this.clearIsList();
                        if ((!this.connection.SPConnected || this.connection.SPConnected && bl) && (n = this.SQLFreeStmtClose(this.statement.statementHandle)) != this.sqlSuccess) {
                            this.sqlExcptGen.check_return_code(this.statement, n);
                        }
                    }
                }
                if (!this.statement.internalStmt) break block19;
                this.statement.close2(true);
            }
            catch (Throwable throwable) {
                Object var3_8 = null;
                if (!DB2Trace.TraceOn) throw throwable;
                DB2Trace.methodExit(this, "close2()");
                throw throwable;
            }
        }
        Object var3_7 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "close2()");
    }

    protected static String cvtScientific(String string) throws NumberFormatException {
        char c;
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < n) {
            c = string.charAt(n6);
            if (n2 < 0) {
                if (!Character.isWhitespace(c)) {
                    n2 = n5 = n6;
                    if (c == '.' || c == ',') {
                        n3 = n6;
                    }
                }
            } else if (n3 < 0 && n4 < 0 && (c == ',' || c == '.')) {
                n3 = n5 = n6;
            } else if (n4 < 0 && (c == 'e' || c == 'E')) {
                n4 = n5 = n6;
            } else if (!Character.isWhitespace(c)) {
                n5 = n6;
            }
            ++n6;
        }
        if (n2 < 0) {
            return "";
        }
        if (n4 < 0) {
            if (n2 > 0 || n5 < n - 1) {
                string = string.substring(n2, n5 + 1);
            }
            if (n3 >= 0 && string.charAt(n3) == ',') {
                string = string.replace(',', '.');
            }
        } else {
            int n7 = 1;
            int n8 = 0;
            n6 = n4 + 1;
            c = string.charAt(n6);
            if (c == '-') {
                n7 = -1;
                ++n6;
            } else if (c == '+') {
                ++n6;
            }
            while (n6 <= n5) {
                if (!Character.isDigit(c = string.charAt(n6++))) {
                    throw new NumberFormatException();
                }
                n8 = n8 * 10 + Character.digit(c, 10);
            }
            n8 *= n7;
            if (n3 >= 0) {
                n8 -= n4 - n3 - 1;
            }
            if ((c = string.charAt(n2)) == '-') {
                n7 = -1;
                ++n2;
            } else if (c == '+') {
                n7 = 1;
                ++n2;
            } else {
                n7 = 1;
            }
            int n9 = n4 - n2 - (n3 >= 0 ? 1 : 0);
            int n10 = 0;
            int n11 = -1;
            int n12 = 0;
            if (n8 >= 0) {
                n11 = -1;
                n10 = 0;
                n12 = n9 + n8;
            } else if (n8 < 0 && -n8 >= n9) {
                n11 = 0;
                n10 = -n8 - n9 + 1;
                n12 = n10 + n9;
            } else {
                n11 = n9 + n8;
                n10 = 0;
                n12 = n9 + 1;
            }
            if (n7 < 0) {
                if (n11 >= 0) {
                    ++n11;
                }
                ++n10;
                ++n12;
            }
            char[] cArray = new char[n12];
            n6 = 0;
            while (n6 < n12) {
                cArray[n6] = 48;
                ++n6;
            }
            if (n7 < 0) {
                cArray[0] = 45;
            }
            if (n11 >= 0) {
                cArray[n11] = 46;
            }
            n6 = n10;
            int n13 = n2;
            while (n13 < n4) {
                if (n13 == n3 && ++n13 >= n4) break;
                if (n6 == n11) {
                    ++n6;
                }
                cArray[n6] = string.charAt(n13);
                ++n6;
                ++n13;
            }
            string = new String(cArray);
        }
        return string;
    }

    public void deleteRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public int findColumn(String string) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n = 0;
        int n2 = 0;
        if (this.rsMetaData == null) {
            this.rsMetaData = this.getMetaData2();
        }
        string = string.toUpperCase(Locale.US);
        if (this.name2Index == null) {
            n2 = this.statement.colCount4JSQL > 0 ? this.statement.colCount4JSQL : this.rsMetaData.getColumnCount();
            this.name2Index = new Hashtable((int)((double)n2 / 0.75 + 0.7));
            int n3 = 1;
            while (n3 <= n2) {
                String string2 = this.statement.colCount4JSQL > 0 ? this.statement.colNames4JSQL[n3 - 1] : this.rsMetaData.getColumnName(n3);
                if (string2 != null && !this.name2Index.containsKey(string2 = string2.toUpperCase(Locale.US))) {
                    this.name2Index.put(string2, new Integer(n3));
                    if (string2.equals(string)) {
                        n = n3;
                    }
                }
                ++n3;
            }
        } else {
            Integer n4 = (Integer)this.name2Index.get(string);
            if (n4 != null) {
                return n4;
            }
        }
        if (n == 0) {
            this.sqlExcptGen.rsException("S0022");
        }
        return n;
    }

    public boolean first() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public Array getArray(int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array Type");
        return null;
    }

    public Array getArray(String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Array Type");
        return null;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getAsciiStream2(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream2(this.findColumn(string));
    }

    protected InputStream getAsciiStream2(int n) throws SQLException {
        int n2 = 41;
        int n3 = this.getColType(n, true);
        if (n3 == -99 || n3 == -98 || n3 == -350) {
            switch (n3) {
                case -99: {
                    n2 = 41;
                    break;
                }
                case -98: {
                    n2 = 31;
                    break;
                }
                case -350: {
                    n2 = -351;
                    break;
                }
            }
            Integer n4 = new Integer(this.sqlSuccess);
            int n5 = this.SQLGetLocator(n, n2, n4, this.statement.statementHandle);
            int n6 = n4;
            if (n6 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n6);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                if (n2 != 31) {
                    DB2InputStream dB2InputStream = new DB2InputStream(this.statement, n5, n2);
                    this.addIsList(dB2InputStream);
                    return dB2InputStream;
                }
                DB2Binary2AsciiInputStream dB2Binary2AsciiInputStream = new DB2Binary2AsciiInputStream(this.statement, n5, n2);
                this.addIsList(dB2Binary2AsciiInputStream);
                return dB2Binary2AsciiInputStream;
            }
            this.nullTag = true;
            return null;
        }
        byte[] byArray = this.getAsciiString(n);
        if (byArray != null) {
            this.nullTag = false;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
        this.nullTag = true;
        return null;
    }

    protected byte[] getAsciiString(int n) throws SQLException {
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        byte[] byArray = this.SQLGetLongCharData(n, this.statement.statementHandle, this.connection.connectionHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        if (this.maxFieldSize == 0 || byArray.length <= this.maxFieldSize) {
            return byArray;
        }
        byte[] byArray2 = new byte[this.maxFieldSize];
        System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
        return byArray2;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBigDecimal2(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBigDecimal2(n, n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal2(this.findColumn(string), n);
    }

    protected BigDecimal getBigDecimal2(int n) throws SQLException {
        int n2 = this.getColType(n, false);
        if (n2 == -2 || n2 == -3 || n2 == -4 || n2 == 91 || n2 == 92 || n2 == 93) {
            this.sqlExcptGen.rsException("07006");
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        String string = this.SQLGetNumericStringData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen != -1) {
            this.nullTag = false;
            BigDecimal bigDecimal = null;
            try {
                string = DB2ResultSet.cvtScientific(string);
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.sqlExcptGen.rsException("22005");
            }
            return bigDecimal;
        }
        this.nullTag = true;
        return null;
    }

    protected BigDecimal getBigDecimal2(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal2(n);
        if (bigDecimal == null || n2 == -1) {
            return bigDecimal;
        }
        return bigDecimal.setScale(n2, 4);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBinaryStream2(n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream2(this.findColumn(string));
    }

    protected InputStream getBinaryStream2(int n) throws SQLException {
        int n2 = 41;
        int n3 = this.getColType(n, true);
        if (n3 == -99 || n3 == -98 || n3 == -350) {
            switch (n3) {
                case -99: {
                    n2 = 41;
                    break;
                }
                case -98: {
                    n2 = 31;
                    break;
                }
                case -350: {
                    n2 = -351;
                    break;
                }
            }
            Integer n4 = new Integer(this.sqlSuccess);
            int n5 = this.SQLGetLocator(n, n2, n4, this.statement.statementHandle);
            int n6 = n4;
            if (n6 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n6);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                DB2InputStream dB2InputStream = new DB2InputStream(this.statement, n5, n2);
                this.addIsList(dB2InputStream);
                return dB2InputStream;
            }
            this.nullTag = true;
            return null;
        }
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public Blob getBlob(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n2 = 31;
        int n3 = this.getColType(n, false);
        if (n3 == -98) {
            n2 = 31;
            Integer n4 = new Integer(this.sqlSuccess);
            int n5 = this.SQLGetLocator(n, n2, n4, this.statement.statementHandle);
            int n6 = n4;
            if (n6 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n6);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                return new DB2Blob(this.statement, n5, n2);
            }
            this.nullTag = true;
            return null;
        }
        this.sqlExcptGen.rsException("22005");
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBoolean2(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean2(this.findColumn(string));
    }

    protected boolean getBoolean2(int n) throws SQLException {
        short s;
        String string;
        boolean bl = false;
        if (this.colTypes[n - 1] == 0) {
            this.getColType(n, false);
        }
        bl = this.colTypes[n - 1] == 1 || this.colTypes[n - 1] == 12 || this.colTypes[n - 1] == -1 || this.colTypes[n - 1] == -99 ? ((string = this.getString(n)) == null ? false : ((string = string.trim()).equals("1") ? true : new Boolean(string))) : (s = this.getShort2(n)) != 0;
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getByte2(n);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte2(this.findColumn(string));
    }

    protected byte getByte2(int n) throws SQLException {
        return (byte)this.getShort2(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBytes2(n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes2(this.findColumn(string));
    }

    protected byte[] getBytes2(int n) throws SQLException {
        if (this.colTypes[n - 1] == 0) {
            this.getColType(n, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 0;
        byte[] byArray = this.SQLGetLongBinaryData(n, this.colTypes[n - 1], this.colSizes[n - 1], this.statement.statementHandle, this.connection.connectionHandle);
        if (this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        if (this.maxFieldSize == 0 || byArray.length <= this.maxFieldSize) {
            return byArray;
        }
        byte[] byArray2 = new byte[this.maxFieldSize];
        System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
        return byArray2;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        int n2;
        int n3;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if ((n3 = this.getColType(n, false)) != -99 && n3 != -350 && n3 != -98) {
            return new StringReader(this.getString(n));
        }
        if (n3 == -99) {
            n2 = 41;
        } else {
            n2 = -351;
            if (n3 == -98) {
                this.sqlExcptGen.rsException("22005");
            }
        }
        Integer n4 = new Integer(this.sqlSuccess);
        int n5 = this.SQLGetLocator(n, n2, n4, this.statement.statementHandle);
        int n6 = n4;
        if (n6 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, n6);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        return new DB2CharReader(this.statement, n2, n5);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n2 = 41;
        int n3 = this.getColType(n, false);
        if (n3 == -99 || n3 == -350) {
            n2 = n3 == -99 ? 41 : -351;
            Integer n4 = new Integer(this.sqlSuccess);
            int n5 = this.SQLGetLocator(n, n2, n4, this.statement.statementHandle);
            int n6 = n4;
            if (n6 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n6);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                return new DB2Clob(this.statement, n5, n2);
            }
            this.nullTag = true;
            return null;
        }
        this.sqlExcptGen.rsException("22005");
        return null;
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    protected int getColCount() throws SQLException {
        int n = this.SQLGetColumnCount(this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getColType(int n, boolean bl) throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getColType( " + n + ", " + bl + " ) ");
            }
            if (this.colTypes != null) {
                n3 = this.colTypes[n - 1];
            }
            if (n3 == 0) {
                int n4 = 0;
                if (bl) {
                    n4 = 1;
                }
                this.returnCode = this.sqlSuccess;
                this.returnLen = 0;
                n3 = this.SQLGetType(n, n4, this.statement.statementHandle);
                if (this.returnCode != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "sqlType", n3);
                }
                if (n3 == -450) {
                    if (this.rsMetaData == null) {
                        this.rsMetaData = this.getMetaData2();
                    }
                    if (this.rsMetaData.colBaseTypesNotAdjusted == null || this.rsMetaData.colBaseTypesNotAdjusted[n - 1] == -99999) {
                        this.rsMetaData.getColumnType(n);
                    }
                    n3 = this.rsMetaData.colBaseTypesNotAdjusted[n - 1];
                }
                switch (n3) {
                    case -97: 
                    case -10: {
                        n3 = -1;
                        break;
                    }
                    case -95: 
                    case -8: {
                        n3 = 1;
                        break;
                    }
                    case -96: 
                    case -9: {
                        n3 = 12;
                        break;
                    }
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "sqlType", n3);
                    DB2Trace.data(20, "returnLen", this.returnLen);
                }
                this.colTypes[n - 1] = n3;
                this.colSizes[n - 1] = this.returnLen;
            }
            n2 = n3;
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getColType()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getColType()", n3);
        return n2;
    }

    public int getConcurrency() throws SQLException {
        return this.rsConcur;
    }

    public String getCursorName() throws SQLException {
        String string;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLGetCursorName(this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return string;
    }

    public synchronized byte[] getDB2RowData() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        byte[] byArray = this.SQLGetRowDataInternal(this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate2(n, Calendar.getInstance());
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate2(n, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate2(this.findColumn(string), calendar);
    }

    protected Date getDate2(int n) throws SQLException {
        return this.getDate2(n, Calendar.getInstance());
    }

    protected Date getDate2(int n, Calendar calendar) throws SQLException {
        Date date = null;
        this.nullTag = true;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDate2(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.numCols) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            this.returnCode = this.sqlSuccess;
            this.returnLen = this.sqlSuccess;
            this.year = this.SQLGetDateData(n, this.statement.statementHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
            }
            if (this.returnLen != -1) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Year from DB", this.year);
                    DB2Trace.data(10, "Month from DB (1 less)", this.month);
                    DB2Trace.data(10, "Date from DB", this.date);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(1, this.year + 1900);
                calendar.set(2, this.month);
                calendar.set(5, this.date);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                date = new Date(calendar.getTime().getTime());
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Date", date.toString());
                }
                this.nullTag = false;
            } else {
                this.nullTag = true;
            }
            Date date2 = date;
            Object var6_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getDate2()", date == null ? "NULL" : date.toString());
            }
            return date2;
        }
        catch (Throwable throwable) {
            block12: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block12;
                DB2Trace.methodExit((Object)this, "getDate2()", date == null ? "NULL" : date.toString());
            }
            throw throwable;
        }
    }

    public double getDouble(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getDouble2(n);
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble2(this.findColumn(string));
    }

    protected double getDouble2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        double d = this.SQLGetDoubleData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return d;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        if (this.fetchSize > 0) {
            return this.fetchSize;
        }
        return 1;
    }

    public float getFloat(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getFloat2(n);
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat2(this.findColumn(string));
    }

    protected float getFloat2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        float f = this.SQLGetFloatData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return f;
    }

    public int getInt(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getInt2(n);
    }

    public int getInt(String string) throws SQLException {
        return this.getInt2(this.findColumn(string));
    }

    protected int getInt2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        int n2 = this.SQLGetIntegerData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return n2;
    }

    public long getLong(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getLong2(n);
    }

    public long getLong(String string) throws SQLException {
        return this.getLong2(this.findColumn(string));
    }

    protected long getLong2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        long l = this.SQLGetLongData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return l;
    }

    protected int getMappedColumn(int n) throws SQLException {
        return n;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.rsMetaData != null) {
            return this.rsMetaData;
        }
        return this.getMetaData2();
    }

    public DB2ResultSetMetaData getMetaData2() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.rsMetaData = DB2Trace.TraceOn ? new DB2ResultSetMetaDataTrace(this.statement, this, this.numCols, this.mappedRS) : new DB2ResultSetMetaData(this.statement, this, this.numCols, this.mappedRS);
        return this.rsMetaData;
    }

    public Object getObject(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n2 = this.getColType(n, true);
        return this.getObject(n, n2);
    }

    protected Object getObject(int n, int n2) throws SQLException {
        return this.getObject(n, n2, -1);
    }

    protected Object getObject(int n, int n2, int n3) throws SQLException {
        Object object = null;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                object = this.getBigDecimal(n, n3);
                break;
            }
            case -7: {
                boolean bl = this.getBoolean(n);
                if (this.wasNull()) break;
                object = new Boolean(bl);
                break;
            }
            case -6: {
                short s = this.getShort(n);
                if (this.wasNull()) break;
                object = new Integer(s);
                break;
            }
            case 5: {
                short s = this.getShort(n);
                if (this.wasNull()) break;
                object = new Integer(s);
                break;
            }
            case 4: {
                int n4 = this.getInt(n);
                if (this.wasNull()) break;
                object = new Integer(n4);
                break;
            }
            case -5: {
                long l = this.getLong(n);
                if (this.wasNull()) break;
                object = new Long(l);
                break;
            }
            case 6: 
            case 7: {
                float f = this.getFloat(n);
                if (this.wasNull()) break;
                object = new Float(f);
                break;
            }
            case 8: {
                double d = this.getDouble(n);
                if (this.wasNull()) break;
                object = new Double(d);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
                break;
            }
            case -98: {
                object = this.getBlob(n);
                break;
            }
            case -350: 
            case -99: {
                object = this.getClob(n);
                break;
            }
            default: {
                this.sqlExcptGen.rsException("22005");
            }
        }
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    protected Object getObject(String string, int n) throws SQLException {
        return this.getObject(this.findColumn(string), n);
    }

    protected Object getObject(String string, int n, int n2) throws SQLException {
        return this.getObject(this.findColumn(string), n, n2);
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRow() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getRow()");
            }
            n = this.currentRowId;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getRow()", this.currentRowId);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getRow()", this.currentRowId);
        return n;
    }

    public short getShort(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getShort2(n);
    }

    public short getShort(String string) throws SQLException {
        return this.getShort2(this.findColumn(string));
    }

    protected short getShort2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        int n2 = this.SQLGetSmallIntData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return (short)n2;
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    protected DB2Statement getStmt() {
        return this.statement;
    }

    public String getString(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getString2(n);
    }

    public String getString(String string) throws SQLException {
        return this.getString2(this.findColumn(string));
    }

    protected String getString2(int n) throws SQLException {
        String string;
        if (this.colTypes[n - 1] == 0) {
            this.getColType(n, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 1;
        Object object = this.connection;
        synchronized (object) {
            string = this.SQLGetStringData(n, this.colTypes[n - 1], this.colSizes[n - 1], this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
            return null;
        }
        if (this.returnLen == 0) {
            string = "";
        } else if (this.colTypes[n - 1] == -400) {
            object = new StringTokenizer(string, ",");
            String string2 = ((StringTokenizer)object).nextToken();
            string2 = ((StringTokenizer)object).nextToken();
            string2 = ((StringTokenizer)object).nextToken();
            int n2 = Integer.parseInt(string2);
            int n3 = string.lastIndexOf(44) + 1;
            string = string.substring(n3, n3 + n2);
        }
        this.nullTag = false;
        if (this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
            string = new String(string.substring(0, this.maxFieldSize));
        }
        return string;
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime2(n, Calendar.getInstance());
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime2(n, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime2(this.findColumn(string), calendar);
    }

    protected Time getTime2(int n) throws SQLException {
        return this.getTime2(n, Calendar.getInstance());
    }

    protected Time getTime2(int n, Calendar calendar) throws SQLException {
        Time time = null;
        this.nullTag = true;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTime2(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.numCols) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            this.returnCode = this.sqlSuccess;
            this.returnLen = this.sqlSuccess;
            this.hour = this.SQLGetTimeData(n, this.statement.statementHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
            }
            if (this.returnLen != -1) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Hour", this.hour);
                    DB2Trace.data(10, "Minute", this.minute);
                    DB2Trace.data(10, "Second", this.second);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(1, 1970);
                calendar.set(2, 0);
                calendar.set(5, 1);
                calendar.set(11, this.hour);
                calendar.set(12, this.minute);
                calendar.set(13, this.second);
                calendar.set(14, 0);
                time = new Time(calendar.getTime().getTime());
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Time", time.toString());
                }
                this.nullTag = false;
            } else {
                this.nullTag = true;
            }
            Time time2 = time;
            Object var6_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTime2()", time == null ? "NULL" : time.toString());
            }
            return time2;
        }
        catch (Throwable throwable) {
            block12: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block12;
                DB2Trace.methodExit((Object)this, "getTime2()", time == null ? "NULL" : time.toString());
            }
            throw throwable;
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp2(n, Calendar.getInstance());
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp2(n, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp2(this.findColumn(string), calendar);
    }

    protected Timestamp getTimestamp2(int n) throws SQLException {
        return this.getTimestamp2(n, Calendar.getInstance());
    }

    protected Timestamp getTimestamp2(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        this.nullTag = true;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimestamp2(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.numCols) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            if ((n2 = this.getColType(n, false)) == 92) {
                this.sqlExcptGen.rsException("07006");
            }
            this.returnCode = this.sqlSuccess;
            this.returnLen = this.sqlSuccess;
            this.year = this.SQLGetTimestampData(n, this.statement.statementHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
            }
            if (this.returnLen != -1) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Year", this.year);
                    DB2Trace.data(10, "Month", this.month);
                    DB2Trace.data(10, "Date", this.date);
                    DB2Trace.data(10, "Hour", this.hour);
                    DB2Trace.data(10, "Minute", this.minute);
                    DB2Trace.data(10, "Second", this.second);
                    DB2Trace.data(10, "Nano", this.nano);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(1, this.year + 1900);
                calendar.set(2, this.month);
                calendar.set(5, this.date);
                calendar.set(11, this.hour);
                calendar.set(12, this.minute);
                calendar.set(13, this.second);
                calendar.set(14, 0);
                timestamp = new Timestamp(calendar.getTime().getTime());
                timestamp.setNanos(this.nano);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Timestamp", timestamp.toString());
                }
                this.nullTag = false;
            } else {
                this.nullTag = true;
            }
            Timestamp timestamp2 = timestamp;
            Object var6_6 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTimestamp2()", timestamp == null ? "NULL" : timestamp.toString());
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            block13: {
                Object var6_7 = null;
                if (!DB2Trace.TraceOn) break block13;
                DB2Trace.methodExit((Object)this, "getTimestamp2()", timestamp == null ? "NULL" : timestamp.toString());
            }
            throw throwable;
        }
    }

    protected String getTraceHandle() {
        String string = "??";
        if (this.statement != null) {
            string = this.statement.getTraceHandle();
        }
        return string;
    }

    public int getType() throws SQLException {
        return this.rsType;
    }

    protected byte[] getUniString(int n) throws SQLException {
        String string = null;
        if (this.colTypes[n - 1] == 0) {
            this.getColType(n, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 1;
        Object object = this.connection;
        synchronized (object) {
            string = this.SQLGetStringData(n, this.colTypes[n - 1], this.colSizes[n - 1], this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1 || this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnLen == 0) {
            string = "";
        }
        this.nullTag = false;
        object = null;
        try {
            object = this.maxFieldSize == 0 || string.length() <= this.maxFieldSize ? (Object)string.getBytes("UTF8") : (Object)string.substring(0, this.maxFieldSize).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return object;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getUnicodeStream2(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream2(this.findColumn(string));
    }

    protected InputStream getUnicodeStream2(int n) throws SQLException {
        int n2 = 41;
        int n3 = this.getColType(n, true);
        if (n3 == -99 || n3 == -98 || n3 == -350) {
            switch (n3) {
                case -99: {
                    n2 = 41;
                    break;
                }
                case -98: {
                    n2 = 31;
                    break;
                }
                case -350: {
                    n2 = -351;
                    break;
                }
            }
            Integer n4 = new Integer(this.sqlSuccess);
            int n5 = this.SQLGetLocator(n, n2, n4, this.statement.statementHandle);
            int n6 = n4;
            if (n6 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n6);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                DB2InputStream dB2InputStream = null;
                switch (n2) {
                    case -351: 
                    case 41: {
                        dB2InputStream = new DB2UnicodeStream(this.statement, n5, n2);
                        break;
                    }
                    case 31: {
                        dB2InputStream = new DB2Binary2UnicodeInputStream(this.statement, n5, n2);
                    }
                }
                this.addIsList(dB2InputStream);
                return dB2InputStream;
            }
            this.nullTag = true;
            return null;
        }
        byte[] byArray = this.getUniString(n);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.statement.warnings;
    }

    public void insertRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public boolean isAfterLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isBeforeFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    public boolean isFirst() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean isLast() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public boolean last() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public void moveToCurrentRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void moveToInsertRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public boolean next() throws SQLException {
        boolean bl;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.clearIsList();
        this.clearWarnings();
        int n = this.SQLFetch(this.statement.statementHandle);
        if (n != 100) {
            if (n != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n);
            }
            this.closed = false;
            bl = true;
            ++this.currentRowId;
        } else {
            bl = false;
            this.currentRowId = 0;
        }
        return bl;
    }

    public boolean previous() throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    public void refreshRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public boolean relative(int n) throws SQLException {
        this.sqlExcptGen.throwNotScrollable();
        return false;
    }

    protected void reset(int n) throws SQLException {
        block6: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "reset( " + n + ") ");
                }
                this.numCols = this.statement.moreResults ? this.getColCount() : 0;
                this.nullTag = true;
                this.closed = false;
                this.mappedRS = false;
                this.name2Index = null;
                this.colTypes = new int[this.numCols];
                this.colSizes = new int[this.numCols];
                int n2 = 0;
                while (n2 < this.numCols) {
                    this.colTypes[n2] = 0;
                    this.colSizes[n2] = 0;
                    ++n2;
                }
                if (this.rsMetaData == null) break block6;
                this.rsMetaData.numberOfColumns = this.numCols;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "reset()");
                }
                throw throwable;
            }
        }
        Object var3_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "reset()");
        }
    }

    protected void reset(int n, int n2) throws SQLException {
        this.reset(n);
    }

    protected void resetRows(int n) throws SQLException {
    }

    public boolean rowDeleted() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
        return false;
    }

    protected void setClosed(boolean bl) {
        this.closed = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.statement.checkFetchDirection(this.rsType, n);
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.statement.checkFetchSize(this.maxRows, n);
        this.fetchSize = n;
    }

    public String toString() {
        return this.toString("", true);
    }

    protected String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2ResultSet \r\n" + string + "{");
        if (bl) {
            if (this.statement != null) {
                stringBuffer.append(String.valueOf(this.statement.toString(String.valueOf(string) + "    Statement -> ", false)) + "\r\n");
            } else {
                stringBuffer.append(String.valueOf(string) + "    Statement -> null\r\n    ");
            }
        } else {
            stringBuffer.append("\r\n");
        }
        stringBuffer.append(String.valueOf(string) + "    numCols = " + this.numCols + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    mappedRS = " + this.mappedRS + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    nullTag = " + this.nullTag + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    closed = " + this.closed + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxFieldSize = " + this.maxFieldSize + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    returnCode = " + this.returnCode + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    returnLen = " + this.returnLen + "\r\n");
        int n = 0;
        while (n < this.numCols) {
            stringBuffer.append(String.valueOf(string) + "    colTypes[" + n + "] = " + this.colTypes[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    colSizes[" + n + "] = " + this.colSizes[n] + "\r\n");
            ++n;
        }
        stringBuffer.append(String.valueOf(string) + "}\r\n");
        return stringBuffer.toString();
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateInt(String string, int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateLong(int n, long l) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateLong(String string, long l) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateNull(int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateNull(String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateRow() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateShort(int n, short s) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateShort(String string, short s) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateString(int n, String string) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateString(String string, String string2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("Updatable Result Set");
    }

    public boolean wasNull() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.nullTag;
    }
}

