/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.exolab.castor.net.util.URIUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDResolver
implements EntityResolver {
    private final DTDInfo[] _dtdInfo = new DTDInfo[]{new DTDInfo("-//EXOLAB/Castor Mapping DTD Version 1.0//EN", "http://castor.exolab.org/mapping.dtd", "castor.exolab.org", "castor", "/org/exolab/castor/mapping/mapping.dtd"), new DTDInfo("-//EXOLAB/Castor Mapping Schema Version 1.0//EN", "http://castor.exolab.org/mapping.xsd", "castor.exolab.org", "castor", "/org/exolab/castor/mapping/mapping.xsd"), new DTDInfo("-//EXOLAB/Castor JDO Configuration DTD Version 1.0//EN", "http://castor.exolab.org/jdo-conf.dtd", "castor.exolab.org", "castor", "/org/exolab/castor/jdo/conf/jdo-conf.dtd"), new DTDInfo("-//EXOLAB/Castor JDO Configuration Schema Version 1.0//EN", "http://castor.exolab.org/jdo-conf.xsd", "castor.exolab.org", "castor", "/org/exolab/castor/jdo/conf/jdo-conf.xsd"), new DTDInfo("-//W3C//DTD XMLSCHEMA 19991216//EN", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000225/structures.dtd", null, null, "/org/exolab/castor/util/resources/structures.dtd"), new DTDInfo(null, "http://www.w3.org/TR/2000/WD-xmlschema-2-20000225/datatypes.dtd", null, null, "/org/exolab/castor/util/resources/datatypes.dtd"), new DTDInfo(null, "http://www.w3.org/TR/2000/WD-xmlschema-1-20000225/structures.xsd", null, null, "/org/exolab/castor/util/resources/structures.xsd")};
    private EntityResolver _resolver;
    private URL _baseUrl;

    public DTDResolver(EntityResolver resolver) {
        this._resolver = resolver;
    }

    public DTDResolver() {
    }

    public void setBaseURL(URL baseUrl) {
        this._baseUrl = baseUrl;
    }

    public URL getBaseURL() {
        return this._baseUrl;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        InputSource source = null;
        for (int i = 0; i < this._dtdInfo.length; ++i) {
            if (publicId != null && publicId.equals(this._dtdInfo[i].publicId)) {
                source = new InputSource(this.getClass().getResourceAsStream(this._dtdInfo[i].resource));
                source.setPublicId(publicId);
                return source;
            }
            if (systemId == null || !systemId.equals(this._dtdInfo[i].systemId)) continue;
            source = new InputSource(this.getClass().getResourceAsStream(this._dtdInfo[i].resource));
            source.setSystemId(systemId);
            return source;
        }
        if (this._resolver != null && (source = this._resolver.resolveEntity(publicId, systemId)) != null) {
            return source;
        }
        if (systemId != null && this._baseUrl != null) {
            try {
                URL url = new URL(this._baseUrl, systemId);
                source = new InputSource(url.openStream());
                source.setSystemId(systemId);
                return source;
            }
            catch (MalformedURLException except) {
                try {
                    String absURL = URIUtils.resolveAsString(systemId, this._baseUrl.toString());
                    URL url = new URL(absURL);
                    source = new InputSource(url.openStream());
                    source.setSystemId(systemId);
                    return source;
                }
                catch (MalformedURLException ex2) {
                }
            }
            catch (FileNotFoundException fnfe) {
                try {
                    String absURL = URIUtils.resolveAsString(systemId, this._baseUrl.toString());
                    URL url = new URL(absURL);
                    source = new InputSource(url.openStream());
                    source.setSystemId(systemId);
                    return source;
                }
                catch (MalformedURLException ex2) {
                    // empty catch block
                }
            }
            return null;
        }
        return null;
    }

    static class DTDInfo {
        final String publicId;
        final String systemId;
        final String resource;
        final String namespace;
        final String prefix;

        DTDInfo(String publicId, String systemId, String namespace, String prefix, String resource) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.resource = resource;
            this.namespace = namespace;
            this.prefix = prefix;
        }
    }
}

