/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.Grant;
import com.aliyun.oss.model.GroupGrantee;
import com.aliyun.oss.model.Permission;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class BucketAclTest
extends TestBase {
    private static final CannedAccessControlList[] acls;

    static {
        CannedAccessControlList[] cannedAccessControlListArray = new CannedAccessControlList[4];
        cannedAccessControlListArray[1] = CannedAccessControlList.Private;
        cannedAccessControlListArray[2] = CannedAccessControlList.PublicRead;
        cannedAccessControlListArray[3] = CannedAccessControlList.PublicReadWrite;
        acls = cannedAccessControlListArray;
    }

    @Test
    public void testNormalSetBucketAcl() {
        String bucketName = "normal-set-bucket-acl";
        try {
            try {
                secondClient.createBucket("normal-set-bucket-acl");
                CannedAccessControlList[] cannedAccessControlListArray = acls;
                int n = acls.length;
                int n2 = 0;
                while (n2 < n) {
                    CannedAccessControlList acl = cannedAccessControlListArray[n2];
                    secondClient.setBucketAcl("normal-set-bucket-acl", acl);
                    AccessControlList returnedAcl = secondClient.getBucketAcl("normal-set-bucket-acl");
                    if (acl != null && !acl.equals((Object)CannedAccessControlList.Private)) {
                        Set<Grant> grants = returnedAcl.getGrants();
                        Assert.assertEquals((int)1, (int)grants.size());
                        Grant grant = (Grant)grants.toArray()[0];
                        if (acl.equals((Object)CannedAccessControlList.PublicRead)) {
                            Assert.assertEquals((Object)GroupGrantee.AllUsers, (Object)grant.getGrantee());
                            Assert.assertEquals((Object)((Object)Permission.Read), (Object)((Object)grant.getPermission()));
                        } else if (acl.equals((Object)CannedAccessControlList.PublicReadWrite)) {
                            Assert.assertEquals((Object)GroupGrantee.AllUsers, (Object)grant.getGrantee());
                            Assert.assertEquals((Object)((Object)Permission.FullControl), (Object)((Object)grant.getPermission()));
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("normal-set-bucket-acl");
            }
        }
        finally {
            secondClient.deleteBucket("normal-set-bucket-acl");
        }
    }

    @Test
    public void testUnormalSetBucketAcl() {
        String bucketName = "unormal-set-bucket-acl";
        try {
            try {
                secondClient.createBucket("unormal-set-bucket-acl");
                String nonexistentBucket = "unormal-set-bucket-acl";
                try {
                    secondClient.setBucketAcl("unormal-set-bucket-acl", CannedAccessControlList.Private);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                String bucketWithoutOwnership = "oss";
                try {
                    secondClient.setBucketAcl("oss", CannedAccessControlList.Private);
                    Assert.fail((String)"Set bucket acl should not be successful");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"BucketAlreadyExists", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again."));
                }
                String illegalAcl = "IllegalAcl";
                try {
                    CannedAccessControlList.parse("IllegalAcl");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("unormal-set-bucket-acl");
            }
        }
        finally {
            secondClient.deleteBucket("unormal-set-bucket-acl");
        }
    }

    @Test
    public void testUnormalGetBucketAcl() {
        String nonexistentBucket = "unormal-get-bucket-acl";
        try {
            secondClient.getBucketAcl("unormal-get-bucket-acl");
            Assert.fail((String)"Get bucket acl should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.getBucketAcl("oss");
            Assert.fail((String)"Get bucket referer should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
        String bucketUsingDefaultAcl = "bucket-using-default-acl";
        try {
            try {
                secondClient.createBucket("bucket-using-default-acl");
                AccessControlList returnedACL = secondClient.getBucketAcl("bucket-using-default-acl");
                Set<Grant> grants = returnedACL.getGrants();
                Assert.assertEquals((int)0, (int)grants.size());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("bucket-using-default-acl");
            }
        }
        finally {
            secondClient.deleteBucket("bucket-using-default-acl");
        }
    }
}

