/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.datahandlers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.sql.DataSource;
import org.xmlmiddleware.conversions.ConvertObject;
import org.xmlmiddleware.db.SPPreparedStatement;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.Row;
import org.xmlmiddleware.xmldbms.datahandlers.DataHandler;
import org.xmlmiddleware.xmldbms.datahandlers.Parameters;
import org.xmlmiddleware.xmldbms.datahandlers.SQLStrings;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.utils.DMLGenerator;

abstract class DataHandlerBase
implements DataHandler {
    protected Connection m_connection;
    protected DMLGenerator m_dml;
    protected SQLStrings m_strings;
    private boolean m_dirtyConnection = false;
    private int m_commitMode = 1;
    private Hashtable m_refreshCols;

    protected DataHandlerBase() {
    }

    public void initialize(DataSource dataSource, String string, String string2) throws SQLException {
        if (this.m_dirtyConnection) {
            throw new IllegalStateException("Cannot initialize the DataHandler. A connection has uncommitted results.");
        }
        this.m_connection = dataSource.getConnection(string, string2);
        this.m_dml = new DMLGenerator(this.m_connection.getMetaData());
        this.m_strings = new SQLStrings(this.m_dml);
        this.m_commitMode = 1;
        this.m_dirtyConnection = false;
        this.m_refreshCols = new Hashtable();
    }

    public void startDocument(int n) throws SQLException {
        this.checkState();
        this.m_commitMode = n;
        if (this.m_commitMode == 1) {
            this.m_connection.setAutoCommit(true);
        } else if (this.m_commitMode == 2 || this.m_commitMode == 3) {
            this.m_connection.setAutoCommit(false);
        }
        this.m_dirtyConnection = false;
    }

    public void endDocument() throws SQLException {
        this.checkState();
        if (this.m_dirtyConnection && this.m_commitMode == 2) {
            this.m_connection.commit();
            this.m_dirtyConnection = false;
        }
    }

    public abstract void insert(Table var1, Row var2) throws SQLException;

    public void update(Table table, Row row, Column[] columnArray) throws SQLException {
        this.checkState();
        PreparedStatement preparedStatement = this.makeUpdate(table, row, columnArray);
        int n = preparedStatement.executeUpdate();
        if (n == 0) {
            throw new SQLException("[xmldbms] Row to be updated is not present in table.");
        }
        if (n > 1) {
            throw new SQLException("[xmldbms] Primary key not unique. Multiple rows updated!");
        }
        this.executedStatement();
    }

    public void updateOrInsert(Table table, Row row) throws SQLException {
        this.checkState();
        PreparedStatement preparedStatement = this.makeUpdate(table, row, null);
        int n = preparedStatement.executeUpdate();
        if (n == 0) {
            this.insert(table, row);
        } else if (n > 1) {
            throw new SQLException("[xmldbms] Primary key not unique. Multiple rows updated!");
        }
        this.executedStatement();
    }

    public void delete(Table table, Row row, Key key) throws SQLException {
        this.checkState();
        PreparedStatement preparedStatement = this.makeDelete(table, row, key);
        int n = preparedStatement.executeUpdate();
        if (key.getType() == 1) {
            if (n == 0) {
                throw new SQLException("[xmldbms] Row to be deleted is not present in table.");
            }
            if (n > 1) {
                throw new SQLException("[xmldbms] Primary key not unique. Multiple rows deleted!");
            }
        }
        this.executedStatement();
    }

    public void delete(Table table, Key key, Object[] objectArray, String string, Column[] columnArray, Object[] objectArray2) throws SQLException {
        this.checkState();
        PreparedStatement preparedStatement = this.makeDelete(table, key, objectArray, string, columnArray, objectArray2);
        int n = preparedStatement.executeUpdate();
        if (key != null && key.getType() == 1) {
            if (n == 0) {
                throw new SQLException("[xmldbms] Row to be deleted is not present in table.");
            }
            if (n > 1) {
                throw new SQLException("[xmldbms] Primary key not unique. Multiple rows deleted!");
            }
        }
        this.executedStatement();
    }

    public ResultSet select(Table table, Key key, Object[] objectArray, String string, Column[] columnArray, Object[] objectArray2, OrderInfo orderInfo) throws SQLException {
        this.checkState();
        PreparedStatement preparedStatement = this.makeSelect(table, key, objectArray, string, columnArray, objectArray2, orderInfo);
        return preparedStatement.executeQuery();
    }

    protected void checkState() {
        if (this.m_connection == null) {
            throw new IllegalStateException("Invalid state. DataHandler has not been initialized.");
        }
    }

    protected void executedStatement() {
        if (this.m_commitMode == 2) {
            this.m_dirtyConnection = true;
        }
    }

    protected PreparedStatement makeSelect(Table table, Key key, Object[] objectArray, String string, Column[] columnArray, Object[] objectArray2, OrderInfo orderInfo) throws SQLException {
        String string2 = this.m_strings.getSelectWhere(table, key, string, orderInfo);
        PreparedStatement preparedStatement = this.m_connection.prepareStatement(string2);
        int n = 0;
        if (key != null) {
            Column[] columnArray2 = key.getColumns();
            Parameters.setParameters(preparedStatement, 0, columnArray2, objectArray);
            n = columnArray2.length;
        }
        if (columnArray != null) {
            Parameters.setParameters(preparedStatement, n, columnArray, objectArray2);
        }
        return preparedStatement;
    }

    protected PreparedStatement makeInsert(Table table, Row row) throws SQLException {
        Vector vector = row.getColumnVectorFor(table);
        Column[] columnArray = this.getRefreshCols(table);
        int n = 0;
        while (n < columnArray.length) {
            if (vector.contains(columnArray[n]) && row.getColumnValue(columnArray[n]) == null) {
                vector.removeElement(columnArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new Column[vector.size()];
        vector.copyInto(objectArray);
        String string = this.m_dml.getInsert(table, (Column[])objectArray);
        PreparedStatement preparedStatement = this.m_connection.prepareStatement(string);
        Parameters.setParameters(preparedStatement, 0, (Column[])objectArray, row.getColumnValues((Column[])objectArray));
        return preparedStatement;
    }

    protected PreparedStatement makeUpdate(Table table, Row row, Column[] columnArray) throws SQLException {
        Object object;
        Column[] columnArray2 = table.getPrimaryKey().getColumns();
        if (columnArray == null) {
            object = row.getColumnVectorFor(table);
            int n = 0;
            while (n < columnArray2.length) {
                if (!((Vector)object).contains(columnArray2[n])) {
                    throw new SQLException("[xmldbms] Primary key value not supplied for UPDATE.");
                }
                ((Vector)object).removeElement(columnArray2[n]);
                ++n;
            }
            Enumeration enumeration = table.getUniqueKeys();
            while (enumeration.hasMoreElements()) {
                Column[] columnArray3 = ((Key)enumeration.nextElement()).getColumns();
                int n2 = 0;
                while (n2 < columnArray3.length) {
                    ((Vector)object).removeElement(columnArray3[n2]);
                    ++n2;
                }
            }
            columnArray = new Column[((Vector)object).size()];
            ((Vector)object).copyInto(columnArray);
        }
        object = this.m_dml.getUpdate(table, table.getPrimaryKey(), columnArray);
        PreparedStatement preparedStatement = this.m_connection.prepareStatement((String)object);
        Parameters.setParameters(preparedStatement, 0, columnArray, row.getColumnValues(columnArray));
        Parameters.setParameters(preparedStatement, columnArray.length, columnArray2, row.getColumnValues(columnArray2));
        return preparedStatement;
    }

    protected PreparedStatement makeDelete(Table table, Row row, Key key) throws SQLException {
        if (key == null) {
            key = table.getPrimaryKey();
        }
        String string = this.m_strings.getDelete(table, key);
        PreparedStatement preparedStatement = this.m_connection.prepareStatement(string);
        Column[] columnArray = key.getColumns();
        Parameters.setParameters(preparedStatement, 0, columnArray, row.getColumnValues(columnArray));
        return preparedStatement;
    }

    protected PreparedStatement makeDelete(Table table, Key key, Object[] objectArray, String string, Column[] columnArray, Object[] objectArray2) throws SQLException {
        String string2 = this.m_strings.getDeleteWhere(table, key, string);
        PreparedStatement preparedStatement = this.m_connection.prepareStatement(string2);
        int n = 0;
        if (key != null) {
            Column[] columnArray2 = key.getColumns();
            Parameters.setParameters(preparedStatement, 0, columnArray2, objectArray);
            n = columnArray2.length;
        }
        if (columnArray != null) {
            Parameters.setParameters(preparedStatement, n, columnArray, objectArray2);
        }
        return preparedStatement;
    }

    protected Column[] getRefreshCols(Table table) {
        Object object;
        if (this.m_refreshCols.contains(table)) {
            return (Column[])this.m_refreshCols.get(table);
        }
        Vector<Object> vector = new Vector<Object>();
        Key key = table.getPrimaryKey();
        if (key.getKeyGeneration() == 3) {
            object = key.getColumns();
            int n = 0;
            while (n < ((Object)object).length) {
                vector.addElement(object[n]);
                ++n;
            }
        }
        object = table.getUniqueKeys();
        while (object.hasMoreElements()) {
            Key key2 = (Key)object.nextElement();
            if (key2.getKeyGeneration() != 3) continue;
            Column[] columnArray = key2.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                vector.addElement(columnArray[n]);
                ++n;
            }
        }
        Object[] objectArray = new Column[vector.size()];
        vector.copyInto(objectArray);
        this.m_refreshCols.put(table, objectArray);
        return objectArray;
    }

    protected Key createColumnKey(String string, int n) {
        Column[] columnArray = new Column[]{Column.create(string)};
        columnArray[0].setType(n);
        Key key = Key.createPrimaryKey(null);
        key.setColumns(columnArray);
        return key;
    }

    protected PreparedStatement getRawStatement(PreparedStatement preparedStatement) {
        if (preparedStatement instanceof SPPreparedStatement) {
            return ((SPPreparedStatement)preparedStatement).getUnderlyingStatement();
        }
        return preparedStatement;
    }

    protected void setColumnValue(Row row, Column column, Object object) throws SQLException {
        try {
            row.setColumnValue(column, ConvertObject.convertObject(object, column.getType(), column.getFormatter()));
            return;
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SQLException("[xmldbms]Conversion error: " + xMLMiddlewareException.getMessage());
        }
    }
}

