/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.factories;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class DBNameChecker {
    private DatabaseMetaData meta;
    private String extraChars;
    private int maxColumnNameLen;
    private int maxColumnsInTable;
    private int maxTableNameLen;
    private boolean mixedCase;
    private boolean lowerCase;
    private boolean upperCase;
    private boolean useCatalogs;
    private boolean useSchemas;
    private Hashtable catalogNames = new Hashtable();
    private char[] escape;
    private static final String str = new String();

    public DBNameChecker() {
        this.initialize();
    }

    public DBNameChecker(Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("conn argument must not be null.");
        }
        this.initialize(connection);
    }

    public void setConnection(Connection connection) throws SQLException {
        if (connection == null) {
            this.initialize();
            return;
        }
        this.initialize(connection);
    }

    public void startNewSession() {
        this.catalogNames.clear();
    }

    public String checkTableName(String string, String string2, String string3) throws SQLException, XMLMiddlewareException {
        if (string3 == null) {
            throw new IllegalArgumentException("tableName argument must not be null.");
        }
        String string4 = string3;
        string4 = this.checkCharacters(string4);
        string4 = this.checkLength(string4, this.maxTableNameLen);
        string4 = this.checkCase(string4);
        Hashtable hashtable = this.getTableNames(string, string2);
        string4 = this.checkTableNameCollisions(string, string2, string4, hashtable);
        return string4;
    }

    public String checkColumnName(String string, String string2, String string3, String string4) throws XMLMiddlewareException {
        if (string3 == null) {
            throw new IllegalArgumentException("tableName argument must not be null.");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("columnName argument must not be null.");
        }
        Hashtable hashtable = this.getTableNames(string, string2);
        Hashtable hashtable2 = (Hashtable)hashtable.get(string3);
        if (hashtable2 == null) {
            throw new IllegalArgumentException("tableName has not been used in a call to checkTableName in this session.");
        }
        String string5 = string4;
        string5 = this.checkCharacters(string5);
        string5 = this.checkLength(string5, this.maxColumnNameLen);
        string5 = this.checkCase(string5);
        string5 = this.checkColumnNameCollisions(string5, hashtable2);
        return string5;
    }

    private void initialize() {
        this.meta = null;
        this.extraChars = new String();
        this.maxColumnNameLen = 30;
        this.maxColumnsInTable = 32;
        this.maxTableNameLen = 30;
        this.mixedCase = false;
        this.lowerCase = false;
        this.upperCase = true;
        this.escape = new char[0];
        this.useCatalogs = false;
        this.useSchemas = false;
    }

    private void initialize(Connection connection) throws SQLException {
        this.meta = connection.getMetaData();
        this.extraChars = this.meta.getExtraNameCharacters();
        this.maxColumnNameLen = this.meta.getMaxColumnNameLength();
        this.maxColumnsInTable = this.meta.getMaxColumnsInTable();
        this.maxTableNameLen = this.meta.getMaxTableNameLength();
        this.mixedCase = this.meta.supportsMixedCaseQuotedIdentifiers() || this.meta.storesMixedCaseQuotedIdentifiers();
        this.lowerCase = this.meta.storesLowerCaseQuotedIdentifiers();
        this.upperCase = this.meta.storesUpperCaseQuotedIdentifiers();
        this.escape = this.meta.getSearchStringEscape().toCharArray();
        this.useCatalogs = this.meta.supportsCatalogsInDataManipulation();
        this.useSchemas = this.meta.supportsSchemasInDataManipulation();
    }

    private Hashtable getTableNames(String string, String string2) {
        Hashtable hashtable;
        Hashtable hashtable2;
        if (string == null) {
            string = str;
        }
        if (string2 == null) {
            string2 = str;
        }
        if ((hashtable2 = (Hashtable)this.catalogNames.get(string)) == null) {
            hashtable2 = new Hashtable();
            this.catalogNames.put(string, hashtable2);
        }
        if ((hashtable = (Hashtable)hashtable2.get(string2)) == null) {
            hashtable = new Hashtable();
            hashtable2.put(string2, hashtable);
        }
        return hashtable;
    }

    private String checkCharacters(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                cArray2[n++] = c;
            } else if (this.extraChars.indexOf(c) != -1) {
                cArray2[n++] = c;
            }
            ++n2;
        }
        return new String(cArray2, 0, n);
    }

    private String checkLength(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    private String checkCase(String string) {
        if (this.mixedCase) {
            return string;
        }
        if (this.lowerCase) {
            return string.toLowerCase();
        }
        return string.toUpperCase();
    }

    /*
     * Unable to fully structure code
     */
    private String checkTableNameCollisions(String var1_1, String var2_2, String var3_3, Hashtable var4_4) throws SQLException, XMLMiddlewareException {
        var8_5 = 1;
        var5_6 = var3_3;
        var6_7 = null;
        var7_8 = null;
        ** GOTO lbl17
        {
            var5_6 = this.getSuffixedName(var3_3, var8_5, this.maxTableNameLen);
            ++var8_5;
            do {
                if (var4_4.get(var5_6) != null) continue block0;
                var6_7 = var5_6;
                if (var5_6.equals(var7_8)) continue;
                while (this.tableNameInDB(var1_1, var2_2, var5_6)) {
                    var5_6 = this.getSuffixedName(var3_3, var8_5, this.maxTableNameLen);
                    ++var8_5;
                }
                var7_8 = var5_6;
lbl17:
                // 3 sources

            } while (!var5_6.equals(var6_7));
        }
        var4_4.put(var5_6, new Hashtable<K, V>());
        return var5_6;
    }

    private String checkColumnNameCollisions(String string, Hashtable hashtable) throws XMLMiddlewareException {
        String string2 = string;
        int n = 1;
        while (hashtable.get(string2) != null) {
            string2 = this.getSuffixedName(string, n, this.maxColumnNameLen);
            ++n;
        }
        hashtable.put(string2, str);
        return string2;
    }

    private boolean tableNameInDB(String string, String string2, String string3) throws SQLException {
        if (this.meta == null) {
            return false;
        }
        if (!this.useCatalogs) {
            string = null;
        }
        string2 = !this.useSchemas ? null : this.escapeDBName(string2);
        string3 = this.escapeDBName(string3);
        ResultSet resultSet = this.meta.getTables(string, string2, string3, null);
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    private String escapeDBName(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[string.length() * (this.escape.length + 1)];
        int n2 = 0;
        while (n2 < string.length()) {
            if (cArray[n2] == '_' || cArray[n2] == '%') {
                int n3 = 0;
                while (n3 < this.escape.length) {
                    cArray2[n] = this.escape[n3];
                    ++n;
                    ++n3;
                }
            }
            cArray2[n] = cArray[n2];
            ++n;
            ++n2;
        }
        return new String(cArray2, 0, n);
    }

    private String getSuffixedName(String string, int n, int n2) throws XMLMiddlewareException {
        String string2 = string;
        String string3 = String.valueOf(n);
        if (string2.length() + string3.length() > n2) {
            int n3 = n2 - (string2.length() + string3.length() - n2);
            if (n3 <= 0) {
                throw new XMLMiddlewareException("Cannot construct a unique name from " + string2);
            }
            string2 = string2.substring(0, n3);
        }
        return String.valueOf(string2) + string3;
    }
}

