/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.datahandlers;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.Key;
import org.xmlmiddleware.xmldbms.maps.OrderInfo;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.utils.DMLGenerator;

public class SQLStrings {
    protected Hashtable m_strings;
    protected DMLGenerator m_dml;

    public SQLStrings(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.m_dml = new DMLGenerator(databaseMetaData);
        this.m_strings = new Hashtable();
    }

    public SQLStrings(DMLGenerator dMLGenerator) {
        this.m_dml = dMLGenerator;
        this.m_strings = new Hashtable();
    }

    public String getInsert(Table table) {
        String string = "INSERT_" + table.getUniversalName();
        if (!this.m_strings.containsKey(string)) {
            this.m_strings.put(string, this.m_dml.getInsert(table));
        }
        return (String)this.m_strings.get(string);
    }

    public String getSelectRow(Table table, Key key, OrderInfo orderInfo) {
        String string = "SELECTROW_" + table.getUniversalName() + key.getName();
        if (orderInfo != null) {
            string = String.valueOf(string) + ";" + String.valueOf(orderInfo.hashCode());
        }
        if (!this.m_strings.containsKey(string)) {
            this.m_strings.put(string, this.m_dml.getSelect(table, key, orderInfo));
        }
        return (String)this.m_strings.get(string);
    }

    public String getSelectKey(Table table, Key key) {
        String string = "SELECTKEY_" + table.getUniversalName() + key.getName();
        if (!this.m_strings.containsKey(string)) {
            this.m_strings.put(string, this.m_dml.getSelect(table, key));
        }
        return (String)this.m_strings.get(string);
    }

    public String getSelectWhere(Table table, Key key, String string, OrderInfo orderInfo) {
        String string2 = "SELECTWHERE_" + table.getUniversalName();
        if (key != null) {
            string2 = String.valueOf(string2) + key.getName();
        }
        if (string != null) {
            string2 = String.valueOf(string2) + ";" + String.valueOf(string.hashCode());
        }
        if (orderInfo != null) {
            string2 = String.valueOf(string2) + ";" + String.valueOf(orderInfo.hashCode());
        }
        if (!this.m_strings.containsKey(string2)) {
            this.m_strings.put(string2, this.m_dml.getSelect(table, key, string, orderInfo));
        }
        return (String)this.m_strings.get(string2);
    }

    public String getUpdate(Table table, Key key, Column[] columnArray) {
        return this.m_dml.getUpdate(table, key, columnArray);
    }

    public String getDelete(Table table, Key key) {
        String string = "DELETE_" + table.getUniversalName() + key.getName();
        if (!this.m_strings.containsKey(string)) {
            this.m_strings.put(string, this.m_dml.getDelete(table, key));
        }
        return (String)this.m_strings.get(string);
    }

    public String getDeleteWhere(Table table, Key key, String string) {
        String string2 = "DELETEWHERE_" + table.getUniversalName();
        if (key != null) {
            string2 = String.valueOf(string2) + key.getName();
        }
        if (string != null) {
            string2 = String.valueOf(string2) + ";" + String.valueOf(string.hashCode());
        }
        if (!this.m_strings.containsKey(string2)) {
            this.m_strings.put(string2, this.m_dml.getDeleteWhere(table, key, string));
        }
        return (String)this.m_strings.get(string2);
    }
}

