/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.xmlmiddleware.db.ConnectionID;
import org.xmlmiddleware.db.ConnectionPool;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class JDBC2DataSource
extends ConnectionPool
implements DataSource {
    protected DataSource m_dataSource;

    public JDBC2DataSource(DataSource dataSource) throws SQLException {
        this.m_dataSource = dataSource;
    }

    public JDBC2DataSource(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("JDBC2DataSource: JNDIContext must not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("JDBC2DataSource: DataSource must not be null.");
        }
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", string);
            InitialContext initialContext = new InitialContext(hashtable);
            this.m_dataSource = (DataSource)initialContext.lookup(string2);
            return;
        }
        catch (NamingException namingException) {
            throw new IllegalArgumentException("NamingException: " + namingException.getMessage());
        }
    }

    protected Object createObject(Object object) throws XMLMiddlewareException {
        if (!(object instanceof ConnectionID)) {
            throw new XMLMiddlewareException("JDBC2DataSource: Object ID must be a ConnectionID.");
        }
        try {
            ConnectionID connectionID = (ConnectionID)object;
            if (connectionID.username == null || connectionID.password == null) {
                return this.m_dataSource.getConnection();
            }
            return this.m_dataSource.getConnection(connectionID.username, connectionID.password);
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
    }

    protected void closeObject(Object object) throws XMLMiddlewareException {
        if (!(object instanceof Connection)) {
            throw new XMLMiddlewareException("Invalid connection object");
        }
        try {
            ((Connection)object).close();
            return;
        }
        catch (SQLException sQLException) {
            throw new XMLMiddlewareException(sQLException);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.checkOut(new ConnectionID());
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            if (xMLMiddlewareException.getException() instanceof SQLException) {
                throw (SQLException)xMLMiddlewareException.getException();
            }
            throw new SQLException(xMLMiddlewareException.getMessage());
        }
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        try {
            return (Connection)this.checkOut(new ConnectionID(string, string2));
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            if (xMLMiddlewareException.getException() instanceof SQLException) {
                throw (SQLException)xMLMiddlewareException.getException();
            }
            throw new SQLException(xMLMiddlewareException.getMessage());
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.m_dataSource.setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.m_dataSource.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_dataSource.getLoginTimeout();
    }
}

