/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.SocketUtilInternal;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

class JDK13SocketUtilImpl
extends SocketUtilInternal {
    private static final Logger LOG = Logger.getLogger(JDK13SocketUtilImpl.class);

    JDK13SocketUtilImpl() {
    }

    String getSocketDetail(Socket socket) {
        if (socket == null) {
            return "The Socket object is null!";
        }
        StringBuffer sb = new StringBuffer(128);
        try {
            sb.append("Socket detail: receiveBuf<").append(socket.getReceiveBufferSize());
            sb.append(">/sendBuf<").append(socket.getSendBufferSize());
            sb.append(">/timeout<").append(socket.getSoTimeout());
            sb.append(">/keepAlive<").append(socket.getKeepAlive());
            sb.append(">/tcpNoDelay<").append(socket.getTcpNoDelay());
            sb.append(">/soLinger<").append(socket.getSoLinger());
            sb.append(">/class<").append(socket.getClass().getName());
            sb.append(">/toString<").append(socket.toString());
            sb.append('>');
        }
        catch (Throwable e) {
            LOG.warn((Object)("getDetail fail! socket=" + socket), e);
        }
        return sb.toString();
    }

    String getSocketDetail(ServerSocket ss) {
        if (ss == null) {
            return "The ServerSocket object is null!";
        }
        StringBuffer sb = new StringBuffer(128);
        try {
            sb.append("Socket detail: timeout<").append(ss.getSoTimeout());
            sb.append(">/class<").append(ss.getClass().getName());
            sb.append(">/toString<").append(ss.toString());
            sb.append('>');
        }
        catch (Throwable e) {
            LOG.warn((Object)"fail to getSocketDetail!", e);
        }
        return sb.toString();
    }
}

