/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.sp.resource;

import com.trs.idm.saml.common.SPConfig;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.saml.sp.resource.IResourceManager;
import com.trs.idm.util.StringHelper;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class StdResourceManager
implements IResourceManager {
    private static final Logger LOG = Logger.getLogger(StdResourceManager.class);
    private IServiceProvider sp;
    private Set proPathSet;
    private Set proFileSet;
    private boolean protectAll;

    public StdResourceManager(IServiceProvider sp) {
        this.sp = sp;
    }

    public boolean isProtectResource(String fullTargetURI) {
        if (StringHelper.isEmpty(fullTargetURI)) {
            LOG.warn((Object)"targetURI is null , return null");
            return false;
        }
        LOG.debug((Object)("fullTargetURI: " + fullTargetURI));
        String relativeTargetURI = fullTargetURI;
        if (relativeTargetURI != null && relativeTargetURI.startsWith("/idsSPPages")) {
            LOG.debug((Object)("[" + relativeTargetURI + "] is sp self page, is not protected resource"));
            return false;
        }
        if (this.protectAll) {
            LOG.debug((Object)"protect all resource!");
            return true;
        }
        if (this.proPathSet.size() == 0 && this.proFileSet.size() == 0) {
            LOG.debug((Object)("proPathSet.size(): " + this.proPathSet.size() + "; proFileSet.size(): " + this.proFileSet.size()));
            return false;
        }
        if (this.isProPath(relativeTargetURI)) {
            LOG.debug((Object)("relativeTargetURI[" + relativeTargetURI + "] is proPath"));
            return true;
        }
        if (this.isProFile(relativeTargetURI)) {
            LOG.debug((Object)("relativeTargetURI[" + relativeTargetURI + "] is proFile"));
            return true;
        }
        return false;
    }

    private boolean isProPath(String relativeTargetURI) {
        if (StringHelper.isEmpty(relativeTargetURI)) {
            LOG.warn((Object)"relativeTargetURI is null, return false");
        }
        if (this.proPathSet.contains(relativeTargetURI)) {
            LOG.debug((Object)(String.valueOf(relativeTargetURI) + "is proteced"));
            return true;
        }
        boolean isProPath = false;
        for (String proPath : this.proPathSet) {
            if (!relativeTargetURI.startsWith(proPath)) continue;
            isProPath = true;
            break;
        }
        return isProPath;
    }

    private boolean isProFile(String relativeTargetURI) {
        if (StringHelper.isEmpty(relativeTargetURI)) {
            LOG.warn((Object)"relativeTargetURI is null, return false");
        }
        if (this.proFileSet.contains(relativeTargetURI)) {
            LOG.debug((Object)(String.valueOf(relativeTargetURI) + "is proteced"));
            return true;
        }
        return false;
    }

    private void initProSet(String allProtectedResource) {
        if (StringHelper.isEmpty(allProtectedResource)) {
            LOG.warn((Object)"protectedResource Set init faile! ");
            return;
        }
        String[] protectedResources = StringHelper.splitAndTrim(allProtectedResource, ";");
        int i = 0;
        while (i < protectedResources.length) {
            String singleProtectedResource = protectedResources[i];
            if (StringHelper.isEmpty(singleProtectedResource)) {
                LOG.warn((Object)("meaningless space found in allProtectedResource{" + allProtectedResource + "}"));
            } else {
                if ("*.*".equals(singleProtectedResource)) {
                    this.protectAll = true;
                }
                if (singleProtectedResource.indexOf(".") > 0) {
                    this.proFileSet.add(singleProtectedResource);
                } else {
                    this.proPathSet.add(singleProtectedResource);
                }
            }
            ++i;
        }
    }

    public void start() {
        this.proFileSet = new HashSet();
        this.proPathSet = new HashSet();
        String allProtectedResource = this.sp.getConfig().getConfig(SPConfig.BASIC_RESOURCE_PROTECTED, "*.*");
        this.initProSet(allProtectedResource);
    }

    public void stop() {
        this.proFileSet = null;
        this.proPathSet = null;
    }

    public boolean isProtectAll() {
        return this.protectAll;
    }
}

