/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.exception.IdMException;
import com.trs.idm.http.PureClient;
import com.trs.idm.http.Response;
import com.trs.idm.interact.agent.AgentVersion;
import com.trs.idm.interact.agent.IClientTransfer;
import com.trs.idm.interact.protocol.PacketUtil;
import com.trs.idm.interact.protocol.ProtocolPacket;
import com.trs.idm.interact.protocol.RequestPacket;
import com.trs.idm.interact.protocol.ResponsePacket;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.EnvUtil;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.StringHelper;
import com.trs.idm.util.UrlUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.log4j.Logger;

public class HTTPClientTransfer
implements IClientTransfer {
    private static final Logger LOG = Logger.getLogger(HTTPClientTransfer.class);
    private String agentName;
    private String host;
    private int port;
    private Properties props;
    private String serverInfo;
    private String nodeKeyOfIDSServer = "";
    private String url;
    private static final String UNKNOW_INFO = "unknow";

    public HTTPClientTransfer(String host, int port, String agentName, String serverInfo, Properties props) {
        this.host = host;
        this.port = port;
        this.agentName = agentName;
        this.serverInfo = StringHelper.isEmpty(serverInfo) ? UNKNOW_INFO : serverInfo;
        this.props = props;
        this.url = props.getProperty("protocol.http.url");
    }

    public void close() {
    }

    public String getHost() {
        return this.host;
    }

    public String getNodeKeyOfIDSServer() {
        return this.nodeKeyOfIDSServer;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getResponse(byte[] req) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("user-agent", "TRS Identity Server");
        headers.put("coAppName", Base64Util.encode(this.agentName.getBytes()));
        NameValuePair[] pairs = new NameValuePair[]{new NameValuePair()};
        pairs[0].setName("idsRequest");
        pairs[0].setValue(Base64Util.encode(req));
        Response httpResponse = PureClient.postHttpRequest(this.url, headers, null, pairs);
        if (httpResponse.isFail()) {
            Throwable t = httpResponse.getError();
            if (t != null && t instanceof IOException) {
                LOG.error((Object)("get http response[" + httpResponse + "] failed by url[" + this.url + "], headers[" + headers + "], pairs[" + pairs + "], Exception:"), t);
                throw (IOException)t;
            }
            LOG.error((Object)("run error while get http response[" + httpResponse + "] failed by url[" + this.url + "], headers[" + headers + "], pairs[" + pairs + "]"), t);
        }
        String responseBody = httpResponse.getResponseBodyAsTrimStr();
        byte[] decodeBytes = Base64Util.decodeBytes(UrlUtil.decode(responseBody));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("send idsRequest: " + pairs[0].getValue() + " to " + this.url + ", responseBodyAsTrimStr: " + responseBody + "; decodeBytes: [" + StringHelper.toString(decodeBytes) + "]"));
        }
        return decodeBytes;
    }

    public void init() throws IOException {
        byte[] bs = new byte[]{};
        try {
            RequestPacket req = new RequestPacket(100, bs, 2, null);
            this.getResponse(req.toBytes());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("http ping fail on init! agent=" + this.agentName), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)("http ping disconnected! agent=" + this.agentName), (Throwable)e);
            throw e;
        }
        LOG.info((Object)"init http client transfer successfully!");
    }

    public boolean isSocketAlive() {
        return true;
    }

    public void initCoAppConfig() throws IOException {
        String logoutUri = this.props.getProperty("logout.uri", "/logout.jsp");
        String allowGuest = this.props.getProperty("allow.anonymous", "n");
        String loginActionUri = PropertyUtil.getTrimString(this.props, "loginAction.uri", "/login");
        String loginUserNameField = PropertyUtil.getTrimString(this.props, "sso.selfLoginPage.userName.field", "userName");
        String loginPasswordField = PropertyUtil.getTrimString(this.props, "sso.selfLoginPage.password.field", "password");
        String ifUserNotExistOnIDSUseCoAppLoigc = PropertyUtil.getTrimString(this.props, "sso.ifUserNotExistOnIDS.useLocalLoginLogic", "false");
        String actorClass = PropertyUtil.getTrimString(this.props, "coAppActor.className", "unkown");
        String afterLoginOkGoToUrl = PropertyUtil.getTrimString(this.props, "afterLoginOk.gotoUrl", "notConfigure");
        String afterLoginFailGoToUrl = PropertyUtil.getTrimString(this.props, "afterLoginFail.gotoUrl", "notConfigure");
        String ssoUrl = PropertyUtil.getTrimString(this.props, "ssoUrl", "notConfigure");
        String switchOn = PropertyUtil.getTrimString(this.props, "sso.on", "true");
        RequestPacket req = null;
        try {
            req = new RequestPacket(99, new String[]{this.agentName, logoutUri, allowGuest, this.serverInfo, EnvUtil.getJavaEnvInfo(), AgentVersion.getReleaseInfo(), AgentVersion.getSourceLocation(), System.getProperty("os.name"), System.getProperty("user.name"), System.getProperty("user.dir"), loginActionUri, loginUserNameField, loginPasswordField, ifUserNotExistOnIDSUseCoAppLoigc, actorClass, afterLoginOkGoToUrl, afterLoginFailGoToUrl, ssoUrl, switchOn}, null);
        }
        catch (IdMException e) {
            LOG.error((Object)"this exception should NOT happen!", (Throwable)e);
            throw new RuntimeException(e);
        }
        byte[] bytesResp = null;
        try {
            bytesResp = this.getResponse(req.toBytes());
        }
        catch (IOException e) {
            LOG.error((Object)("run error while get http response and init coApp config by RequestPacket[" + req + "]"), (Throwable)e);
            throw e;
        }
        ProtocolPacket packet = PacketUtil.parseFromBytes(bytesResp);
        if (!(packet instanceof ResponsePacket)) {
            LOG.error((Object)("received: [" + packet + "] not a ResponsePacket! IDS Server: [" + this.host + ":" + this.port + "]"));
            throw new IOException("Received is not a IDS ResponsePacket!");
        }
        ResponsePacket resp = (ResponsePacket)packet;
        if (resp.getErrCode() != 1) {
            throw new IOException("the coAppName:[" + this.agentName + "] not exist on IDS Server: [" + this.host + ":" + this.port + "]");
        }
        this.nodeKeyOfIDSServer = resp.getData(0);
    }
}

