/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.interact.agent.IAgent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

class AsyncTimeoutNotifier
implements Runnable {
    private static final long SLEEP_MS = 120000L;
    private static final Logger LOG = Logger.getLogger(AsyncTimeoutNotifier.class);
    private List timeoutedSessionIds;
    private List notifyFailedSessionIds;
    private int maxAllowSessionIdNumber;
    private boolean needGc;
    private IAgent agent;

    AsyncTimeoutNotifier(IAgent agent) {
        this.agent = agent;
        this.timeoutedSessionIds = Collections.synchronizedList(new LinkedList());
        this.notifyFailedSessionIds = Collections.synchronizedList(new LinkedList());
        this.maxAllowSessionIdNumber = agent.getPropertyAsInt("maxAllowAsyncSessionIdNumber", 100000);
        String strNeedGc = agent.getProperty("clearTimeoutedSession.gc", "false");
        this.needGc = Boolean.getBoolean(strNeedGc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int size = 0;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                String sessionId;
                int i;
                size = this.timeoutedSessionIds.size();
                if (size > this.maxAllowSessionIdNumber) {
                    List list = this.timeoutedSessionIds;
                    synchronized (list) {
                        this.timeoutedSessionIds.clear();
                    }
                    if (this.needGc) {
                        System.gc();
                    }
                    LOG.warn((Object)("timeoutedSessionIds size is bigger than maxAllowSessionIdNumber! So abandon all timeoutedSessionIds!  timeoutedSessionIds size is: " + size + ", maxAllowSessionIdNumber is : " + this.maxAllowSessionIdNumber));
                } else {
                    String[] timeoutedSessions = this.timeoutedSessionIds.toArray(new String[0]);
                    i = 0;
                    while (i < timeoutedSessions.length) {
                        sessionId = null;
                        try {
                            sessionId = timeoutedSessions[i];
                            if (sessionId != null) {
                                this.agent.notifyTimeout(sessionId);
                            } else {
                                LOG.warn((Object)("timeoutedSession(" + sessionId + ") is null."));
                            }
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("timeoutedSession(" + sessionId + ") notified timeout failed."), (Throwable)e);
                            this.notifyFailedSessionIds.add(sessionId);
                        }
                        ++i;
                    }
                }
                size = this.notifyFailedSessionIds.size();
                if (size > this.maxAllowSessionIdNumber) {
                    this.notifyFailedSessionIds.clear();
                    LOG.warn((Object)("notifyFailedSessionIds size is bigger than maxAllowSessionIdNumber! So abandon all notifyFailedSessionIds!  notifyFailedSessionIds size is: " + size + ", maxAllowSessionIdNumber is : " + this.maxAllowSessionIdNumber));
                    if (this.needGc) {
                        System.gc();
                        LOG.warn((Object)"do gc while clear notifyFailedSessionIds");
                    }
                } else {
                    String[] notifyFailedSessions = this.notifyFailedSessionIds.toArray(new String[0]);
                    i = 0;
                    while (i < notifyFailedSessions.length) {
                        sessionId = null;
                        try {
                            sessionId = notifyFailedSessions[i];
                            if (sessionId != null) {
                                this.agent.notifyTimeout(sessionId);
                            } else {
                                LOG.warn((Object)("notifyFailedSession(" + sessionId + ") is null."));
                            }
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("notifyFailedSession(" + sessionId + ") notified timeout failed."), (Throwable)e);
                            this.notifyFailedSessionIds.add(sessionId);
                        }
                        ++i;
                    }
                }
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"notifyTimeoutThread interrupted..");
                    break;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("error happen in AsyncTimeout Thread\uff0ctimeoutedSession size: " + size), (Throwable)e);
            }
        }
        this.timeoutedSessionIds = null;
        this.notifyFailedSessionIds = null;
        LOG.info((Object)"notifyTimeoutThread finished.");
    }

    void addNotify(String sessionId) {
        if (sessionId == null || sessionId.length() == 0) {
            return;
        }
        this.timeoutedSessionIds.add(sessionId);
    }

    public List getTimeoutedSessionIds() {
        return this.timeoutedSessionIds;
    }

    public List getNotifyFailedSessionIds() {
        return this.notifyFailedSessionIds;
    }

    public int getMaxAllowSessionIdNumber() {
        return this.maxAllowSessionIdNumber;
    }
}

